<?php

/**
 * û
 *
 * @author xiaoxia.xu <xiaoxia.xuxx@aliyun-inc.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.phpwind.com
 * @version $Id: PwUserActiveCode.php 7291 2012-04-01 03:39:14Z xiaoxia.xuxx $
 * @package src.service.user
 */
class PwUserActiveCode {

	const REGIST = 1;//ע
	const RESETPWD = 2;//һ
	
	/** 
	 * ûIDϢ
	 *
	 * @param int $uid ûID
	 * @param int $typeid 
	 * @return array
	 */
	public function getInfoByUid($uid, $typeid = self::REGIST) {
		if (($uid = intval($uid)) <= 0) return array();
		return $this->getDao()->getInfoByUid($uid, $typeid);
	}
	
	/** 
	 * Ӽ
	 *
	 * @param int $uid ûID
	 * @param string $email ͼEmail
	 * @param string $code 
	 * @param int $time ͼʱ
	 * @param int $typeid 
	 * @return mixed
	 */
	public function addActiveCode($uid, $email, $code, $time, $typeid = self::REGIST) {
		if (($uid = intval($uid)) <= 0) return new PwError('USER:illegal.id');
		if (!WindValidator::isEmail($email)) return new PwError('USER:user.error.-7');
		$data = array('uid' => $uid, 'email' => $email, 'code' => $code, 'send_time' => $time, 'typeid' => $typeid);
		return $this->getDao()->insert($data);
	}
	
	/** 
	 * ʺ
	 *
	 * @param int $uid ûID
	 * @param int $activeTime ʱ
	 * @return boolean
	 */
	public function activeCode($uid, $activeTime) {
		if (($uid = intval($uid)) <= 0) return new PwError('USER:illegal.id');
		return $this->getDao()->update($uid, $activeTime);
	}
	
	/** 
	 * ûIDɾϢ
	 *
	 * @param int $uid
	 * @return mixed
	 */
	public function deleteInfoByUid($uid) {
		if (($uid = intval($uid)) <= 0) return false;
		return $this->getDao()->deleteByUid($uid);
	}
	
	/** 
	 * Dao
	 *
	 * @return PwUserActiveCodeDao
	 */
	private function getDao() {
		return Wekit::loadDao('user.dao.PwUserActiveCodeDao');
	}
}