<?php
/**
 * ûDS
 * ûΪֹ
 *  1ֹû
 *  2: ֹûʹͷ
 *  4 ֹûʹǩ
 *
 * @author xiaoxia.xu <xiaoxia.xuxx@aliyun-inc.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.phpwind.com
 * @version $Id: PwUserBan.php 16415 2012-08-23 07:53:40Z xiaoxia.xuxx $
 * @package src.service.user
 */
class PwUserBan {
	const BAN_SPEAK = 1;
	const BAN_AVATAR = 2;
	const BAN_SIGN = 4;
	const BAN_ALL = 7;

	/**
	 * ûнֹϢ
	 *
	 * @param int $uid ûID
	 * @return array
	 */
	public function getBanInfo($uid) {
		if (0 >= ($uid = intval($uid))) return array();
		return $this->_getDao()->getBanInfo($uid);
	}
	
	/**
	 * ûIDͽֹͻøûĽֹϢ
	 *
	 * @param int $uid ûID
	 * @param int $typeid ֹ
	 * @return array
	 */
	public function getBanInfoByTypeid($uid, $typeid = self::BAN_SIGN) {
		if (0 >= ($uid = intval($uid))) return array();
		return $this->_getDao()->getBanInfoByTypeid($uid, $typeid);
	}
	
	/**
	 * ݽֹͼIDûuidĽֹϢ
	 *
	 * @param int $uid ûID
	 * @param int $typeid ֹ
	 * @param int $fid ID
	 * @return array
	 */
	public function getBanInfoByTypeidAndFid($uid, $typeid = self::BAN_SPEAK, $fid = 0) {
		if (0 >= ($uid = intval($uid))) return array();
		return $this->_getDao()->getBanInfoByTypeidAndFid($uid, $typeid, $fid);
	}
	
	/**
	 * ûIDûֹϢ
	 *
	 * @param array $uids ûIDб
	 * @param int $typeid ֹ
	 * @return array
	 */
	public function fetchBanInfoByUid($uids, $typeid = self::BAN_SPEAK) {
		if (!$uids) return array();
		return $this->_getDao()->fetchBanInfoByUid($uids, $typeid);
	}
	
	/**
	 * ݽֹIDȡ
	 *
	 * @param array $ids
	 * @return array
	 */
	public function fetchBanInfo($ids) {
		if (!$ids) return array();
		return $this->_getDao()->fetchBanInfo($ids);
	}
	
	/** 
	 * ӽû
	 *
	 * @param PwUserBanInfoDm $dm ûֹDM
	 * @return boolean
	 */
	public function addBanInfo(PwUserBanInfoDm $dm) {
		if (true != ($result = $dm->beforeAdd())) return $result;
		return $this->_getDao()->addBanInfo($dm->getData());
	}
	
	/**
	 * ֹû
	 *
	 * @param array $data
	 * @return array
	 */
	public function batchAddBanInfo($data) {
		if (!$data) return false;
		return $this->_getDao()->batchAddBanInfo($data);
	}
	
	/**
	 * ûIDɾûϢ
	 *
	 * @param int $uid
	 * @return boolean
	 */
	public function deleteByUid($uid) {
		$uid = intval($uid);
		if ($uid < 1) return false;
		return $this->_getDao()->deleteByUid($uid);
	}
	
	/** 
	 * ûIDɾûϢ
	 *
	 * @param array $uids ûIDб
	 * @return int|boolean
	 */
	public function batchDeleteByUids($uids) {
		if (!$uids) return false;
		return $this->_getDao()->batchDeleteByUids($uids);
	}
	
	/**
	 * IDбɾֹ¼
	 *
	 * @param array $ids ֹ¼IDб
	 * @return boolean
	 */
	public function batchDelete($ids) {
		if (!$ids) return false;
		return $this->_getDao()->batchDelete($ids);
	}
	
	/**
	 * ͳ
	 *
	 * @param PwUserBanSo $searchVo
	 * @return int
	 */
	public function countWithCondition(PwUserBanSo $searchVo) {
		return $this->_getDao()->countByCondition($searchVo->getData());
	}
	
	/**
	 * ؼб
	 *
	 * @param PwUserBanSo $searchVo
	 * @param int $start ʼλ
	 * @param int $limit 
	 * @return array
	 */
	public function searchBanInfo(PwUserBanSo $searchVo, $limit = 10, $start = 0) {
		return $this->_getDao()->fetchBanInfoByCondition($searchVo->getData(), $limit, $start);
	}

	/** 
	 * ûֹDAO
	 *
	 * @return PwUserBanDao
	 */
	private function _getDao() {
		return Wekit::loadDao('user.dao.PwUserBanDao');
	}
}