<?php

/**
 * ûϢ
 *
 * @author xiaoxia.xu <xiaoxia.xuxx@aliyun-inc.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id: PwUserBelong.php 11842 2012-06-13 12:08:19Z jieyin $
 * @package src.service.user
 */
class PwUserBelong {
	
	/**
	 * ûIdøûӵеû
	 *
	 * @param int $uid
	 * @return array
	 */
	public function getUserBelongs($uid) {
		if (!$uid) return array();
		return $this->_getDao()->getByUid($uid);
	}

	public function getUserByGid($gid) {
		if (!$gid) return array();
		return $this->_getDao()->getByGid($gid);
	}
	
	/**
	 * ûIDбЩûӵ
	 *
	 * @param array $uids ûIDб
	 * @return array
	 */
	public function fetchUserByUid($uids) {
		if (!$uids) return array();
		return $this->_getDao()->fetchUserByUid($uids);
	}
	
	/**
	 * ûIDɾϢ
	 *
	 * @param int $uid
	 * @return boolean
	 */
	public function deleteByUid($uid) {
		if (!($uid = intval($uid))) return false;
		return $this->_getDao()->delete($uid);
	}
	
	/**
	 * ûIDбɾ¼Ϣ
	 *
	 * @param array $uids
	 * @return boolean
	 */
	public function batchDeleteByUids($uids) {
		if (!$uids) return false;
		return $this->_getDao()->batchDeleteByUids($uids);
	}
	
	/**
	 * ûIDûûϢ
	 *
	 * @param int $uid
	 * @param array $$belongs
	 * @return PwError|boolean
	 */
	public function update($uid, $belongs) {
		if (($uid = intval($uid)) < 1) return new PwError('USER:error.uid');
		if (!$belongs) return new PwError('USER:error.format');
		return $this->_getDao()->edit($uid, $belongs);
	}
		
	/**
	 * ûûDAo
	 *
	 * @return PwUserBelongDao
	 */
	private function _getDao() {
		return Wekit::loadDao('user.dao.PwUserBelongDao');
	}
}