<?php

/**
 * ûuser_data_ExpandDaoDs
 *
 * @author xiaoxia.xu <xiaoxia.xuxx@aliyun-inc.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id: PwUserDataExpand.php 24718 2013-02-17 06:42:06Z jieyin $
 * @package wind
 */
class PwUserDataExpand {
	
	/**
	 * ñṹ
	 * 
	 * @return array
	 */
	public function getCreditStruct() {
		$struct = $this->_getDao()->getStruct();
		$credit = array();
		foreach ($struct as $_key) {
			if (strpos($_key, 'credit') === 0) $credit[] = $_key;
		}
		return $credit;
	}

	/**
	 * ûdatacreditֶ
	 *
	 * @param int $num
	 * @return boolean
	 */
	public function alterAddCredit($num) {
		$num = intval($num);
		return $num < 9 ? false : $this->_getDao()->alterAddCredit($num);
	}
	
	/**
	 * ɾûֶΣ1-8ɾ
	 *
	 * @param int $num
	 * @return boolean
	 */
	public function alterDropCredit($num) {
		$num = intval($num);
		return $num < 9 ? false : $this->_getDao()->alterDropCredit($num);
	}
	
	/**
	 * ûֵĳһ
	 *
	 * @param int $num
	 * @return boolean
	 */
	public function clearCredit($num) {
		$num = intval($num);
		return ($num > 8 || $num < 1) ? false : $this->_getDao()->clearCredit($num);
	}
	
	/**
	 * ûdataExpandDao
	 *
	 * @return PwUserDataExpandDao
	 */
	private function _getDao() {
		return Wekit::loadDao('user.dao.PwUserDataExpandDao');
	}
	
	/**
	 * windidDS
	 *
	 * @return WindidUser
	 */
	protected function _getWindid() {
		return WindidApi::api('user');
	}
}