<?php

/**
 * ֻ֤
 *
 * @author jinlong.panjl <jinlong.panjl@aliyun-inc.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.phpwind.com
 * @version $Id$
 * @package wind
 */
class PwUserMobile {
	
	/**
	 * ȡһ
	 * 
	 * @param int $uid
	 * @return array
	 */
	public function getByUid($uid){
		$uid = intval($uid);
		if ($uid < 1) return array();
		return $this->_getUserVerify()->get($uid);
	}
	
	/**
	 * ȡ
	 * 
	 * @param array $uids
	 * @return array
	 */
	public function fetchByUid($uids){
		if (!is_array($uids) || !$uids) return array();
		return $this->_getUserVerify()->fetch($uids);
	}
	
	/**
	 * ֻȡһ
	 * 
	 * @param int $mobile
	 * @return array
	 */
	public function getByMobile($mobile){
		if ($mobile < 1) return array();
		return $this->_getUserVerify()->getByMobile($mobile);
	}
	
	/**
	 * ӵ
	 * 
	 * @param int $uid
	 * @param int $mobile
	 * @return array
	 */
	public function addMobile($uid, $mobile){
		$uid = intval($uid);
		$mobile = intval($mobile);
		if ($uid < 1 || $mobile < 1) return false;
		return $this->_getUserVerify()->add(array('uid' => $uid, 'mobile' => $mobile));
	}
	
	/**
	 * ӵ
	 * 
	 * @param int $uid
	 * @param int $mobile
	 * @return array
	 */
	public function replaceMobile($uid, $mobile){
		$uid = intval($uid);
		if ($uid < 1 || $mobile < 1) return false;
		return $this->_getUserVerify()->replace(array('uid' => $uid, 'mobile' => $mobile));
	}
	
	/**
	 * ɾ
	 * 
	 * @param int $uid
	 * @return bool 
	 */
	public function deleteByUid($uid) {
		$uid = intval($uid);
		if ($uid < 1) return false;
		return $this->_getUserVerify()->delete($uid);
	}
	
	/**
	 * ɾ
	 * 
	 * @param array $uids
	 * @return bool 
	 */
	public function batchDelete($uids) {
		if (!is_array($uids) || !$uids) return false;
		return $this->_getUserVerify()->batchDelete($uids);
	}
	
	/**
	 * ɾ
	 * 
	 * @param int $uid
	 * @param int $mobile
	 * @return bool 
	 */
	public function updateMobile($uid, $mobile) {
		$uid = intval($uid);
		if ($uid < 1 || $mobile < 1) return false;
		return $this->_getUserVerify()->update($uid, array('mobile' => intval($mobile)));
	}
	
	/**
	 * @return PwUserVerifyDao
	 */
	protected function _getUserVerify() {
		return Wekit::loadDao('user.dao.PwUserVerifyDao');
	}
}