<?php
/**
 * ûע/DS
 *
 * @author xiaoxia.xu <xiaoxia.xuxx@aliyun-inc.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id: PwUserRegisterCheck.php 7687 2012-04-10 11:17:58Z xiaoxia.xuxx $
 * @package src.service.user
 */
class PwUserRegisterCheck {

	/**
	 * ûIDû״̬
	 *
	 * @param int $uid
	 * @return array
	 */
	public function getInfo($uid) {
		if (empty($uid)) return array();
		return $this->_getDao()->getInfo($uid);
	}
	
	/**
	 * ûмû
	 * 
	 * @return array
	 */
	public function getUnCheckedList($limit, $start) {
		return $this->_getDao()->getInfoByIfchecked(0, $limit, $start);
	}
	
	/**
	 * ͳûмû
	 * 
	 * @return int
	 */
	public function countUnChecked() {
		return $this->_getDao()->countByIfchecked(0);
	}
	
	/**
	 * ûмûб
	 *
	 * @param int $limit
	 * @param int $start
	 * @return array
	 */
	public function getUnActivedList($limit, $start) {
		return $this->_getDao()->getInfoByIfactived(0, $limit, $start);
	}
	
	/**
	 * ͳûмû
	 *
	 * @return int
	 */
	public function countUnActived() {
		return $this->_getDao()->countByIfactived(0);
	}
	
	/** 
	 * û״̬
	 *
	 * @param int $uids ûID
	 * @param int $ifchecked ǷѾ
	 * @param int $ifactived ǷѾ 
	 * @return boolean|int
	 */
	public function addInfo($uid, $ifchecked = 1, $ifactived = 1) {
		if (empty($uid)) return false;
		return $this->_getDao()->addInfo($uid, $ifchecked, $ifactived);
	}
	
	/**
	 * ͨû
	 *
	 * @param int $uid
	 * @return boolean
	 */
	public function checkUser($uid) {
		if (empty($uid)) return false;
		return $this->_getDao()->updateInfo($uid, array('ifchecked' => 1));
	}
	
	/**
	 * û
	 *
	 * @param array $uids
	 * @return boolean
	 */
	public function batchCheckUser($uids) {
		if (empty($uids)) return false;
		return $this->_getDao()->batchUpdateInfo($uids, array('ifchecked' => 1));
	}
	
	/**
	 * û
	 *
	 * @param int $uid
	 * @return boolean
	 */
	public function activeUser($uid) {
		if (empty($uid)) return false;
		return $this->_getDao()->updateInfo($uid, array('ifactived' => 1));
	}
	
	/**
	 * û
	 *
	 * @param array $uids
	 * @return boolean
	 */
	public function batchActiveUser($uids) {
		if (empty($uids)) return false;
		return $this->_getDao()->batchUpdateInfo($uids, array('ifactived' => 1));
	}
	
	/**
	 * ûIDɾû״̬
	 *
	 * @param int $uid
	 * @return boolean
	 */
	public function deleteUser($uid) {
		if (empty($uid)) return false;
		return $this->_getDao()->deleteInfo($uid);
	}
	
	/**
	 * ûIDбɾɾ
	 *
	 * @param array $uids
	 * @return boolean
	 */
	public function batchDeleteUser($uids) {
		if (empty($uids)) return false;
		return $this->_getDao()->batchDeleteInfo($uids);
	}
	
	/**
	 * ûע/DAO
	 *
	 * @return PwUserRegisterCheckDao
	 */
	private function _getDao() {
		return Wekit::loadDao('user.dao.PwUserRegisterCheckDao');
	}
}