<?php
defined('WEKIT_VERSION') || exit('Forbidden');

/**
 * ûҵ
 *
 * @author Jianmin Chen <sky_hold@163.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.phpwind.com
 * @version $Id: PwUserBo.php 24736 2013-02-19 09:24:40Z jieyin $
 * @package src.service.user.bo
 */
class PwUserBo {
	
	public $uid;
	public $username;
	public $gid;
	public $groups = array();
	public $ip;
	public $info = array();

	private $_groupInfo = array();
	private $_permission = array();

	private static $_userBo = array();

	/** 
	 * 캯Ϣ
	 *
	 * @param int $uid ûID
	 */
	public function __construct($uid, $fetchAll = false) {
		$this->info = $uid ? $this->_getUserDs()->getUserByUid($uid, $fetchAll ? PwUser::FETCH_ALL : (PwUser::FETCH_MAIN | PwUser::FETCH_DATA)) : array();
		if ($this->info) {
			$this->uid = $uid;
			$this->username = $this->info['username'];
			$this->gid = ($this->info['groupid'] == 0) ? $this->info['memberid'] : $this->info['groupid'];
			$this->ip = $this->info['lastloginip'];
			if ($this->info['groups']) $this->groups = explode(',', $this->info['groups']);
			$this->groups[] = $this->gid;
		} else {
			$this->reset();
		}
	}
	
	/**
	 * ȡһ PwUserBo ʵ
	 *
	 * @param int $uid
	 * @return object
	 */
	public static function getInstance($uid) {
		if (!isset(self::$_userBo[$uid])) self::$_userBo[$uid] = new self($uid);
		return self::$_userBo[$uid];
	}

	public static function pushUser(PwUserBo $bo) {
		self::$_userBo[$bo->uid] = $bo;
	}

	/** 
	 * жǷûϢ
	 *
	 * @return boolean
	 */
	public function isExists() {
		return !empty($this->uid);
	}
	
	/**
	 * жûûǷָ
	 *
	 * @param array $groups
	 * @return bool
	 */
	public function inGroup($groups) {
		if (!$groups || !is_array($groups)) return false;
		if (in_array($this->gid, $groups)) return true;
		if ($this->groups) return !!array_intersect($this->groups, $groups);
		return false;
	}

	/**
	 * ȡûĳȨ޵Ȩֵ
	 * 
	 * @param string $key Ȩ޼ֵ<ֶ֧༶ã:a.b.c $a['b']['c']>
	 * @param bool $isBM Ƿǰ<ָȨǰ޶ȨʱҪָǰǷǰ>
	 * @param mixed $defaultValue
	 * @return mixed
	 */
	public function getPermission($key, $isBM = false, $defaultValue = '') {
		$this->_initGroup();
		$keys = explode('.', $key);
		$key = array_shift($keys);
		if (!isset($this->_permission[$key]) || $this->_permission[$key]['type'] == 'systemforum' && $this->gid == 5 && !$isBM) {
			return $defaultValue;
		}
		$result = $this->_permission[$key]['value'];
		if ($keys) {
			foreach ($keys as $_key) {
				if (!is_array($result) || !isset($result[$_key])) return $defaultValue;
				$result = $result[$_key];
			}
		}
		return $result === '' ? $defaultValue : $result;
	}
	
	/**
	 * ָûȽȨ޵ȼ
	 *
	 * @param array $uids ûid
	 * @return bool
	 */
	public function comparePermission($uids) {
		is_array($uids) || $uids = array($uids);
		$level = $this->getPermission('manage_level');
		$users = $this->_getUserDs()->fetchUserByUid($uids);
		if ($gids = array_diff(Pw::collectByKey($users, 'groupid'), array('0'))) {
			$array = $this->_getPermissionDs()->getPermissionByRkeyAndGids('manage_level', $gids);
			foreach ($array as $key => $value) {
				if ($value['rvalue'] && $level < $value['rvalue']) return false;
			}
		}
		return true;
	}

	/**
	 * ûĳһ͵Ļ
	 *
	 * @param int $creditType
	 * @return int
	 */
	public function getCredit($creditType) {
		return $this->info['credit' . $creditType];
	}
	
	/**
	 * ȡûϢ
	 * 
	 * @return array
	 */
	public function getGroupInfo($key = null) {
		$this->_initGroup();
		return $key ? $this->_groupInfo[$key] : $this->_groupInfo;
	}

	/** 
	 * ûʱ (λ)
	 *
	 * @return int
	 */
	public function getOnline() {
		$online = $this->info['online'];
		return $online + (time() - $this->info['lastvisit']);
	}

	/**
	 * չʾûĻֱ
	 * 
	 * @return array
	 */
	public function showCreditNotice() {
		return empty($this->info['last_credit_affect_log']) ? false : true;
	}
	
	/** 
	 * ûò
	 * 
	 * @return boolean
	 */
	public function reset() {
		$this->uid = 0;
		$this->gid = 2;
		$this->username = 'ο';
		$this->info = array(
			'lastpost' => Pw::getCookie('guest_lastpost')
		);
	}
	
	/**
	 * ûϢȨ
	 *
	 * @param int $gid ûid
	 */
	public function resetGid($gid) {
		$this->gid = $gid;
		$this->_groupInfo = array();
		$this->_initGroup();
	}

	/**
	 * ʼǰûϢȨ
	 */
	private function _initGroup() {
		if ($this->_groupInfo) return;
		if (($group = Wekit::cache()->get('group', $this->gid)) === false) {
			$group = Wekit::cache()->get('group', 1);
		}
		$this->_groupInfo = array('name' => $group['name'], 'type' => $group['type'], 'image' => $group['image'], 'points' => $group['points']);
		$this->_permission = $group['permission'];
	}

	/** 
	 * ȡû
	 *
	 * @return PwUser
	 */
	private function _getUserDs() {
		return Wekit::load('user.PwUser');
	}

	private function _getPermissionDs() {
		return Wekit::load('usergroup.PwUserPermission');
	}
}