<?php
/**
 * ûֹϢ
 * ûΪֹ
 *    1: ֹû
 *    2: ֹûʹͷ
 *    4: ֹûʹǩ
 *
 * @author xiaoxia.xu <xiaoxia.xuxx@aliyun-inc.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.phpwind.com
 * @version $Id: PwUserBanDao.php 16415 2012-08-23 07:53:40Z xiaoxia.xuxx $
 * @package src.service.user.dao
 */
class PwUserBanDao extends PwBaseDao {
	protected $_table = 'user_ban';
	protected $_pk = 'id';
	protected $_dataStruct = array('id', 'uid', 'typeid', 'fid', 'end_time', 'created_time', 'created_userid', 'reason');

	/**
	 * ȡûIDֹϢ
	 *
	 * @param int $uid
	 * @return array
	 */
	public function getBanInfo($uid) {
		$sql = $this->_bindTable('SELECT * FROM %s WHERE uid = ?');
		$smt = $this->getConnection()->createStatement($sql);
		return $smt->queryAll(array($uid), 'typeid');
	}
	
	/**
	 * ûĽֹͻȡûiDֹϢ
	 *
	 * @param int $uid ûID
	 * @param int $typeid ֹ
	 * @return array
	 */
	public function getBanInfoByTypeid($uid, $typeid) {
		$sql = $this->_bindTable('SELECT * FROM %s WHERE uid=? AND `typeid` & ?');
		$smt = $this->getConnection()->createStatement($sql);
		return $smt->queryAll(array($uid, $typeid), 'typeid');
	}
	
	/**
	 * ݽֹͼֹеľIDûuidĽֹϢ
	 *
	 * @param int $uid
	 * @param int $typeid
	 * @param int $fid
	 * @return array
	 */
	public function getBanInfoByTypeidAndFid($uid, $typeid, $fid) {
		$sql = $this->_bindTable('SELECT * FROM %s WHERE uid=? AND `typeid` & ? AND `fid` IN (0, ?)');
		$smt = $this->getConnection()->createStatement($sql);
		return $smt->queryAll(array($uid, $typeid, $fid), 'typeid');
	}
	
	/**
	 * ûIDбIDûֹϢ
	 *
	 * @param array $uids
	 * @param int $typeid ûֹ
	 * @return array
	 */
	public function fetchBanInfoByUid($uids, $typeid) {
		$sql = $this->_bindSql('SELECT * FROM %s WHERE uid IN %s AND `typeid` & ?', $this->getTable(), $this->sqlImplode($uids));
		$smt = $this->getConnection()->createStatement($sql);
		return $smt->queryAll(array($typeid), 'id');
	}
	
	/**
	 * ݽֹIDбȡֹ
	 *
	 * @param array $ids
	 * @return array
	 */
	public function fetchBanInfo($ids) {
		return $this->_fetch($ids, $this->_pk);
	}
	
	/** 
	 * ûֹ¼
	 *
	 * @param array $data Ϣ
	 * @return int
	 */
	public function addBanInfo($data) {
		if (!($data = $this->_filterStruct($data))) return false;
		$sql = $this->_bindSql('REPLACE INTO %s SET %s', $this->getTable(), $this->sqlSingle($data));
		return $this->getConnection()->execute($sql);
	}
	
	/**
	 * ֹû
	 *
	 * @param array $data
	 * @return array
	 */
	public function batchAddBanInfo($data) {
		$clear = array();
		foreach ($data as $key => $_item) {
			if (!($_item = $this->_filterStruct($_item))) continue;
			$_temp = array();
			$_temp['uid'] = $_item['uid'];
			$_temp['typeid'] = $_item['typeid'];
			$_temp['fid'] = $_item['fid'];
			$_temp['end_time'] = $_item['end_time'];
			$_temp['created_time'] = $_item['created_time'];
			$_temp['created_userid'] = $_item['created_userid'];
			$_temp['reason'] = $_item['reason'];
			$clear[] = $_temp;
		}
		if (!$clear) return false;
		$sql = $this->_bindSql('REPLACE INTO %s (`uid`, `typeid`, `fid`, `end_time`, `created_time`, `created_userid`, `reason`) VALUES %s', $this->getTable(), $this->sqlMulti($clear));
		return $this->getConnection()->execute($sql);
	}
	
	/**
	 * ݽֹIDбɾֹ¼
	 *
	 * @param array $ids 
	 * @return boolean
	 */
	public function batchDelete($ids) {
		return $this->_batchDelete($ids);
	}

	/**
	 * ûIDɾûϢ
	 *
	 * @param int $uid
	 * @return int
	 */
	public function deleteByUid($uid) {
		$sql = $this->_bindTable('DELETE FROM %s WHERE `uid` = ?');
		$smt = $this->getConnection()->createStatement($sql);
		return $smt->execute(array($uid));
	}
	
	/** 
	 * ûIDɾûϢ
	 *
	 * @param array $uids ûIDб
	 * @return int
	 */
	public function batchDeleteByUids($uids) {
		$sql = $this->_bindSql('DELETE FROM %s WHERE `uid` IN %s', $this->getTable(), $this->sqlImplode($uids));
		return $this->getConnection()->execute($sql);
	}
	
	/**
	 * ͳ
	 *
	 * @param array $condition
	 * @return int
	 */
	public function countByCondition($condition) {
		list($where, $params) = $this->_buildCondition($condition);
		$sql = $this->_bindSql('SELECT COUNT(*) FROM %s %s', $this->getTable(), $where);
		$smt = $this->getConnection()->createStatement($sql);
		return $smt->getValue($params);
	}
	
	/**
	 * 
	 *
	 * @param array $condition ѯ
	 * @param int $limit 
	 * @param int $start ¼ѯʼ
	 * @return array
	 */
	public function fetchBanInfoByCondition($condition, $limit = 10, $start = 0) {
		list($where, $params) = $this->_buildCondition($condition);
		$sql = $this->_bindSql('SELECT * FROM %s %s %s', $this->getTable(), $where, $this->sqlLimit($limit, $start));
		$smt = $this->getConnection()->createStatement($sql);
		return $smt->queryAll($params, 'id');
	}
	
	/**
	 * 
	 * ֧֣
	 * <pre>
	 *   array('username/uid' => '', 'created_userid' => '', 'start_time' => 'ʱ', 'end_time' => 'ʱ');
	 * </pre>
	 *
	 * @param array $condition
	 * @return string
	 */
	private function _buildCondition($condition) {
		if (!$condition) return array('', array());
		$where = $params = array();
		foreach ($condition as $key => $value) {
			if (!$value && $value !== 0) continue;
			switch ($key) {
				case 'uid':
					$where[] = '`uid`=?';
					$params[] = $value;
					break;
				case 'created_userid':
					$where[] = '`created_userid` = ?';
					$params[] = $value;
					break;
				case 'start_time':
					$where[] = '`created_time` >= ?';
					$params[] = $value;
					break;
				case 'end_time':
					$where[] = '`created_time` <= ?';
					$params[] = $value;
					break;
			}
		}
		return $where ?  array(' WHERE ' . implode(' AND ', $where), $params) : array('', array());
	}
}