<?php
/**
 * ûչ
 *
 * @author Shi Long <long.shi@alibaba-inc.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.phpwind.com
 * @version $Id: PwUserDao.php 21135 2012-11-29 02:10:03Z jieyin $
 * @package src.service.user.dao
 */
class PwUserDao extends PwBaseDao {

	protected $_table = 'user';
	protected $_pk = 'uid';
	protected $_dataStruct = array('uid', 'username', 'email', 'password', 'regdate', 'realname', 'status', 'groupid', 'memberid', 'groups');

	/**
	 * ûIDûչ
	 *
	 * @param int $uid ûID
	 * @return array
	 */
	public function getUserByUid($uid) {
		return $this->_get($uid);
	}
	
	/**
	 * ûûϢ
	 *
	 * @param string $username
	 * @return array
	 */
	public function getUserByName($username) {
		$sql = $this->_bindTable('SELECT * FROM %s WHERE username=?');
		$smt = $this->getConnection()->createStatement($sql);
		return $smt->getOne(array($username));
	}

	/**
	 * ûemailûϢ
	 *
	 * @param string $email
	 * @return array
	 */
	public function getUserByEmail($email) {
		$sql = $this->_bindTable('SELECT * FROM %s WHERE email=?');
		$smt = $this->getConnection()->createStatement($sql);
		return $smt->getOne(array($email));
	}

	/** 
	 * ûIDбȡID
	 *
	 * @param array $uids
	 * @return array
	 */
	public function fetchUserByUid($uids) {
		return $this->_fetch($uids, 'uid');
	}

	/**
	 * ûбûϢ
	 *
	 * @param array $usernames
	 * @return array
	 */
	public function fetchUserByName($usernames) {
		$sql = $this->_bindSql('SELECT * FROM %s WHERE username IN %s', $this->getTable(), $this->sqlImplode($usernames));
		$rst = $this->getConnection()->query($sql);
		return $rst->fetchAll('uid');
	}

	/** 
	 * ûչ
	 *
	 * @param array $fields û
	 * @return boolean|Ambigous <number, boolean, rowCount>
	 */
	public function addUser($fields) {
		$this->_add($fields, false);
		return true;
	}

	/** 
	 * ûIDûչ
	 *
	 * @param int $uid    ûID
	 * @param array $fields  ûչ
	 * @return boolean|int
	 */
	public function editUser($uid, $fields, $increaseFields = array(), $bitFields = array()) {
		return $this->_update($uid, $fields, $increaseFields, $bitFields);
	}

	/** 
	 * ɾû
	 *
	 * @param int $uid  ûID
	 * @return int
	 */
	public function deleteUser($uid) {
		return $this->_delete($uid);
	}

	/** 
	 * ɾûϢ
	 *
	 * @param array $uids ûID
	 * @return int
	 */
	public function batchDeleteUser($uids) {
		return $this->_batchDelete($uids);
	}
}
?>