<?php

/**
 * UserDaoװ ȱʡװ
 *
 * @author xiaoxia.xu <xiaoxia.xuxx@aliyun-inc.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.phpwind.com
 * @version $Id: PwUserDefaultDao.php 21135 2012-11-29 02:10:03Z jieyin $
 * @package src.service.user.dao
 */
class PwUserDefaultDao extends PwBaseDao {

	/**
	 * ûIDûʱ
	 *
	 * @param int $uid ûID
	 * @return array
	 */
	public function getUserByUid($uid) {
		return array('uid' => $uid);
	}

	/**
	 * ûȡûϢ
	 *
	 * @param string $username
	 * @return array
	 */
	public function getUserByName($username) {
		$result = $this->_getDao()->getUserByName($username);
		return $result ? array('uid' => $result['uid']) : array();
	}

	/**
	 * ûemailȡûϢ
	 *
	 * @param string $email
	 * @return array
	 */
	public function getUserByEmail($email) {
		$result = $this->_getDao()->getUserByEmail($email);
		return $result ? array('uid' => $result['uid']) : array();
	}

	/**
	 * ûIDбȡûϢ
	 *
	 * @param unknown_type $uids
	 * @return multitype:multitype: 
	 */
	public function fetchUserByUid($uids) {
		$info = array();
		foreach ($uids as $value) {
			$info[$value] = array();
		}
		return $info;
	}

	/**
	 * ûбȡûϢ
	 *
	 * @param array $usernames
	 * @return array  
	 */
	public function fetchUserByName($usernames) {
		$data = $this->_getDao()->fetchUserByName($usernames);
		$result = array();
		foreach ($data as $key => $value) {
			$result[$key] = array('uid' => $key);
		}
		return $result;
	}

	/**
	 * û
	 *
	 * @param array $fields ӵûϢ
	 * @return boolean
	 */
	public function addUser($fields) {
		return false;
	}

	/**
	 * ûϢ
	 *
	 * @param int $uid ûID
	 * @param array $fields ûϢ
	 * @return boolean
	 */
	public function editUser($uid, $fields, $increaseFields = array(), $bitFields = array()) {
		return false;
	}

	/**
	 * ɾûϢ
	 *
	 * @param int $uids
	 * @return boolean
	 */
	public function deleteUser($uids) {
		return false;
	}

	/** 
	 * ɾûϢ
	 *
	 * @param array $uids ûID
	 * @return boolean
	 */
	public function batchDeleteUser($uids) {
		return false;
	}

	/**
	 * ȡûϢdao
	 * 
	 * @return PwUserDao
	 */
	protected function _getDao() {
		return Wekit::loadDao('user.dao.PwUserDao');
	}
}