<?php

/**
 * ֻ֤
 *
 * @author jinlong.panjl <jinlong.panjl@aliyun-inc.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.phpwind.com
 * @version $Id$
 * @package wind
 */
class PwUserMobileVerifyDao extends PwBaseDao {
	protected $_table = 'user_mobile_verify';
	protected $_pk = 'mobile';
	protected $_dataStruct = array('mobile', 'code', 'expired_time', 'number', 'create_time');

	/**
	 * ȡһ
	 *
	 * @param int $id
	 * @return array
	 */
	public function get($id) {
		return $this->_get($id);
	}
	
	/**
	 * ȡ
	 *
	 * @param array $ids
	 * @return array
	 */
	public function fetch($ids) {
		return $this->_fetch($ids);
	}
	
	/**
	 * ӵ
	 * 
	 * @param array $fields
	 * @return bool 
	 */
	public function add($fields) {
		return $this->_add($fields);
	}
	
	/**
	 * ӵ
	 * 
	 * @param array $fields
	 * @return bool 
	 */
	public function replace($fields) {
		$sql = $this->_bindSql('REPLACE INTO %s SET %s', $this->getTable(), $this->sqlSingle($fields));
		return $this->getConnection()->execute($sql);
	}
	
	/**
	 * ɾ
	 * 
	 * @param int $id
	 * @return bool 
	 */
	public function delete($id) {
		return $this->_delete($id);
	}
	
	/**
	 * ɾ
	 * 
	 * @param int $id
	 * @return bool 
	 */
	public function deleteByExpiredTime($expired_time) {
		$sql = $this->_bindTable('DELETE FROM %s WHERE `expired_time`<?');
		$smt = $this->getConnection()->createStatement($sql);
		return $smt->update(array($expired_time));
	}
	
	/**
	 * ɾ
	 * 
	 * @param array $ids
	 * @return bool 
	 */
	public function batchDelete($ids) {
		return $this->_batchDelete($ids);
	}
	
	/**
	 * µ
	 * 
	 * @param int $id
	 * @param array $fields
	 * @return bool 
	 */
	public function update($id,$fields) {
		return $this->_update($id, $fields);
	}
	
	/**
	 * µ
	 * 
	 * @param int $expiredTime
	 * @param array $fields
	 * @return bool 
	 */
	public function updateByExpiredTime($expiredTime, $fields) {
		$sql = $this->_bindSql('UPDATE %s SET %s WHERE `expired_time`<?', $this->getTable(), $this->sqlSingle($fields));
		$smt = $this->getConnection()->createStatement($sql);
		return $smt->update(array($expiredTime));
	}
	
	/**
	 * 
	 * 
	 * @param array $ids
	 * @param array $fields
	 * @return bool 
	 */
	public function batchUpdate($ids,$fields) {
		return $this->_batchUpdate($ids, $fields);
	}
}