<?php

/**
 * ûע/DS
 *
 * @author xiaoxia.xu <xiaoxia.xuxx@aliyun-inc.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id: PwUserRegisterCheckDao.php 7687 2012-04-10 11:17:58Z xiaoxia.xuxx $
 * @package src.service.user.dao
 */
class PwUserRegisterCheckDao extends PwBaseDao {
	protected $_table = 'user_register_check';
	protected $_pk = 'uid';
	protected $_dataStruct = array('uid', 'ifchecked', 'ifactived');

	/**
	 * ûIDû״̬Ϣ
	 *
	 * @param int $uid
	 * @return array
	 */
	public function getInfo($uid) {
		$sql = $this->_bindTable('SELECT * FROM %s WHERE `uid` = ?');
		$smt = $this->getConnection()->createStatement($sql);
		return $smt->getOne(array($uid));
	}
	
	/**
	 * û״̬ûļ¼
	 *
	 * @param int $ifchecked
	 * @param int $limit
	 * @param int $start
	 * @return array
	 */
	public function getInfoByIfchecked($ifchecked, $limit, $start) {
		$sql = $this->_bindSql("SELECT * FROM %s WHERE `ifchecked` =? %s", $this->getTable(), $this->sqlLimit($limit, $start));
		$result = $this->getConnection()->createStatement($sql);
		return $result->queryAll(array($ifchecked), 'uid');
	}
	
	/** 
	 * ûмûͳ
	 *
	 * @param int $ifchecked
	 * @return int
	 */
	public function countByIfchecked($ifchecked) {
		$sql = $this->_bindTable('SELECT COUNT(*) FROM %s WHERE `ifchecked` = ?');
		$result = $this->getConnection()->createStatement($sql);
		return $result->getValue(array($ifchecked));
	}
	
	/**
	 * ûֶλûļ¼
	 *
	 * @param int $ifactived
	 * @param int $limit
	 * @param int $start
	 * @return array
	 */
	public function getInfoByIfactived($ifactived, $limit, $start) {
		$sql = $this->_bindSql("SELECT * FROM %s WHERE `ifactived` = ? %s", $this->getTable(), $this->sqlLimit($limit, $start));
		$result = $this->getConnection()->createStatement($sql);
		return $result->queryAll(array($ifactived), 'uid');
	}
	
	/** 
	 * ûмûͳ
	 *
	 * @param int $ifactived
	 * @return int
	 */
	public function countByIfactived($ifactived) {
		$sql = $this->_bindTable('SELECT COUNT(*) FROM %s WHERE `ifactived` = ?');
		$result = $this->getConnection()->createStatement($sql);
		return $result->getValue(array($ifactived));
	}
	
	/**
	 * û״̬
	 *
	 * @param int $uid ûID
	 * @param int $ifchecked ûǷ
	 * @param int $ifactived ûǷѾ
	 * @return boolean
	 */
	public function addInfo($uid, $ifchecked, $ifactived) {
		$sql = $this->_bindTable('REPLACE INTO %s SET `ifchecked` = ?, `ifactived` = ?, `uid` = ?');
		$smt = $this->getConnection()->createStatement($sql);
		return $smt->update(array($ifchecked, $ifactived, $uid));
	}
	
	/**
	 * û״̬
	 *
	 * @param int $uid ûID
	 * @param array $data ûϢ
	 * @return boolean
	 */
	public function updateInfo($uid, $data) {
		if (!($clear = $this->_filterStruct($data))) return false;
		$sql = $this->_bindSql('UPDATE %s SET %s WHERE `uid` = ?', $this->getTable(), $this->sqlSingle($clear));
		$smt = $this->getConnection()->createStatement($sql);
		return $smt->update(array($uid));
	}
	
	/**
	 * ޸û
	 *
	 * @param array $uids
	 * @param array $data
	 * @return boolean
	 */
	public function batchUpdateInfo($uids, $data) {
		if (!($clear = $this->_filterStruct($data))) return false;
		$sql = $this->_bindSql('UPDATE %s SET %s WHERE `uid` IN %s', $this->getTable(), $this->sqlSingle($clear), $this->sqlImplode($uids));
		return $this->getConnection()->execute($sql);
	}
	
	/**
	 * ûIDɾû״̬Ϣ
	 *
	 * @param int $uid
	 * @return boolean
	 */
	public function deleteInfo($uid) {
		$sql = $this->_bindTable('DELETE FROM %s WHERE `uid` = ?');
		$smt = $this->getConnection()->createStatement($sql);
		return $smt->update(array($uid));
	}
	
	/**
	 * ûIDɾû״̬¼Ϣ
	 *
	 * @param array $uids
	 * @return boolean
	 */
	public function batchDeleteInfo($uids) {
		$sql = $this->_bindSql('DELETE FROM %s WHERE `uid` IN %s', $this->getTable(), $this->sqlImplode($uids));
		return $this->getConnection()->execute($sql);
	}
}