<?php
defined('WEKIT_VERSION') || exit('Forbidden');

Wind::import('SRV:user.validator.PwUserValidator');
Wind::import('SRV:user.PwUser');

/**
 * ûdm
 *
 * @author xiaoxia.xu <xiaoxia.xuxx@aliyun-inc.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.phpwind.com
 * @version $Id: PwUserInfoDm.php 24943 2013-02-27 03:52:21Z jieyin $
 * @package src.service.user.dm
 */
class PwUserInfoDm extends PwBaseDm {

	public $uid;
	/*@var $dm WindidUserDm */
	public $dm = null;
	protected $_belong = null;
	protected $_password;

	/** 
	 * 캯
	 *
	 * @param int $uid
	 */
	public function __construct($uid = 0) {
		$this->uid = $uid;
	}
	
	/**
	 * ûID
	 *
	 * @param int $uid
	 * @return PwUserInfoDm
	 */
	public function setUid($uid) {
		$this->uid = $uid;
		$this->_data['uid'] = $uid;
		return $this;
	}
	
	/** 
	 * ȡûWindidDm
	 *
	 * @return WindidUserDm
	 */
	public function getDm() {
		if (!is_object($this->dm)) {
			$dm = WindidApi::getDm('user');
			$this->dm = new $dm($this->uid);
		}
		return $this->dm;
	}

	/**
	 * û
	 * 
	 * @param string $username
	 */
	public function setUsername($username) {
		$this->getDm()->setUsername($username);
		$this->_data['username'] = $username;
		return $this;
	}
	
	/**
	 * ϵ룬֤
	 *
	 * @param string $oldPwd
	 * @return PwUserInfoDm
	 */
	public function setOldPwd($oldPwd) {
		$this->getDm()->setOldpwd($oldPwd);
		return $this;
	}

	/**
	 * û
	 * 
	 * @param string $password 
	 * @return PwUserInfoDm
	 */
	public function setPassword($password) {
		$this->getDm()->setPassword($password);
		$this->_password = $password;
		$this->_data['password'] = md5(WindUtility::generateRandStr(16));
		return $this;
	}

	/**
	 * ûemail
	 * 
	 * @param string $email
	 */
	public function setEmail($email) {
		$this->getDm()->setEmail($email);
		$this->_data['email'] = $email;
		return $this;
	}

	/**
	 * ðȫ
	 * 
	 * @param string $question
	 * @param string $answer
	 * @return PwUserInfo
	 */
	public function setQuestion($question, $answer) {
		$this->getDm()->setQuestion($question);
		$this->getDm()->setAnswer($answer);
		return $this;
	}

	/**
	 * ״̬
	 *
	 * @param int $status
	 * @return PwUserInfoDm
	 */
	public function updateStatus($status) {
		$this->_increaseData['status'] = intval($status);
		return $this;
	}
	
	/**
	 * ûǰû
	 *
	 * @param int $gid
	 * @return PwUserInfoDm
	 */
	public function setGroupid($gid) {
		$this->_data['groupid'] = $gid;
		$this->_belong = array();
		$gid > 0 && $this->_belong[$gid] = 0;
		return $this;
	}
	
	/** 
	 * ûӵе
	 * ע:ʹø÷֮ǰһҪʹ setGroupid()
	 *
	 * @param array $groups ӵе
	 * @example:
	 * @$groups = array(
	 *		'3' => 0,
	 *		'4' => 1234567890,
	 *		...
	 *	)
	 *  ע:key=ûid  value=ʱ
	 */
	public function setGroups($groups) {
		if (!isset($this->_data['groupid'])) return $this;
		$time = Pw::getTime();
		foreach ($groups as $gid => $endtime) {
			if ($gid && ($endtime == 0 || $endtime > $time)) {
				$this->_belong[$gid] = $endtime;
			}
		}
		if (!$this->_data['groupid'] && $this->_belong) {
			$this->_data['groupid'] = key($this->_belong);
		}
		$this->_data['groups'] = array_diff(array_keys($this->_belong), array($this->_data['groupid']));
		return $this;
	}

	/**
	 * עIP
	 * 
	 * @param string $regip
	 */
	public function setRegip($regip) {
		$this->getDm()->setRegip($regip);
		return $this;
	}
	
	/**
	 * עʱ
	 * 
	 * @param string $regdate
	 */
	public function setRegdate($regdate) {
		$this->getDm()->setRegdate($regdate);
		$this->_data['regdate'] = max(0, intval($regdate));
		return $this;
	}

	/**
	 * Ա
	 * 
	 * @param int $gender
	 */
	public function setGender($gender) {
		$this->getDm()->setGender($gender);
		$this->_data['gender'] = intval($gender);
		return $this;
	}

	/**
	 * -
	 * 
	 * @param int $year
	 */
	public function setByear($year) {
		$this->getDm()->setByear($year);
		$this->_data['byear'] = intval($year);
		return $this;
	}
	
	/**
	 * -
	 * 
	 * @param string $month
	 */
	public function setBmonth($month) {
		$this->getDm()->setBmonth($month);
		$this->_data['bmonth'] = $month;
		return $this;
	}
	
	/**
	 * -
	 * 
	 * @param string $bday
	 */
	public function setBday($bday) {
		$this->getDm()->setBday($bday);
		$this->_data['bday'] = $bday;
		return $this;
	}

	/**
	 * üַͥ
	 * 
	 * @param int $hometown
	 * @param string $hometown_text ַͥıϢ
	 */
	public function setHometown($hometown, $hometown_text) {
		$this->getDm()->setHometown($hometown);
		$this->_data['hometown'] = intval($hometown);
		$this->_data['hometown_text'] = $hometown_text;
		return $this;
	}

	/**
	 * þסش
	 * 
	 * @param int $location
	 * @param string $location_text
	 */
	public function setLocation($location, $location_text) {
		$this->getDm()->setLocation($location);
		$this->_data['location'] = intval($location);
		$this->_data['location_text'] = $location_text;
		return $this;
	}

	/**
	 * ҳ
	 * 
	 * @param string $homepage
	 */
	public function setHomepage($homepage) {
		$this->getDm()->setHomepage($homepage);
		$this->_data['homepage'] = $homepage;
		return $this;
	}

	/**
	 * QQ
	 * 
	 * @param stirng $qq
	 */
	public function setQq($qq) {
		$this->getDm()->setQq($qq);
		$this->_data['qq'] = $qq;
		return $this;
	}

	/**
	 * msn
	 * 
	 * @param stirng $msn
	 */
	public function setMsn($msn) {
		$this->getDm()->setMsn($msn);
		$this->_data['msn'] = $msn;
		return $this;
	}

	/**
	 * ð
	 * 
	 * @param string $aliww
	 */
	public function setAliww($aliww) {
		$this->getDm()->setAliww($aliww);
		$this->_data['aliww'] = $aliww;
		return $this;
	}

	/**
	 * ֻ
	 * 
	 * @param string $mobile
	 */
	public function setMobile($mobile) {
		$this->getDm()->setMobile($mobile);
		$this->_data['mobile'] = $mobile;
		return $this;
	}

	/**
	 * ֻ֤
	 * 
	 * @param string $mobileCode
	 */
	public function setMobileCode($mobileCode) {
		$this->_data['mobileCode'] = $mobileCode;
		return $this;
	}
	
	/**
	 * ֧ʺ
	 * 
	 * @param string $alipay
	 */
	public function setAlipay($alipay) {
		$this->getDm()->setAlipay($alipay);
		$this->_data['alipay'] = $alipay;
		return $this;
	}
	
	/**** windid end ***/

	/** 
	 * ʺ״̬
	 *
	 * @param int $status
	 * @return PwUserInfoDm
	 */
	public function setStatus($status) {
		$this->_data['status'] = $status;
		return $this;
	}
	
	/**
	 * ǷΪ֤û
	 *
	 * @param boolean $bool
	 * @return PwUserInfoDm
	 */
	public function setUncheck($bool) {
		$this->_bitData['status'][PwUser::STATUS_UNCHECK] = (bool)$bool;
		return $this;
	}

	/**
	 * Ƿδû
	 *
	 * @param boolean $bool
	 * @return PwUserInfoDm
	 */
	public function setUnactive($bool) {
		$this->_bitData['status'][PwUser::STATUS_UNACTIVE] = (bool)$bool;
		return $this;
	}

	/**
	 * ûֹͷ
	 *
	 * @param boolean $bool
	 * @return PwUserInfoDm
	 */
	public function setBanAvatar($bool) {
		$this->_bitData['status'][PwUser::STATUS_BAN_AVATAR] = (bool)$bool;
		return $this;
	}

	/**
	 * ûֹǩ
	 *
	 * @param boolean $bool
	 * @return PwUserInfoDm
	 */
	public function setBanSign($bool) {
		$this->_bitData['status'][PwUser::STATUS_BAN_SIGN] = (bool)$bool;
		return $this;
	}

	/**
	 * øûǷʹUBB
	 *
	 * @param boolean $bool
	 * @return PwUserInfoDm
	 */
	public function setSignUseubb($bool) {
		$this->_bitData['status'][PwUser::STATUS_SIGN_USEUBB] = (bool)$bool;
		return $this;
	}
	
	/**
	 * øûǷ̨Ȩ
	 *
	 * @param boolean $bool
	 * @return PwUserInfoDm
	 */
	public function setAllowLoginAdmin($bool) {
		$this->_bitData['status'][PwUser::STATUS_ALLOW_LOGIN_ADMIN] = (bool)$bool;
		return $this;
	}
	
	/** 
	 * 
	 *
	 * @param string $realname
	 * @return PwUserInfoDm
	 */
	public function setRealname($realname) {
		$this->getDm()->setRealname($realname);
		$this->_data['realname'] = $realname;
		return $this;
	}
	
	/**
	 * ø˼
	 *
	 * @param string $profile
	 */
	public function setProfile($profile) {
		$this->getDm()->setProfile($profile);
		$this->_data['profile'] = $profile;
		return $this;
	}
	
	/** 
	 * ǩ
	 *
	 * @param string $bbs_sign
	 * @return PwUserInfoDm
	 */
	public function setBbsSign($bbs_sign) {
		$this->_data['bbs_sign'] = $bbs_sign;
		return $this;	
	}
	
	/** 
	 * ¼ʱ
	 *
	 * @param int $lastvisit
	 */
	public function setLastvisit($lastvisit) {
		$this->_data['lastvisit'] = $lastvisit;
		return $this;
	}
	
	/** 
	 * ¼IP
	 *
	 * @param string $lastloginip
	 */
	public function setLastloginip($lastloginip) {
		$this->_data['lastloginip'] = $lastloginip;
		return $this;
	}

	public function setLastActiveTime($time) {
		$this->_data['lastactivetime'] = $time;
		return $this;
	}

	public function setLastpost($lastpost) {
		$this->_data['lastpost'] = $lastpost;
		return $this;
	}
	
	/**
	 * û
	 *
	 * @param int $num
	 * @return PwUserInfoDm
	 */
	public function addPostnum($num) {
		$this->_increaseData['postnum'] = intval($num);
		return $this;
	}

	/**
	 * û
	 *
	 * @param int $num
	 * @return PwUserInfoDm
	 */
	public function setPostnum($num) {
		$this->_data['postnum'] = intval($num);
		return $this;
	}
	
	/**
	 * ûľ
	 *
	 * @param int $num
	 * @return PwUserInfoDm
	 */
	public function addDigest($num) {
		$this->_increaseData['digest'] = intval($num);
		return $this;
	}
	
	/**
	 * ûľ
	 *
	 * @param int $num
	 * @return PwUserInfoDm
	 */
	public function setDigest($num) {
		$this->_data['digest'] = intval($num);
		return $this;
	}

	public function addTodaypost($num) {
		$this->_increaseData['todaypost'] = intval($num);
		return $this;
	}

	public function setTodaypost($num) {
		$this->_data['todaypost'] = intval($num);
		return $this;
	}

	public function addTodayupload($num) {
		$this->_increaseData['todayupload'] = intval($num);
		return $this;
	}

	public function setTodayupload($num) {
		$this->_data['todayupload'] = intval($num);
		return $this;
	}

	/**
	 * ӹעͳ
	 *
	 * @param int $follow ӵĹע
	 */
	public function addFollows($follows) {
		$this->_increaseData['follows'] = intval($follows);
		return $this;
	}

	/**
	 * ӷ˿ͳ
	 *
	 * @param int $fans ӵķ˿
	 */
	public function addFans($fans) {
		$this->_increaseData['fans'] = intval($fans);
		return $this;
	}
	
	/**
	 * δ֪ͨ
	 * 
	 * @param int $notices
	 */
	public function setNoticeCount($notices){
		$this->_data['notices'] = intval($notices);
		return $this;
	}
	
	/**
	 * δϢ
	 * 
	 * @param int $messages
	 */
	public function setMessageCount($messages){
		$this->getDm()->setMessageCount($messages);
		$this->_data['messages'] = intval($messages);
		return $this;
	}
	
	/**
	 * ʱ
	 *
	 * @param int $online
	 */
	public function setOnline($online) {
		$this->_data['onlinetime'] = intval($online);
		return $this;
	}

	/**
	 * ʱ
	 *
	 * @param int $online
	 */
	public function addOnline($online) {
		$this->_increaseData['onlinetime'] = intval($online);
		return $this;
	}
	
	/**
	 * óĴ¼
	 *
	 * @param string $trypwd
	 * @return PwUserInfoDm
	 */
	public function setTrypwd($trypwd) {
		$this->_data['trypwd'] = $trypwd;
		return $this;
	}
	
	/**
	 * һĴ¼
	 *
	 * @param string $findwd
	 * @return PwUserInfoDm
	 */
	public function setFindpwd($findwd) {
		$this->_data['findpwd'] = $findwd;
		return $this;
	}
	
	/**
	 * ϴηhash
	 *
	 * @param string $str hash
	 */
	public function setPostcheck($str) {
		$this->_data['postcheck'] = $str;
		return $this;
	}
	
	/** 
	 * ûͨĵȼ
	 *
	 * @param int $memberid
	 */
	public function setMemberid($memberid) {
		$this->_data['memberid'] = intval($memberid);
		return $this;
	}
	
	/** 
	 * עԭ
	 *
	 * @param string $regreason
	 * @return PwUserInfoDm
	 */
	public function setRegreason($regreason) {
		$this->_data['regreason'] = $regreason;
		return $this;
	}
	
	/** 
	 * ù̶绰
	 *
	 * @param string $phone
	 * @return PwUserInfoDm
	 */
	public function setTelphone($phone) {
		$this->_data['telphone'] = $phone;
		return $this;
	}
	
	/** 
	 * ͨŵַ
	 *
	 * @param string $address
	 * @return PwUserInfoDm
	 */
	public function setAddress($address) {
		$this->_data['address'] = $address;
		return $this;
	}
	
    /** 
     * 
     *
     * @param string $zipcode
     * @return PwUserInfoDm
     */
    public function setZipcode($zipcode) {
    	$this->_data['zipcode'] = $zipcode;
    	return $this;
    }
    
    /* (non-PHPdoc)
     * @see PwBaseDm::getField()
     */
    public function getField($field) {
		if ($this->dm && ($result = $this->dm->getField($field)) !== null) {
			return $result;
		}
		return parent::getField($field);
    }
	
	/** 
	 * Ϣ
	 *
	 * @param int $message_tone
	 * @return PwUserInfoDm
	 */
	public function setMessage_tone($message_tone) {
		$this->_data['message_tone'] = $message_tone;
		return $this;
	}
	
	/**
	 * ûϲͳ
	 */
	public function setLikes($number) {
		$this->_data['likes'] = intval($number);
		return $this;
	}
	
	/**
	 * û˽
	 */
	public function setSecret($secrets) {
		$this->_data['secret'] = serialize($secrets);
		return $this;
	}
	
	/**
	 * ôϢ
	 */
	public function setPunch($punch) {
		$this->_data['punch'] = serialize($punch);
		return $this;
	}
	
	/**
	 * ü
	 */
	public function setJoinForum($join_forum) {
		$this->_data['join_forum'] = $join_forum;
		return $this;
	}
	
	/**
	 * ÿܸȤ
	 */
	public function setRecommendFriend($recommend_friend) {
		$this->_data['recommend_friend'] = $recommend_friend;
		return $this;
	}
	
	/**
	 * ֱ䶯־
	 *
	 * @param string $log
	 * @return PwUserInfoDm
	 */
	public function setLastCreditAffectLog($log) {
		$this->_data['last_credit_affect_log'] = $log;
		return $this;
	}
	
	/**
	 * ѫID
	 *
	 * @param array $medalids 
	 */
	public function setMedalIds($medalids) {
		$this->_data['medal_ids'] = implode(',', $medalids);
		return $this;
	}
	
	/**
	 * ֪ͨ
	 * 
	 * @param int $num
	 */
	public function addNotice($num) {
		$this->_increaseData['notices'] = intval($num);
		return $this;
	}
	
	/**
	 * Ϣ
	 * 
	 * @param int $num
	 */
	public function addMessages($num) {
		$this->getDm()->addMessages($num);
		$this->_increaseData['messages'] = intval($num);
		return $this;
	}
	
	/**
	 * ûϢ
	 */
	public function getUserBelongs() {
		return $this->_belong; 
	}
	
	/* (non-PHPdoc)
	 * @see WindidUserDm::beforeUpdate()
	 */
	protected function _beforeUpdate() {
		if (0 >= $this->uid) return new PwError('USER:illegal.id');
		if ($this->dm && WINDID_CONNECT == 'db' && ($result =  $this->dm->beforeUpdate()) !== true) {
			return $this->_getWindidMsg($result);
		}
		if (true !== ($result = $this->check())) return $result;
		return true;
	}
	
	/* (non-PHPdoc)
	 * @see WindidUserDm::beforeAdd()
	 */
	protected function _beforeAdd() {
		if (!$this->dm) {
			return new PwError('USER:user.info.error');
		}
		if (($result = PwUserValidator::isUsernameHasIllegalChar($this->getField('username'))) !== false) {
			return $result;
		}
		if (($result = PwUserValidator::isPwdValid($this->_password, $this->getField('username'))) !== true) {
			return $result;
		}
		if (WINDID_CONNECT == 'db' && ($result = $this->dm->beforeAdd()) !== true) {
			return $this->_getWindidMsg($result);
		}
		if (true !== ($result = $this->check())) return $result;
		return true;
	}
	
	/** 
	 * ת
	 * 
	 * @return boolean|PwError 
	 */
	protected function check() {
		if ($this->_data['groups']) {
			$this->_data['groups'] = implode(',', $this->_data['groups']);
		}

		//ûֻ֤ʽ֤
		if (($_tmp = $this->getField('mobile')) && (true !== ($r = PwUserValidator::isMobileValid($_tmp)))) {
			return $r;
		}
		//û̶֤绰ʽ֤
		if (($_tmp = $this->getField('telphone')) && (true !== ($r = PwUserValidator::isTelPhone($_tmp)))) {
			return $r;
		}
		//û֤ʱʽ֤
		if (($_tmp = $this->getField('zipcode')) && (false === WindValidator::isZipcode($_tmp))) {
			return new PwError('USER:error.zipcode');
		}
		//û֤ҳ
		if (($_tmp = $this->getField('homepage')) && (false === WindValidator::isUrl($_tmp) || true === WindValidator::isLegalLength($_tmp, 200))) {
			return new PwError('USER:error.homepage');
		}
		//û֤Ҽ鳤
		if (($_tmp = $this->getField('profile')) && (true === WindValidator::isLegalLength($_tmp, 250))) {
			return new PwError('USER:error.profile.length', array('{length}' => 250));
		}
		
		//TODOû֤BBSǩ֤ж----̨Ȩ
		/*
		if (($_tmp = $this->getField('bbs_sign')) && (true === WindValidator::isLegalLength($_tmp, 500))) {
			return new PwError('USER:error.bbs_sign.length', array('{length}' => 500));
		}
		*/
		return true;
	}

	protected function _getWindidMsg($result) {
		$errorCode = $result->getCode();
		$var = array();
		if ($errorCode == -2) {
			$config = WindidApi::C('reg');
			$var = array('{min}' => $config['security.username.min'], '{max}' => $config['security.username.max']);
		}
		if ($errorCode == -11) {
			$config = WindidApi::C('reg');
			$var = array('{min}' => $config['security.password.min'], '{max}' => $config['security.password.max']);
		}
		return new PwError('WINDID:code.' . $errorCode, $var);
	}
}