<?php
Wind::import('SRV:user.PwUserBan');

/**
 * ûBanBP
 *
 * @author xiaoxia.xu<xiaoxia.xuxx@aliyun-inc.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id: PwBanBp.php 23904 2013-01-17 05:27:48Z xiaoxia.xuxx $
 * @package src.service.user.srv
 */
class PwBanBp {
	private $uid = 0;
	
	private $banInfo = array();
	private $endCallBack = array();
	private $banType = array();
	/**
	 * 캯
	 *
	 * @param int $uid
	 */
	public function __construct($uid) {
		$this->uid = intval($uid);
		$this->banType = Wekit::load('user.srv.PwUserBanService')->getBanType();
		foreach ($this->banType as $_k => $_value) {
			$this->banInfo[$_k] = array(false, array());
		}
	}
	
	/**
	 * ʼеĽֹϢ
	 */
	public function checkIfBan() {
		$banInfo = $this->_getDs()->getBanInfo($this->uid);
		if (!$banInfo) return false;
		foreach ($this->banType as $_k => $_value) {
			$this->banInfo[$_k][0] = true;
		}
		foreach ($banInfo as $key => $_one) {
			$this->banInfo[$_one['typeid']][1][] = $_one;
		}
		return true;
	}
	
	/**
	 * ǷнֹϢ
	 * 
	 * @return boolean
	 */
	public function checkIfBanSpeak() {
		return $this->_checkIfBan(PwUserBan::BAN_SPEAK);
	}
	
	/**
	 * ֹ
	 * 
	 * @return false|mixed
	 */
	public function endDateTimeBanSpeak() {
		return $this->_endDateTimeBanSpeak(PwUserBan::BAN_SPEAK);
	}
	
	/**
	 * ȡֹ֮ķؽ
	 *
	 * @return mixed
	 */
	public function callEndDateTimeBanSpeak() {
		return $this->_callEndDateTimeBan(PwUserBan::BAN_SPEAK);
	}
	
	/**
	 * ýֹϢ
	 * 
	 * @return array
	 */
	public function getBanSpeakInfo() {
		return $this->_getBanInfo(PwUserBan::BAN_SPEAK);
	}
	
	/**
	 * ǷнֹǩϢ
	 *
	 * @return boolean
	 */
	public function checkIfBanSign() {
		return $this->_checkIfBan(PwUserBan::BAN_SIGN);
	}
	
	/**
	 * ֹǩ
	 *
	 * @return false|mixed
	 */
	public function endDateTimeBanSign() {
		return $this->_endDateTimeBanSpeak(PwUserBan::BAN_SIGN);
	}
	
	/**
	 * ȡֹǩ֮ķؽ
	 *
	 * @return mixed
	 */
	public function callEndDateTimeBanSign() {
		return $this->_callEndDateTimeBan(PwUserBan::BAN_SIGN);
	}
	
	/**
	 * ýֹǩϢ
	 *
	 * @return array
	 */
	public function getBanSignInfo() {
		return $this->_getBanInfo(PwUserBan::BAN_SIGN);
	}
	
	/**
	 * ǷнֹͷϢ
	 *
	 * @return boolean
	 */
	public function checkIfBanAvatar() {
		return $this->_checkIfBan(PwUserBan::BAN_AVATAR);
	}
	
	/**
	 * ֹͷ
	 *
	 * @return false|mixed
	 */
	public function endDateTimeBanAvatar() {
		return $this->_endDateTimeBanSpeak(PwUserBan::BAN_AVATAR);
	}
	
	/**
	 * ȡֹͷ֮ķؽ
	 *
	 * @return mixed
	 */
	public function callEndDateTimeBanAvatar() {
		return $this->_callEndDateTimeBan(PwUserBan::BAN_AVATAR);
	}
	
	/**
	 * ýֹͷϢ
	 *
	 * @return array
	 */
	public function getBanAvatarInfo() {
		return $this->_getBanInfo(PwUserBan::BAN_AVATAR);
	}
	
	/**
	 * ûûнֹԼ¼ûIDȷʵֹû飬ûϢ޸
	 * 
	 * @return mixed
	 */
	public function recoveryBanSpeaKError() {
		return $this->_recoverBanError(PwUserBan::BAN_SPEAK);
	}
	
	/**
	 * ûûнֹǩ¼û״̬ȷʵнֹǩǩ״̬޸
	 *
	 * @return mixed
	 */
	public function recoveryBanSignError() {
		return $this->_recoverBanError(PwUserBan::BAN_SIGN);
	}
	
	/**
	 * ûûнֹͷ¼û״̬ȷʵнֹͷǩ״̬޸
	 *
	 * @return mixed
	 */
	public function recoveryBanAvatarError() {
		return $this->_recoverBanError(PwUserBan::BAN_AVATAR);
	}
	
	/**
	 * ֹϢĴ޸
	 *
	 * @param int $type
	 * @return boolean|mixed
	 */
	private function _recoverBanError($type = PwUserBan::BAN_SPEAK) {
// 		if ($this->_getBanInfo($type)) return false;
		$class = Wekit::load($this->banType[$type]['class']);
		return call_user_func_array(array($class, 'deleteBan'), array($this->uid));
	}
	
	/**
	 * жĪǷ񱻽ֹ
	 *
	 * @param int $type
	 * @return boolean
	 */
	private function _checkIfBan($type = PwUserBan::BAN_SPEAK) {
		if (!array_key_exists($type, $this->banType)) return false;
		if (false === $this->banInfo[$type][0]) {
			$this->banInfo[$type][0] = true;
			$this->banInfo[$type][1] = $this->_getDs()->getBanInfoByTypeid($this->uid, $type);
		}
		return empty($this->banInfo[$type][1]) ? false : true;
	}
	
	/**
	 * ĳֹ͵ʱ޵Ľֹ
	 *
	 * @param int $type
	 * @return boolean
	 */
	private function _endDateTimeBanSpeak($type = PwUserBan::BAN_SPEAK) {
		if (false === $this->_checkIfBan($type)) return true;
		$t = $this->_autoEndBan($type);
		return $t ? (false === $this->_checkIfBan($type) ? true : false) : false; 
	}
	
	/**
	 * ĳֹ¼
	 *
	 * @param int $type
	 * @return array
	 */
	private function _getBanInfo($type = PwUserBan::BAN_SPEAK) {
		$this->_endDateTimeBanSpeak($type);
		reset($this->banInfo[$type][1]);
		return current($this->banInfo[$type][1]);
	}
	
	/**
	 * ĳֹ֮󷵻صϢ
	 *
	 * @param int $type
	 * @return mixed
	 */
	private function _callEndDateTimeBan($type = PwUserBan::BAN_SPEAK) {
		return isset($this->endCallBack[$type]) ? $this->endCallBack[$type] : null;
	}
	
	/**
	 * ڵĽֹ¼
	 *
	 * @param array $banInfo
	 * @return mixed
	 */
	private function _autoEndBan($type = PwUserBan::BAN_SPEAK) {
		$_notice = $clear = array();
		$now = Pw::getTime();
		foreach ($this->banInfo[$type][1] as $_key => $item) {
			if (($item['end_time'] != 0) && $item['end_time'] < $now) {
				$clear[] = $item['id'];
				//͵ĺ
				$class = Wekit::load($this->banType[$item['typeid']]['class']);
				$this->endCallBack[$item['typeid']] = call_user_func_array(array($class, 'deleteBan'), array($item['uid']));
		
				$_notice['end_time'] = $item['end_time'];
				$_notice['reason'] = $item['reason'];
				$_notice['type'][] = $item['typeid'];
				$_notice['operator'] = 'system';
				unset($this->banInfo[$type][1][$_key]);
			}
		}
		$isEnd = false;
		if ($clear) {
			$isEnd = true;
			$this->_getDs()->batchDelete($clear);
			//ԶϢ
			/* @var $banService PwUserBanService */
			$banService = Wekit::load('user.srv.PwUserBanService');
			$banService->sendNotice(array($this->uid => $_notice), 3);
		}
		return $isEnd;
	}
	
	/**
	 * ûֹ
	 *
	 * @return PwUserBan
	 */
	private function _getDs() {
		return Wekit::load('user.PwUserBan');
	}
}