<?php

/**
 * û
 *
 * @author xiaoxia.xu <xiaoxia.xuxx@aliyun-inc.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id: PwClearUserService.php 24640 2013-02-01 09:51:40Z xiaoxia.xuxx $
 * @package src.service.user.srv
 */
class PwClearUserService extends PwBaseHookService {
	
	private $uid = 0;
	private $operator = null;
	private $totalClearTypes = 0;
	private $nowClearTypes = 0;

	/**
	 * ûϢ
	 */
	public function __construct($uid = 0, PwUserBo $operator = null) {
		$this->uid = intval($uid);
		$operator && $this->operator = $operator;
	}

	/**
	 * ִ
	 *
	 * @param array $clearType Ŀ
	 * @return boolean
	 */
	public function run($clearType) {
		if (0 >= $this->uid || empty($clearType)) return false;
		$this->init($clearType);
		if ($this->nowClearTypes == 0) return false;
		$this->runDo('gleanData', $this->operator);
		$this->runDo('run', $this->uid);
		//ûȫϢʱ򣬽û
		if ($this->ifClearAllUserInfo()) {
			$result = $this->_getUserDs()->deleteUser($this->uid);
			Wekit::load('user.srv.PwUserService')->restoreDefualtAvatar($this->uid);
		}
		return true;
	}

	/**
	 * ǷʺŵϢ(Ƿtrue򷵻false)
	 * 
	 * @return boolean
	 */
	public function ifClearAllUserInfo() {
		return $this->nowClearTypes == $this->totalClearTypes;
	}
	/**
	 * ֵ֧ûĿ,ɶͽչ
	 * 
	 * @return array
	 */
	public function getClearTypes() {
		//ûչ-ӵhooks.PwClearUser
		return array(
			'topic' => array('title' => '', 'class' => 'SRC:hooks.PwClearUser.PwClearDoTopic'),  //
			'post' => array('title' => 'ظ', 'class' => 'SRC:hooks.PwClearUser.PwClearDoPost'),  //ظ
			'message' => array('title' => 'Ϣ', 'class' => 'SRC:hooks.PwClearUser.PwClearDoMessage'),  //Ϣ
			//'fresh' => array('title' => '', 'class' => 'SRC:hooks.PwClearUser.PwClearDoFresh')//
		);
	}
	
	/* (non-PHPdoc)
	 * @see PwBaseHookService::_getInterfaceName()
	 */
	protected function _getInterfaceName() {
		return 'iPwGleanDoHookProcess';
	}
	
	/**
	 * ʼ
	 */
	private function init($clearType) {
		$types = $this->getClearTypes();
		$num = 0;
		foreach ($clearType as $item) {
			$_type = isset($types[$item]) ? $types[$item] : array();
			if (!$_type || !$_type['class']) continue;
			/* @var $instance iPwDoHookProcess */
			$this->appendDo(Wekit::getInstance($_type['class'], '', array($this)));
			$num ++;
		}
		$this->totalClearTypes = count($types);
		$this->nowClearTypes = $num;
		return true;
	}
	
	/** 
	 * ûDs
	 *
	 * @return PwUser
	 */
	private function _getUserDs() {
		return Wekit::load('user.PwUser');
	}
}