<?php
Wind::import('LIB:utility.PwMail');
Wind::import('SRV:user.dm.PwUserInfoDm');
/**
 * ûһ
 *
 * @author xiaoxia.xu <xiaoxia.xuxx@aliyun-inc.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.phpwind.com
 * @version $Id: PwFindPassword.php 24177 2013-01-22 10:36:09Z xiaoxia.xuxx $
 * @package src.service.user.srv
 */
class PwFindPassword {
	/* @var $byMobileNum int ֻһʹõĴ */
	private $byMobileNum = 5;
	/* @var $byEmaialNum int һʹõĴ */
	private $byEmailNum = 5;
	/* @var $spaceDay int ﵽ޵ʱ´οʹõʱλ죩*/
	private $spaceDay = 1;
	private $info = array();
	
	const WAY_EMAIL = 'email';
	const WAY_MOBILE = 'mobile';
	
	/**
	 * 캯
	 *
	 * @param string $username
	 */
	public function __construct($username) {
		/* @var $userDs PwUser */
		$userDs = Wekit::load('user.PwUser');
		$info = $userDs->getUserByName($username, PwUser::FETCH_MAIN | PwUser::FETCH_DATA | PwUser::FETCH_INFO);
		if (!$info) {
			$info = $this->_getWindid()->getUser($username, 2);
			if (!$info) return;
			Wind::import('SRV:user.srv.PwRegisterService');
			$registerService = new PwRegisterService();
			$info = $registerService->sysUser($info['uid']);
			if ($info) {
				$info = array_merge($info, $this->_getUserDs()->getUserByUid($info['uid'], PwUser::FETCH_INFO));
			}
		}
		$this->info = $info;
	}
	
	/**
	 * Ƿȷ
	 *
	 * @param string $email 
	 * @return boolean|PwError
	 */
	public function checkEmail($email) {
		if (!$this->info) return new PwError('USER:illegal.request');
		if ($this->info['email'] != $email) {
			return new PwError('USER:findpwd.error.email');
		}
		if (true !== ($check = $this->allowFindBy(self::WAY_EMAIL))) return $check;
		return true;
	}
	
	/**
	 * ʼ
	 *
	 * @param string $state ܴ
	 * @return boolean
	 */
	public function sendResetEmail($state) {
		if (true !== ($check = $this->allowFindBy(self::WAY_EMAIL))) return $check;
		//TODO ķ
		$code = substr(md5(Pw::getTime()), mt_rand(1, 8), 8);
		$url = WindUrlHelper::createUrl('u/findPwd/resetpwd', array('code' => $code, '_statu' => $state));
		list($title, $content) = $this->_buildTitleAndContent($this->info['username'], $url);
		/* @var $activeCodeDs PwUserActiveCode */
		$activeCodeDs = Wekit::load('user.PwUserActiveCode');
		$activeCodeDs->addActiveCode($this->info['uid'], $this->info['email'], $code, Pw::getTime(), PwUserActiveCode::RESETPWD);
		$mail = new PwMail();
		$mail->sendMail($this->info['email'], $title, $content);
		return true;
	}

	/**
	 * õ֤ǷЧ
	 *
	 * @param string $email õemailַ
	 * @param string $code  
	 * @return PwError|boolean
	 */
	public function checkResetEmail($email, $code) {
		if (empty($this->info) || $this->info['email'] != $email) {
			return new PwError('USER:illegal.request');
		}
		/* @var $activeCodeDs PwUserActiveCode */
		$activeCodeDs = Wekit::load('user.PwUserActiveCode');
		$info = $activeCodeDs->getInfoByUid($this->info['uid'], PwUserActiveCode::RESETPWD);
		if (!$info || $info['email'] != $email || $info['code'] != $code) return new PwError("USER:findpwd.email.code.expired");
		/*һ룺֤벻Ҫڼ֤*/
		if ($info['active_time'] > 0 ) return new PwError('USER:findpwd.email.code.expired');
		/*$validTime = $this->activeCodeValidTime * 3600;
		if (($info['send_time'] + $validTime) < Pw::getTime()) return new PwError('USER:active.email.overtime');*/
//		$activeCodeDs->activeCode($this->info['uid'], Pw::getTime());
		return true;
	}
	
	/**
	 * Ϣı
	 *
	 * @param string $titleKey   key
	 * @param string $contentKey key
	 * @param string $username û
	 * @param string $url ӵַ
	 * @return array
	 */
	private function _buildTitleAndContent($username, $url = '') {
		$search = array('{username}', '{sitename}');
		$replace = array($username, Wekit::C('site', 'info.name'));
		$title = str_replace($search, $replace, Wekit::C('login', 'resetpwd.mail.title'));
		$search[] = '{time}';
		$search[] = '{url}';
		$replace[] = Pw::time2str(Pw::getTime(), 'Y-m-d H:i:s');
		$replace[] = $url ? sprintf('<a href="%s">%s</a>', $url, $url) : '';
		$content = str_replace($search, $replace, Wekit::C('login', 'resetpwd.mail.content'));
		return array($title, $content);
	}
	
	/**
	 * ģʾ
	 *
	 * @return string
	 */
	public function getFuzzyEmail() {
		$email = $this->info['email'];
		$info = explode('@', $email);
		$info[0] = $info[0][0] . str_repeat('*', strlen($info[0]) - 1);
		return implode('@', $info);
	}
	
	/**
	 * emailӵַ
	 *
	 * @return string
	 */
	public function getEmailUrl() {
		$email = $this->info['email'];
		$info = explode('@', $email);
		return 'http://mail.' . $info[1];
	}
	
	/**
	 * Ƿʹһ
	 *
	 * @return boolean
	 */
	public function allowFindByMail() {
		if (false === $this->isBindMail()) return new PwError('USER:findpwd.notbind.email');
		return $this->allowFindBy(self::WAY_EMAIL);
	}
	
	/**
	 * Ƿʹֻһ
	 *
	 * @return boolean
	 */
	public function allowFindByMobile() {
		if (false === $this->isBindMobile()) return new PwError('USER:findpwd.notbind.mobile');
		return $this->allowFindBy(self::WAY_MOBILE);
	}
	
	/**
	 * Ƿemail
	 *
	 * @return boolean
	 */
	public function isBindMail() {
		return $this->info['email'] ? true : false;
	}
	
	
	/**
	 * Ƿֻ
	 *
	 * @return boolean
	 */
	public function isBindMobile() {
		return $this->info['mobile'] ? true : false;
	}
	
	/**
	 * жϵͨһǷѾ
	 *
	 * @return boolean
	 */
	public function isOverByMail() {
		return $this->allowFindBy(self::WAY_EMAIL) instanceof PwError ? true : false;
	}
	
	/**
	 * жϵֻͨһǷѾ
	 *
	 * @return boolean
	 */
	public function isOverByMobile() {
		return $this->allowFindBy(self::WAY_MOBILE) instanceof PwError ? true : false;
	}
	
	/**
	 * ĳɹ
	 *
	 * @param string $type
	 * @return boolean
	 */
	public function success($type) {
		//һ֤
		/* @var $activeCodeDs PwUserActiveCode */
		$activeCodeDs = Wekit::load('user.PwUserActiveCode');
		$activeCodeDs->activeCode($this->info['uid'], Pw::getTime());
		return $this->setRecode($type);
	}
	
	/**
	 * һΨһʶ
	 *
	 * @param string $username Ҫһû
	 * @param string $way һطʽʶ
	 * @param string $value һطʽӦֵ
	 * @return string
	 */
	public static function createFindPwdIdentify($username, $way, $value) {
		$code = Pw::encrypt($username . '|' . $way . '|' . $value, Wekit::C('site', 'hash') . '___findpwd');
		return rawurlencode($code);
	}
	
	/**
	 * һıʶ
	 *
	 * @param string $identify
	 * @return array array($username, $way, $value)
	 */
	public static function parserFindPwdIdentify($identify) {
		return explode("|", Pw::decrypt(rawurldecode($identify), Wekit::C('site', 'hash') . '___findpwd'));
	}
	
	/**
	 * ݷʽȡӦûֶ
	 *
	 * @param string $way
	 * @return string
	 */
	public static function getField($way) {
		return $way == self::WAY_MOBILE ? 'mobile' : 'email';
	}
	
	/**
	 * óԴ¼
	 *
	 * findpwdбʽΪ0000-00-00:num|0000-00-00:num
	 * 0000-00-00:¸ü¼ʱ
	 * num : ¼¼ʱַʽѾԵĴ
	 * |: |ģá䡱ʽһصļ¼|Ҳ࣬áֻʽһصļ¼
	 * @param string $type һ
	 * @return boolean|PwError
	 */
	private function allowFindBy($type = self::WAY_EMAIL) {
		$findPwd = $this->info['findpwd'];
		if (!$findPwd) return true;
		$typeCode = $type == self::WAY_MOBILE ? 0 : 1;
		$recodes = explode('|', $findPwd);
		if (empty($recodes[$typeCode])) return true;
		$tryNum = $type == self::WAY_MOBILE ? $this->byMobileNum : $this->byEmailNum;
		list($time, $num) = explode(':', $recodes[$typeCode]);
		if (($time != Pw::time2str(Pw::getTime(), 'Y-m-d')) || $num < $tryNum) return true;
		return new PwError('USER:findpwd.over.limit.' . $type);
	}
	
	/**
	 * һؼ¼
	 *
	 * findpwdбʽΪ0000-00-00:num|0000-00-00:num
	 * 0000-00-00:¸ü¼ʱ
	 * num : ¼¼ʱַʽѾԵĴ
	 * |: |ģá䡱ʽһصļ¼|Ҳ࣬áֻʽһصļ¼
	 * @param string $type
	 * @return true
	 */
	public function setRecode($type = self::WAY_EMAIL) {
		$findPwd = $this->info['findpwd'];
		$recodes = array(0 => '', 1 => '');
		$typeCode = $type == self::WAY_MOBILE ? 0 : 1;
		$tryTime = $type == self::WAY_MOBILE ? $this->byMobileNum : $this->byEmailNum;
		/*ûгһع*/
		if (!$findPwd) {
			$recodes[$typeCode] = Pw::time2str(Pw::getTime(), 'Y-m-d') . ':1';
		} else {
			list($recodes[0], $recodes[1]) = explode('|', $findPwd);
			/*÷ʽһ뷽ʽûгԹ*/
			if (!($recode = $recodes[$typeCode])) {
				$recodes[$typeCode] = Pw::time2str(Pw::getTime(), 'Y-m-d') . ':1';
			/*÷ʽһ뷽ʽԹ*/
			} else {
				list($time, $num) = explode(':', $recode);
				/*÷ʽϴһ벻ڽ췢ôǽһһ*/
				if (($time != Pw::time2str(Pw::getTime(), 'Y-m-d'))) {
					$recodes[$typeCode] = Pw::time2str(Pw::getTime(), 'Y-m-d') . ':1';
				/*첻ǵһγһ룬ҽ쳢һĴѾ涨׳*/
				} elseif ($num >= $tryTime) {
					return new PwError('USER:findpwd.over.limit.' . $type);
				/*¼һĴ*/
				} else {
					$recodes[$typeCode] = $time . ':' . ($num + 1);
				}
			}
		}
		/* @var $userDs PwUser */
		$userDs = Wekit::load('user.PwUser');
		$userdm = new PwUserInfoDm($this->info['uid']);
		$userdm->setFindpwd(implode('|', $recodes));
		return $userDs->editUser($userdm, PwUser::FETCH_DATA);
	}
	
	protected function _getWindid() {
		return WindidApi::api('user');
	}
}