<?php
Wind::import('SRV:user.PwUser');
Wind::import('SRV:user.dm.PwUserInfoDm');
Wind::import('SRV:credit.bo.PwCreditBo');
Wind::import('WIND:utility.WindValidator');
Wind::import('SRV:user.validator.PwUserValidator');

/**
 * û¼
 *
 * @author xiaoxia.xu <xiaoxia.xuxx@aliyun-inc.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.phpwind.com
 * @version $Id: PwLoginService.php 24931 2013-02-27 01:16:51Z xiaoxia.xuxx $
 * @package src.service.user.srv
 */
class PwLoginService extends PwBaseHookService {
	
	private $loginConfig = array();
	private $ipLimit = 100;
	
	/**
	 * Դﵽߴ֮һʱ30ڲٵ¼
	 * 
	 * @var int $trySpace 
	 */
	private $trySpace = 1800;
	
	public function __construct() {
		parent::__construct();
		$this->loginConfig = Wekit::C('login');
	}
	
	/**
	 * û¼
	 *
	 * @param string $username û¼ʺ
	 * @param string $password û¼
	 * @param string $ip ¼IP
	 * @param string $safeQuestion ȫ
	 * @param string $safeAnswer ȫ
	 * @return boolean|int
	 */
	public function login($username, $password, $ip, $safeQuestion = null, $safeAnswer = '') {
		$checkQ = !is_null($safeQuestion) ? true : false;
		Wind::import("SRV:user.srv.PwTryPwdBp");
		$pwdBp = new PwTryPwdBp();
		$info = $pwdBp->auth($username, $password, $ip, $checkQ, $safeQuestion, $safeAnswer);
		if ($info instanceof PwError) return $info;
		if (($result = $this->runWithVerified('afterLogin', $info)) instanceof PwError) return $result;
		return $info;
	}
	
	/**
	 * ¼
	 *
	 * @param string $username
	 * @return array
	 */
	public function checkInput($username) {
		$r = array();
		//ֻ¼
		if (PwUserValidator::isMobileValid($username) === true && in_array(4, $this->loginConfig['ways'])) {
			$mobileInfo = Wekit::load('user.PwUserMobile')->getByMobile($username);
			if (!$mobileInfo) return array();
			$r = $this->_getWindid()->getUser($mobileInfo['uid'], 1);
		}
		//UID¼
		if (!$r && is_numeric($username) && in_array(1, $this->loginConfig['ways'])) {
			$r = $this->_getWindid()->getUser($username, 1);
		}
		
		//email¼
		if (!$r && WindValidator::isEmail($username) && in_array(2, $this->loginConfig['ways'])) {
			$r = $this->_getWindid()->getUser($username, 3);
		}
		//û¼
		if (!$r && in_array(3, $this->loginConfig['ways'])) {
			$r = $this->_getWindid()->getUser($username, 2);
		}
		return $r;
	}
	
	/**
	 * õ¼cookie
	 *
	 * @param PwUserBo $userBo
	 * @param string $ip
	 * @param int $rememberme
	 */
	public function setLoginCookie(PwUserBo $userBo, $ip, $rememberme = 0) {
		//¼ɹûôε¼ĳ¼
		Wind::import("SRV:user.srv.PwTryPwdBp");
		$pwdBp = new PwTryPwdBp();
		$pwdBp->restoreTryRecord($userBo->uid, '');

		/* @var $userService PwUserService */
		$userService = Wekit::load('user.srv.PwUserService');
		$userService->createIdentity($userBo->uid, $userBo->info['password'], $rememberme);
		return $this->welcome($userBo, $ip);
	}
	
	/**
	 * ¼չ m_PwLoginService
	 * 
	 * @see PwUserLoginDoBase::welcome()
	 */
	public function welcome(PwUserBo $userBo, $ip) {
		/* @var $userService PwUserService */
		$userService = Wekit::load('user.srv.PwUserService');
		$userService->updateLastLoginData($userBo->uid, $ip);
		/* @var $creditBo PwCreditBo */
		$creditBo = PwCreditBo::getInstance();
		$creditBo->operate('login', $userBo);
		
		return $this->runDo('welcome', $userBo, $ip);
	}
	
	/**
	 * ¼ʶ
	 *
	 * @param array $userInfo ûϢ
	 * @return string
	 */
	public static function createLoginIdentify($userInfo) {
		$code = Pw::encrypt($userInfo['uid'] . "\t" . Pw::getPwdCode($userInfo['password']) . "\t" . Pw::getTime());
		return rawurlencode($code);
	}
	
	/**
	 * ¼ʶ
	 *
	 * @param string $identify Ҫıʶ
	 * @return array array($uid, $password)
	 */
	public static function parseLoginIdentify($identify) {
		$args = explode("\t", Pw::decrypt(rawurldecode($identify)));
		if ((Pw::getTime() - $args[2]) > 300) {
			return array(0, '');
		} else {
			return $args;
		}
	}
		
	/** 
	 * ûDs
	 *
	 * @return PwUser
	 */
	private function _getUserDs() {
		return Wekit::load('user.PwUser');
	}
	
	/** 
	 * windidDS
	 *
	 * @return WindidUserApi
	 */
	protected function _getWindid() {
		return WindidApi::api('user');
	}
		
	/* (non-PHPdoc)
	 * @see PwBaseHookService::_getInterfaceName()
	 */
	protected function _getInterfaceName() {
		return 'PwUserLoginDoBase';
	}
}