<?php
Wind::import('SRV:user.dm.PwUserBanInfoDm');
Wind::import('SRV:user.PwUserBan');
/**
 * ûֹ
 * ûΪֹ
 * avatar: ֹûʹͷ
 * sign ֹûʹǩ
 * speakֹû
 *
 * @author xiaoxia.xu <xiaoxia.xuxx@aliyun-inc.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.phpwind.com
 * @version $Id: PwUserBanService.php 23904 2013-01-17 05:27:48Z xiaoxia.xuxx $
 * @package src.service.user.srv
 */
class PwUserBanService {
	
	/**
	 * û/ûIDֹû
	 *
	 * @param array $dmList PwUserBanInfoDm б
	 * @return boolean
	 */
	public function banUser($dmList) {
		$banTypes = $this->getBanType();
		foreach ($dmList as $_dm) {
			if (!$_dm instanceof PwUserBanInfoDm) continue;
			if (true !== ($r = $_dm->beforeAdd())) return $r;
			$r = $this->_getDs()->addBanInfo($_dm);
			if ($r instanceof PwError) return $r;
			
			//͵ĺ
			$class = Wekit::load($banTypes[$_dm->getField('typeid')]['class']);
			$r = call_user_func_array(array($class, 'afterBan'), array($_dm));
			if ($r instanceof PwError) return $r;
		}
		return true;
	}
	
	/**
	 * 
	 *
	 * @param PwUserBanSo $searchDo 
	 * @param int $limit  
	 * @param int $start  ʼλ
	 * @return array
	 */
	public function searchBanInfo(PwUserBanSo $searchDo, $limit = 10, $start = 0) {
		$result = array();
		$list = $this->_getDs()->searchBanInfo($searchDo, $limit, $start);
		foreach ($list as $id => $item) {
			$result[$item['id']] = $this->_buildList($item);
		}
		return $result;
	}
	
	/**
	 * ֹ
	 *
	 * @param array $ids
	 * @return boolean
	 */
	public function batchDelete($ids) {
		$list = $this->_getDs()->fetchBanInfo($ids);
		$banTypes = $this->getBanType();
		$clearIds = array();
		foreach ($list as $_item) {
			$clearIds[] = $_item['id'];
			//͵ĺ
			$class = Wekit::load($banTypes[$_item['typeid']]['class']);
			call_user_func_array(array($class, 'deleteBan'), array($_item['uid']));
		}
		$r = $this->_getDs()->batchDelete($clearIds);
		return $r instanceof PwError ? $r : $list;
	}
	
	/**
	 * ýֹ
	 * //TODO ûֹֹչ
	 * @return array
	 */
	public function getBanType() {
		$types = array(
			1 => array('title' => 'ֹ', 'class' => 'SRV:user.srv.bantype.PwUserBanSpeak'),
			2 => array('title' => 'ֹͷ', 'class' => 'SRV:user.srv.bantype.PwUserBanAvatar'),
			4 => array('title' => 'ֹǩ', 'class' => 'SRV:user.srv.bantype.PwUserBanSign'),
		);
		return $types;
	}

	/**
	 * Զֹû
	 * 
	 * ûб䶯ʱִ
	 * ûs_PwUserDataDao_updateΪhookִ
	 *
	 * @param int $uid
	 * @param array $fields 
	 * @param array $increaseFields 
	 * @return array
	 */
	public function autoBan($uid, $fields, $increaseFields) {
		//[Զֹûп]
		$config = Wekit::C('site');
		if (0 == $config['autoForbidden.open'] || !$config['autoForbidden.type']) return false;
		//[Զֹ]µĻûڽַֹΧ
		$credit = $config['autoForbidden.condition']['credit'];
		$key = 'credit' . $credit;
		if (!in_array($key, array_keys($fields)) && !in_array($key, array_keys($increaseFields))) {
			return false;
		}
		//[ֹûеֹ]
		$userBo = new PwUserBo($uid);
		if ($userBo->getCredit($credit) >= $config['autoForbidden.condition']['num']) return false;
		//ִнֹ
		$dmList = array();
		$endTime = $config['autoForbidden.day'] > 0 ? $config['autoForbidden.day'] * 24 *3600 + Pw::getTime() : 0;
		foreach ($config['autoForbidden.type'] as $type) {
			$banDm = new PwUserBanInfoDm();
			$banDm->setEndTime($endTime)
				->setTypeid($type)
				->setReason($config['autoForbidden.reason'])
				->setCreatedUid(0)
				->setUid($uid);
			$dmList[] = $banDm;
		}
		$this->banUser($dmList);
		//Ϣ
		$_notice = array($uid => array('end_time' => $endTime, 'reason' => $config['autoForbidden.reason'], 'type' => $config['autoForbidden.type'], 'operator' => 'system'));
		$this->sendNotice($_notice, 1);
		return true;
	}

	/**
	 * Ϣ
	 *
	 * @param array $notice
	 * @param int $type Ϣ͡1ֹ23Զ
	 * @return boolean
	 */
	public function sendNotice($bans, $type = 1) {
		/* @var $notice PwNoticeService */
		$notice = Wekit::load('SRV:message.srv.PwNoticeService');
		$banTypes = $this->getBanType();
		foreach ($bans as $uid => $_item) {
			$extends = array();
			$extends['operator'] = $_item['operator'];
			foreach ($_item['type'] as $_i) {
				isset($banTypes[$_i]) && $extends['type'][] = $banTypes[$_i]['title'];
			}
			if (!$extends['type']) continue;
			$extends['end_time'] = $_item['end_time'];
			$extends['created_time'] = $_item['created_time'];
			$extends['reason'] = $_item['reason'];
			$extends['ban'] = $type;
			$notice->sendNotice($uid, 'ban', $uid, $extends);
		}
		return true;
	}
	
	/**
	 * װбϢ
	 *
	 * @param array $item
	 * @return array
	 */
	private function _buildList($item) {
		$banTypes = $this->getBanType();
		/* @var $obj PwForum */
		$obj = Wekit::load('forum.PwForum');
		$type = $banTypes[$item['typeid']];
		$item['type'] = $type['title'];
		$item['child'] = 'ȫ';
		if ($item['fid']) {
			/* @var $class PwUserBanTypeInterface */
			$class = Wekit::load($banTypes[$item['typeid']]['class']);
			$item['child'] = $class->getExtension($item['fid']);
		}
		/* @var $userDs PwUser */
		$userDs = Wekit::load('user.PwUser');
		$list = $userDs->fetchUserByUid(array($item['created_userid'], $item['uid']), PwUser::FETCH_MAIN);
		$item['created_username'] = $item['created_userid'] == 0 ? 'system' : $list[$item['created_userid']]['username'];
		$item['username'] = $list[$item['uid']]['username'];
		return $item;
	}
	
	/** 
	 * ûֹ
	 *
	 * @return PwUserBan
	 */
	private function _getDs() {
		return Wekit::load('user.PwUserBan');
	}
}