<?php
Wind::import('SRV:user.dm.PwUserInfoDm');
/**
 * ûҵӿ
 *
 * @author xiaoxia.xu <xiaoxia.xuxx@aliyun-inc.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.phpwind.com
 * @version $Id: PwUserService.php 24736 2013-02-19 09:24:40Z jieyin $
 * @package src.service.user.srv
 */
class PwUserService {

	/** 
	 * ֤û
	 * 
	 * ش PwError->getError():
	 * <ul>
	 * <li>-1: û</li>
	 * <li>-2: û</li>
	 * <li>-3: ûȫشȷ</li>
	 * </ul>
	 * 
	 * @param string $username û
	 * @param string $password û
	 * @param int $type ֤ <1ûid, 2: û, 3ûemail>
	 * @param string $question ȫ
	 * @param string $answer   ȫĴ
	 * @return PwError|array
	 */
	public function verifyUser($username, $password, $type = 1, $question = null, $answer = null) {
		$checkSafe = is_null($question) && is_null($answer) ? false : true;
		$result = $this->_getWindidUser()->login($username, $password, $type, $checkSafe, $question, $answer);
		switch ($result[0]) {
			case 1://ûϢ
				return $result[1];
			case -14://û
				return new PwError('USER:verify.error.name');
			case -13://û
				return new PwError('USER:verify.error.pwd');
			case -20://ûȫ
				return new PwError('USER:verify.error.question');
		}
	}

	/** 
	 * ˳ϵͳ
	 * 
	 * @return boolean
	 */
	public function logout() {
		$loginUser = Wekit::getLoginUser();
		PwSimpleHook::getInstance('PwUserService_logout')->runDo($loginUser);
		$loginUser->reset();
		return Pw::setCookie('winduser', '', -1);
	}
	
	/** 
	 * ûӵϢøûĵǰʹõû
	 * <pre>
	 * ûӵеʹ˳
	 * <ol>
	 * <li>ϵͳ  Ա</li>
	 * <li>Ȼڵid˳б</li>
	 * </ol>
	 * </pre>
	 *
	 * @param int $groupid ûǰû
	 * @param array $userGroups ûӵе
	 * @return array (gid, groups)
	 */
	public function caculateUserGroupid($groupid, $userGroups) {
		$banGids = array(1, 2, 6, 7);
		// ο/ֹ/δ֤û򲻱䶯û
		if (in_array($groupid, $banGids)) return array($groupid, array());
		//ǰû顿 ǰû˳:ϵͳ//ͨ
		$groupQue = array('system', 'special');
		$temp = array();
		$time = Pw::getTime();
		foreach ($userGroups as $_gid => $_time) {
			if ($_time == 0 || $_time > $time) {
				$temp[$_gid] = $_time;
			}
		}
		$gid = 0;
		if ($temp) {
			/* @var $groupDs PwUserGroups */
			$groupDs = Wekit::load('usergroup.PwUserGroups');
			$groups = $groupDs->getClassifiedGroups();
			$userGids = array_keys($temp);
			foreach ($groupQue as $_tmpType) {
				/*ûӵϵͳ飬ûIDСĵһûΪûǰʾ*/
				$_tmp = array_intersect(array_keys($groups[$_tmpType]), $userGids);
				if ($_tmp) {
					ksort($_tmp);
					$gid = array_shift($_tmp);
					break;
				}
			}
		}
		//ǰû
		if (!$temp[$groupid]) {
			$groupid = $gid;
		}
		return array($groupid, $temp);
	}

	/** 
	 * ¼ûʶ
	 *
	 * @param int $uid ûID
	 * @param string $password û
	 * @param int $rememberme Ƿüסǰûס򱣴1
	 * @return boolean
	 */
	public function createIdentity($uid, $password, $rememberme = 0) {
		$identity = Pw::encrypt($uid . "\t" . Pw::getPwdCode($password));
		return Pw::setCookie('winduser', $identity, $rememberme ? 31536000 : NULL);
	}

	/** 
	 * û¼Ϣ
	 *
	 * @param int $uid ûID
	 * @param string $ip ûIP
	 * @return boolean
	 */
	public function updateLastLoginData($uid, $ip) {
		$dm = new PwUserInfoDm($uid);
		$dm->setLastvisit(Pw::getTime())->setLastloginip($ip);
		return $this->_getUserDs()->editUser($dm, PwUser::FETCH_DATA);
	}
	
	/**
	 * жϸûǷðȫ
	 *
	 * @param int $uid
	 * @return boolean
	 */
	public function isSetSafecv($uid) {
		$info = WindidApi::api('user')->getUser($uid, 1);
		return !empty($info['safecv']);
	}
	
	/** 
	 * жûǷðȫ
	 * ǰûӵе()һǱҪðȫʹ𰸵ģûðȫʹ
	 * 
	 * @param int $uid ûID
	 * @return boolean
	 */
	public function mustSettingSafeQuestion($uid) {
		$groups = $this->getGidsByUid($uid);
		$mustSettingGroups = Wekit::C('login', 'question.groups');
		return !$mustSettingGroups ? false : (array_intersect($groups, $mustSettingGroups) ? true : false);
	}
	
	/**
	 * ûIDøûӵеû
	 *
	 * @param int $uid 
	 * @return array
	 */
	public function getGidsByUid($uid) {
		if (!$uid) return array();
		$info = Wekit::load('user.PwUser')->getUserByUid($uid, PwUser::FETCH_MAIN);
		return array_merge(explode(',', $info['groups']), array($info['groupid'], $info['memberid']));
	}
	
	/**
	 * ԭͷ
	 *
	 * @param int $uid
	 * @param string $type ԭ-һĬͷface*,һǽֹͷban*
	 * @return boolean
	 */
	public function restoreDefualtAvatar($uid, $type = 'face') {
		$result =  $this->_getWindidAvatar()->defaultAvatar($uid, $type);
		if ($result < 1) return false;
		return true;
	}
	
	/**
	 * ðȫ
	 * 
	 * @param int|null $id
	 * @return array
	 */
	public function getSafeQuestion($id = null) {
		$qList = array(
			1 => 'Ұְֵĳ',
			2 => 'ĳ',
			3 => 'ҵСѧУ',
			4 => 'ҵѧУ',
			5 => 'ϲ˶',
			6 => 'ϲĸ',
			7 => 'ϲĵӰ',
			8 => 'ϲɫ'
		);
		return is_null($id) ? $qList : (isset($qList[$id]) ? $qList[$id] : $id);
	}
	
	/** 
	 * ûDs
	 *
	 * @return PwUser
	 */
	private function _getUserDs() {
		return Wekit::load('user.PwUser');
	}
	
	/** 
	 * ûDs
	 *
	 * @return PwUserGroups
	 */
	private function _getUserGroupDs() {
		return Wekit::load('usergroup.PwUserGroups');
	}

	/** 
	 * windidUser
	 *
	 * @return WindidUserApi
	 */
	private function _getWindidUser() {
		return WindidApi::api('user');
	}
	
	private function _getWindidAvatar() {
		return WindidApi::api('avatar');
	}
}
