<?php
/**
 * û֤
 *
 * @author xiaoxia.xu <xiaoxia.xuxx@aliyun-inc.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.phpwind.com
 * @version $Id: PwUserValidator.php 24943 2013-02-27 03:52:21Z jieyin $
 * @package  src.service.user.validator
 */
class PwUserValidator {

	/**
	 * ûĺϷ
	 *
	 * @param string $username
	 * @return boolean|PwError
	 */
	public static function isUsernameHasIllegalChar($username) {
		//ƥûֻܺġ֡Сдĸ'.'_
		if (0 >= preg_match('/^[\x7f-\xff\dA-Za-z\.\_]+$/', $username)) {
			return new PwError('USER:error.username');
		}
		return false;
	}
	
	/** 
	 * ûֻǷϷ
	 *
	 * @param string $password û
	 * @return PwError|boolean
	 */
	public static function isMobileValid($mobile) {
    	if (0 >= preg_match('/^1\d{10}$/', $mobile)) return new PwError('USER:mobile.error.formate');
		return true;
	}
	
	/**
	 * ̶绰Ƿȷ
	 *
	 * @param string $telPhone
	 * @return true|PwError
	 */
	public static function isTelPhone($telPhone) {
		if (0 >= preg_match('/^[0-9][-\d]*\d*$/', $telPhone)) {
			return new PwError('USER:error.telphone');
		}
		return true;
	}
	
	/**
	 * ֤֧ʺ
	 *
	 * @param string $alipay ֧ʺ
	 * @param string $username ųû
	 * @return true|PwError
	 */
	public static function isAlipayValid($alipay, $username = '') {
		/* @var $userDs PwUser */
//		$userDs = Wekit::load('user.PwUser');
		//TODOû֤֧ʺΨһ֤
		return true;
	}
	
	
	/** 
	 * û
	 *
	 * @param string $email û
	 * @param string $username  û
	 * @return boolean|PwError
	 */
	public static function isEmailValid($email, $username = '', $uid = 0) {
		$result = self::_getWindid()->checkUserInput($email, 3, $username, $uid);
		if ($result < 1) {
			return new PwError('USER:user.error.' . $result);
		}
		return true;
	}

	/** 
	 * ֤û
	 *
	 * @param string $username  ֤û
	 * @param int $uid			ųûID
	 * @return PwError|boolean
	 */
	public static function isUsernameValid($username, $uid = 0) {
		if (!$username) return new PwError('USER:user.error.-1');
		$result = self::_getWindid()->checkUserInput($username, 1, '', $uid);
		if ($result < 1) {
			if ($result == -2) {
				$config = WindidApi::C('reg');
				return new PwError('WINDID:code.-2', array('{min}' => $config['security.username.min'], '{max}' => $config['security.username.max']));
			}
			return new PwError('WINDID:code.' . $result);
		}
		if (false !== ($r = self::isUsernameHasIllegalChar($username))) {
			return $r;
		}
		return true;
	}
	
	/** 
	 * ûusernameǷ 
	 *
	 * @param string $username  û
	 * @param int $exceptUid ųûID
	 * @return boolean
	 */
	public static function checkUsernameExist($username, $exceptUid = 0) {
		$result = self::_getWindid()->checkUserInput($username, 1, '', $exceptUid);
		if ($result < 1) return new PwError('WINDID:code.'. $result);
		/* @var $userDs PwUser */
	/*	$userDs = Wekit::load('user.PwUser');
		$info = $userDs->getUserByName($username, PwUser::FETCH_MAIN);
		if (!$info) return false;
		$exceptUid = intval($exceptUid);
		if ($exceptUid && $info['uid'] == $exceptUid) return false;*/
		return true;
	}

	/** 
	 * ûǷϷ
	 *
	 * @param string $password û
	 * @param string $username û
	 * @return PwError|boolean
	 */
	public static function isPwdValid($password, $username) {
		$result = self::_getWindid()->checkUserInput($password, 2, $username);
		if ($result < 1) {
			$config = WindidApi::C('reg');
			$var = array('{min}' => $config['security.password.min'], '{max}' => $config['security.password.max']);
			return new PwError('WINDID:code.'. $result, $var);
		}
		$result = self::checkPwdComplex($password, $username);
		if ($result instanceof PwError) return $result;
		return true;
	}
	
	/**
	 * ֤ĸӶǷϺ̨Ҫ
	 * 븴Ӷ
	 * ûǷͬ
	 * òͬͬ򷵻PwError
	 * ෵true
	 * 
	 * @param string $password û
	 * @param string $username û
	 * @return boolean|PwError
	 */
	public static function checkPwdComplex($password, $username) {
		$register = WindidApi::C('reg');
		if (!($pwdConfig = $register['security.password'])) return true;
		$config = array_sum($pwdConfig);
		if (in_array(9, $pwdConfig)) {
			$config = $config - 9;
			if ($username == $password) return new PwError('USER:pwd.error.equalUsername');
		}
		if ($config == 0) return true;
		if (self::_complexCaculate($password, $config)) return new PwError('USER:pwd.error.complex', array('{type}' => self::buildPwdComplexMsg($pwdConfig)));
		return true;
	}
	
	/**
	 * ʾû֧Ϣ
	 * 
	 * @return array(string, args)
	 */
	public static function buildPwdShowMsg() {
		$config = WindidApi::C('reg');
		$_min = $config['security.password.min']; 
		$_max = $config['security.password.max'];
		$_complex = $config['security.password'];
		$_length = $_min || $_max;
		$type = self::buildPwdComplexMsg($_complex);
		$var = array();
		$_key = 'USER:pwd.require';
		if ($_length && $_complex) {
			$_key = 'USER:pwd.format.require';
			$var = array('{type}' => $type, '{min}' => $_min, '{max}' => $_max);
		} elseif (!$_complex && $_length) {
			$_key = 'USER:pwd.format.length.require';
			$var = array('{min}' => $_min, '{max}' => $_max);
		} elseif (!$_length && $_complex) {
			$_key = 'USER:pwd.error.complex';
			$var = array('{type}' => $type);
		}
		return array($_key, $var);
	}
	
	/**
	 * ʾû֤֧Ϣ
	 * 
	 * @return array(string, args)
	 */
	public static function buildNameShowMsg() {
		$config = WindidApi::C('reg');
		$_name = 'USER:user.error.username';
		$_min = $config['security.username.min'];
		$_max = $config['security.username.max'];
		return array('USER:user.error.username', array('{min}' => $_min, '{max}' => $_max));
	}
	
	/**
	 * û븴ӶȵУ
	 *
	 * @param array $config ӹ
	 * @return string
	 */
	private static function buildPwdComplexMsg($config) {
		if (!$config) return '';
		$complex = array(1 => 'Сдĸ', 2 => 'дĸ', 4 => '', 8 => 'ǿհ׷', 9 => 'ܺûͬ');
		return implode('', array_intersect_key($complex, array_flip($config)));
	}
	
	/**
	 * Ӷж
	 * 
	 * @param string $password 
	 * @param int $config 
	 * @return boolean
	 */
	private static function _complexCaculate($password, $config) {
		$pwdLen = strlen($password);
		$complex = 0;
		for ($i = 0; $i < $pwdLen; $i ++) {
			$ascii = ord($password[$i]);
			//뺬Сдĸ 97-122 
			if (1 == ($config & 1) && $ascii >= 97 && $ascii <= 122) {
				if (0 == $complex || 1 != ($complex & 1)) $complex += 1;
				continue;
			}
			//뺬ддĸ 65-90
			if (2 == ($config & 2) && $ascii >= 65 && $ascii <= 90) {
				if (0 == $complex || 2 != ($complex & 2)) $complex += 2;
				continue;
			}
			//뺬 48-57
			if (4 == ($config & 4) && $ascii >= 48 && $ascii <= 57) {
				if (0 == $complex || 4 != ($complex & 4)) $complex += 4;
				continue;
			}
			//뺬з 33-47/58-64/91-96/123-126
			if (8 == ($config & 8) && 
				(($ascii >= 33 && $ascii <=47) || ($ascii >= 58 && $ascii <= 64) || ($ascii >= 91 && $ascii <= 96) || ($ascii >= 123 && $ascii <= 126))) {
					if (0 == $complex || 8 != ($complex & 8)) $complex += 8;
					continue;
			}
			//ѾﵽøӶ
			if ($config == $complex) break;
		}
		return $config != $complex;
	}
	
	private static function _getWindid() {
		return WindidApi::api('user');
	}
}
?>