<?php

/**
 * û
 *
 * @author xiaoxia.xu <xiaoxia.xuxx@aliyun-inc.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id: PwUserSo.php 20572 2012-10-31 06:50:17Z jinlong.panjl $
 * @package service.user.vo
 */
class PwUserSo {
	private $_data = array();
	protected $_orderby = array();
	
	/**
	 * û
	 *
	 * @param string $name
	 * @return PwUserSo
	 */
	public function setUsername($name) {
		$this->_data['username'] = $name;
		return $this;
	}
	
	/**
	 * òѯûID
	 *
	 * @param int|array $uid
	 * @return PwUserSo
	 */
	public function setUid($uid) {
		$this->_data['uid'] = $uid;
		return $this;
	}
	
	/**
	 * òѯemail
	 *
	 * @param string $email
	 * @return PwUserSo
	 */
	public function setEmail($email) {
		$this->_data['email'] = $email;
		return $this;
	}
	
	/**
	 * òѯû
	 *
	 * @param int|array $gid
	 * @return PwUserSo
	 */
	public function setGid($gid) {
		$this->_data['gid'] = $gid;
		return $this;
	}
	
	/**
	 * òѯû
	 *
	 * @param int|array $memberid
	 * @return PwUserSo
	 */
	public function setMemberid($memberid) {
		$this->_data['memberid'] = $memberid;
		return $this;
	}
	
	/**
	 * ûԱ  | òѯֶû  
	 *
	 * @param int $gender
	 * @return PwUserSo
	 */
	public function setGender($gender) {
		$this->_data['gender'] = $gender == 1 ? 1 : 0;
		return $this;
	}
	
	/**
	 * þסصַ
	 *
	 * @param int $areaid
	 * @return PwUserSo
	 */
	public function setLocation($areaid) {
		$this->_data['location'] = $areaid;
		return $this;
	}
	
	/**
	 * üַͥ
	 *
	 * @param int $areaid
	 * @return PwUserSo
	 */
	public function setHometown($areaid) {
		$this->_data['hometown'] = $areaid;
		return $this;
	}
	
	/**
	 * òѯregdateעʱ
	 *
	 * @param int $regdate
	 * @return PwUserSo
	 */
	public function setRegdate($regdate) {
		$this->_data['regdate'] = $regdate;
		return $this;
	}
	
	/**
	 * òѯpostnum |   ʹ
	 *
	 * @param int $asc
	 * @return PwUserSo
	 */
	public function orderbyPostnum($asc) {
		$this->_orderby['postnum'] = (bool)$asc;
		return $this;
	}
	
	/**
	 * òѯlastvisitϴηʱ |   ʹ
	 *
	 * @param int $asc
	 * @return PwUserSo
	 */
	public function orderbyLastvisit($asc) {
		$this->_orderby['lastvisit'] = (bool)$asc;
		return $this;
	}
	
	/**
	 * òѯlastpostϴεݽӵʱ |   ʹ
	 *
	 * @param int $asc
	 * @return PwUserSo
	 */
	public function orderbyLastpost($asc) {
		$this->_orderby['lastpost'] = (bool)$asc;
		return $this;
	}
	
	/**
	 * òѯregdateעʱ |   ʹ | עʱ̨ԸģԲʹUID
	 *
	 * @param int $asc
	 * @return PwUserSo
	 */
	public function orderbyRegdate($asc) {
		$this->_orderby['regdate'] = (bool)$asc;
		return $this;
	}
	
	/**
	 * òѯ
	 *
	 * @return array
	 */
	public function getData() {
		return $this->_data;
	}
	
	/**
	 * 
	 *
	 * @return array
	 */
	public function getOrderby() {
		return $this->_orderby;
	}
}