<?php
defined('WEKIT_VERSION') || exit('Forbidden');

/**
 * û
 * 
 * @author peihong.zhangph <peihong.zhangph@aliyun-inc.com> Oct 31, 2011
 * @link http://www.phpwind.com
 * @copyright 2011 phpwind.com
 * @license
 * @version $Id: PwUserGroups.php 18966 2012-10-09 08:15:59Z xiaoxia.xuxx $
 */

class PwUserGroups {
	
	protected $_allowGroupTypes = array('member', 'system', 'special', 'default');
	
	/**
	 * Աͻȡб
	 *
	 * @return array
	 */
	public function getGroupTypes() {
		return $this->_allowGroupTypes;
	}
	
	/**
	 * ȡû
	 */
	public function getTypeNames() {
		return array_combine($this->_allowGroupTypes, array('Ա','','','Ĭ'));
	}
	
	/**
	 * ȡһԱϸϢ
	 *
	 * @param int $gid
	 * @return array
	 */
	public function getGroupByGid($gid) {
		if (empty($gid)) return array();
		return $this->_getDao()->getGroupByGid($gid);
	}
	
	/**
	 * һgidȡû
	 *
	 * @param array $gids
	 * @return array
	 */
	public function fetchGroup($gids) {
		if (empty($gids) || !is_array($gids)) return array();
		return $this->_getDao()->fetchGroup($gids);
	}
	
	/**
	 * Աͻȡб
	 *
	 * @param string $groupType
	 * @return array
	 */
	public function getGroupsByType($groupType) {
		if (!$this->checkGroupType($groupType)) return array();
		return $this->_getDao()->getGroupsByType($groupType);
	}
	
	/**
	 * ȡ͵û
	 *
	 * @param array $groupTypes
	 * @return array
	 */
	public function getGroupsByTypes($groupTypes) {
		if (count($groupTypes) == 1) {
			$groupType = array_pop($groupTypes);
			return $this->getGroupsByType($groupType);
		}
		$groups = array();
		$allGroups = $this->getAllGroups();
		foreach ($allGroups as $k=>$v){
			if (!in_array($v['type'], $groupTypes)) continue;
			$groups[$k] = $v;
		}
		return $groups;
	}
	
	public function getGroupsByTypeInUpgradeOrder($groupType){
		if (!$this->checkGroupType($groupType)) return array();
		return $this->_getDao()->getGroupsByTypeInUpgradeOrder($groupType);
	}
	
	/**
	 * ȡϵͳû
	 */
	public function getSystemAndSpecialGroups() {
		return $this->getGroupsByTypes(array('system','special'));
	}
	
	/**
	 * ȡвû
	 */
	public function getNonUpgradeGroups() {
		return $this->getGroupsByTypes(array('system','special','default'));
	}
	
	/**
	 * Ա
	 *
	 * @param string $groupType
	 * @return bool
	 */
	public function checkGroupType($groupType) {
		return in_array($groupType, $this->_allowGroupTypes);
	}
	
	/**
	 * ȡûϢ
	 *
	 * @return array
	 */
	public function getAllGroups() {
		return $this->_getDao()->getAllGroups();
	}
	
	/**
	 * ȡзֺ
	 *
	 * @return array
	 */
	public function getClassifiedGroups() {
		if (!$groups = $this->getAllGroups()) return array();
		$data = array();
		foreach ($groups as $key => $v) {
			$data[$v['type']][$key] = $v;
		}
		return $data;
	}
	
	/**
	 * û
	 *
	 * @param PwUserGroupDm $dm
	 * @return bool
	 */
	public function addGroup($dm) {
		if (($result = $dm->beforeAdd()) !== true) {
			return $result;
		}
		$gid = $this->_getDao()->addGroup($dm->getData());
		PwSimpleHook::getInstance('PwUserGroups_update')->runDo(array($gid));
		return $gid;
	}
	
	/**
	 * ûϢ
	 *
	 * @param PwUserGroupDm $dm 
	 * @return bool
	 */
	public function updateGroup($dm) {
		if (($result = $dm->beforeUpdate()) !== true) {
			return $result;
		}
		$gid = $dm->getGroupId();
		$result = $this->_getDao()->updateGroup($gid, $dm->getData());
		PwSimpleHook::getInstance('PwUserGroups_update')->runDo(array($gid));
		return $result;
	}
	
	/**
	 * ûϢ
	 *
	 * @param array (PwUserGroupDm) $groups
	 * @return bool
	 */
	public function updateGroups($groups) {
		$gids = array();
		$dao = $this->_getDao();
		foreach ($groups as $v) {
			if ($v instanceof PwUserGroupDm && $v->beforeUpdate()) {
				$gid = $v->getGroupId();
				$dao->updateGroup($gid, $v->getData());
				$gids[] = $gid;
			}
		}
		PwSimpleHook::getInstance('PwUserGroups_update')->runDo($gids);
		return true;
	}

	/**
	 * ɾû
	 *
	 * @param int $gid
	 */
	public function deleteGroup($gid) {
		return $this->_getDao()->deleteGroup($gid);
	}
	
	/**
	 * Enter description here ...
	 * @return PwUserGroupsDao
	 */
	protected function _getDao() {
		return Wekit::loadDao('usergroup.dao.PwUserGroupsDao');
	}
}