<?php
defined('WEKIT_VERSION') || exit('Forbidden');

/**
 * ûȨ޻
 * 
 * @author peihong.zhangph <peihong.zhangph@aliyun-inc.com> Nov 1, 2011
 * @link http://www.phpwind.com
 * @copyright 2011 phpwind.com
 * @license
 * @version $Id: PwUserPermission.php 24736 2013-02-19 09:24:40Z jieyin $
 */

class PwUserPermission {
	
	/**
	 * ûȨ
	 *
	 * @param PwUserPermissionDm $dm
	 * @return bool
	 */
	public function setPermission(PwUserPermissionDm $dm) {
		if (!$data = $dm->getData()) return false;
		$result = $this->_getGroupPermissionDao()->setGroupPermission($data);
		PwSimpleHook::getInstance('PwUserGroupPermission_update')->runDo($dm);
		return $result;
	}
	
	/**
	 * ȡĳԱȨ
	 *
	 * @param string $gid
	 * @param array $keys
	 * @return array
	 */
	public function getPermissions($gid, $keys = array()) {
		$gid = intval($gid);
		if (!is_array($keys) || !$keys || $gid < 1) return array();
		return $this->_getGroupPermissionDao()->getPermissions($gid, $keys);
	}
	
	/**
	 * ȡĳrkeyȨ
	 *
	 * @param string $rkey
	 * @return array
	 */
	public function getPermissionByRkey($rkey) {
		return $this->_getGroupPermissionDao()->getPermissionByRkey($rkey);
	}
	
	/**
	 * ȡָûĳrkeyȨ
	 *
	 * @param string $rkey
	 * @param array $gids
	 * @return array
	 */
	public function getPermissionByRkeyAndGids($rkey, $gids) {
		if (empty($gids) || !is_array($gids)) return array();
		return $this->_getGroupPermissionDao()->getPermissionByRkeyAndGids($rkey, $gids);
	}
	
	/**
	 * ȡĳrkeyȨ
	 *
	 * @param array $rkeys
	 * @return array
	 */
	public function fetchPermissionByRkey($rkeys = array()) {
		if (!is_array($rkeys) || !$rkeys) return array();
		return $this->_getGroupPermissionDao()->fetchPermissionByRkey($rkeys);
	}

	/**
	 * gidsȡûȨ
	 * 
	 * @param array $gids
	 * @return array
	 */
	public function fetchPermissionByGid($gids) {
		if (!is_array($gids) || !$gids) return array();
		return $this->_getGroupPermissionDao()->fetchPermissionByGid($gids);
	}
	
	/**
	 * ûɾȨ޵
	 *
	 * @param unknown_type $gid
	 * @return bool
	 */
	public function deletePermissionsByGid($gid) {
		return $this->_getGroupPermissionDao()->deletePermissionsByGid($gid);
	}
	
	/**
	 * ɾûȨ޵
	 * 
	 * @param int $gid
	 * @param array $keys
	 * @return bool
	 */
	public function batchDeletePermissionByGidAndKeys($gid, $keys) {
		$gid = intval($gid);
		if (!is_array($keys) || !$keys || $gid < 1) return false;
		return $this->_getGroupPermissionDao()->batchDeletePermissionByGidAndKeys($gid,$keys);
	}
	
	/**
	 * Enter description here ...
	 * 
	 * @return  PwUserPermissionGroupsDao
	 */
	protected function _getGroupPermissionDao() {
		return Wekit::loadDao('usergroup.dao.PwUserPermissionGroupsDao');
	}
}