<?php
/**
 * Enter description here ...
 * 
 * @author peihong.zhangph <peihong.zhangph@aliyun-inc.com> Oct 31, 2011
 * @link http://www.phpwind.com
 * @copyright 2011 phpwind.com
 * @license
 * @version $Id: PwUserGroupsDao.php 19883 2012-10-19 06:26:36Z jieyin $
 */

class PwUserGroupsDao extends PwBaseDao {
	
	protected $_table = 'user_groups';
	protected $_pk = 'gid';
	protected $_dataStruct = array('type', 'name', 'category', 'image', 'points');
	
	/**
	 * ȡû
	 */
	public function getAllGroups() {
		$sql = $this->_bindTable("SELECT * FROM %s");
		$smt = $this->getConnection()->query($sql);
		return $smt->fetchAll('gid');
	}
	
	/**
	 * ȡһԱϸϢ
	 *
	 * @param int $gid
	 * @return Array
	 */
	public function getGroupByGid($gid) {
		return $this->_get($gid);
	}
	
	/**
	 * һgidȡû
	 * 
	 * @param array $gids
	 * @return array
	 */
	public function fetchGroup($gids) {
		return $this->_fetch($gids, 'gid');
	}
	
	/**
	 * û
	 *
	 * @param array $fields
	 */
	public function addGroup($fields) {
		return $this->_add($fields);
	}
	
	/**
	 * û
	 *
	 * @param int $gid
	 * @param array $fields
	 */
	public function updateGroup($gid, $fields) {
		return $this->_update($gid, $fields);
	}
	
	/**
	 * ɾû
	 *
	 * @param int $gid
	 */
	public function deleteGroup($gid) {
		return $this->_delete($gid);
	}
	
	/**
	 * Աͻȡб
	 *
	 * @param string $groupType
	 */
	public function getGroupsByType($groupType) {
		$sql = $this->_bindTable('SELECT * FROM %s WHERE type=?');
		$smt = $this->getConnection()->createStatement($sql);
		return $smt->queryAll(array($groupType), 'gid');
	}
	
	/**
	 * Աͻȡб
	 *
	 * @param string $groupType
	 */
	public function getGroupsByTypeInUpgradeOrder($groupType) {
		$sql = $this->_bindTable('SELECT * FROM %s WHERE type=? ORDER BY points');
		$smt = $this->getConnection()->createStatement($sql);
		return $smt->queryAll(array($groupType), 'gid');
	}
}