<?php
/**
 * ˱ǩϵ
 *
 * @author xiaoxia.xu <xiaoxia.xuxx@aliyun-inc.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id: PwUserTagRelation.php 10043 2012-05-16 04:51:07Z jinlong.panjl $
 * @package src.service.usertag
 */
class PwUserTagRelation {
	
	/**
	 * ûIDͱǩIDû
	 *
	 * @param int $uid
	 * @param int $tag_id
	 */
	public function getRelationByUidAndTagid($uid, $tag_id) {
		if (($uid = intval($uid)) < 1) return array();
		if (($tag_id = intval($tag_id)) < 1) return array();
		return $this->_getDao()->getRelationByUidAndTagid($uid, $tag_id);
	}
	
	/**
	 * ûIDȡûıǩ
	 *
	 * @param int $uid
	 * @return PwError|array
	 */
	public function getRelationByUid($uid) {
		if (($uid = intval($uid)) < 1) return array();
		return $this->_getDao()->getRelationByUid($uid);
	}
	
	/**
	 * ûIDͳûӵеıǩ
	 *
	 * @param int $uid
	 * @return int
	 */
	public function countByUid($uid) {
		if (($uid = intval($uid)) < 1) return 0;
		return $this->_getDao()->countByUid($uid);
	}
	
	/**
	 * ݱǩIDøñǩû¼
	 *
	 * @param int $uid
	 * @return int
	 */
	public function countRelationByTagid($tag_id) {
		if (($tag_id = intval($tag_id)) < 1) return 0;
		return $this->_getDao()->countRelationByTagid($tag_id);
	}
	
	/**
	 * ݱǩIDøñǩĹϵ
	 *
	 * @param int $tag_id
	 * @return array
	 */
	public function getRelationByTagid($tag_id, $limit = 20, $start = 0) {
		if (($tag_id = intval($tag_id)) < 1) return array();
		return $this->_getDao()->getRelationByTagid($tag_id, $limit, $start);
	}
	
	/**
	 * ӹ
	 *
	 * @param int $uid
	 * @param int $tag_id
	 * @param int $time
	 * @return boolean
	 */
	public function addRelation($uid, $tag_id, $time) {
		if ($uid < 1 || $tag_id < 1) return new PwError('USER:tag.illega.format');
		return $this->_getDao()->addRelation($uid, $tag_id, $time);
	}
	
	/**
	 * ûIDͱǩIDɾû͸ñǩĹϵ
	 *
	 * @param int $uid
	 * @param int $tag_id
	 * @return PwError|int
	 */
	public function deleteRelation($uid, $tag_id) {
		if (($uid = intval($uid)) < 1) return new PwError('USER:tag.uid.require');
		if (($tag_id = intval($tag_id)) < 1) return array('USER:tag.id.require');
		return $this->_getDao()->deleteRelation($uid, $tag_id);
	}
	
	/**
	 * 
	 *
	 * @param int $uid
	 * @param array $tag_ids
	 */
	public function batchDeleteRelation($uid, $tag_ids) {
		if (empty($tag_ids)) return false;
		PwSimpleHook::getInstance('PwUserTagRelation_batchDeleteRelation')->runDo($tag_ids, $this);
		return $this->_getDao()->batchDeleteRelation($tag_ids);
	}
	
	/**
	 * ûIDɾûǩϵ
	 *
	 * @param int $uid
	 * @return boolean
	 */
	public function deleteRelationByUid($uid) {
		if (($uid = intval($uid)) < 1) return new PwError('USER:tag.uid.require');
		PwSimpleHook::getInstance('PwUserTagRelation_deleteRelationByUid')->runDo($uid, $this);
		return $this->_getDao()->deleteRelationByUid($uid);
	}
	
	/**
	 * ɾûбûĹϵ
	 *
	 * @param array $uids
	 * @return boolean|boolean
	 */
	public function batchDeleteRelationByUids($uids) {
		if (empty($uids)) return false;
		PwSimpleHook::getInstance('PwUserTagRelation_batchDeleteRelationByUids')->runDo($uids, $this);
		return $this->_getDao()->batchDeleteRelationByUids($uids);
	}
	
	/**
	 * ȡ˱ǩϵDao
	 *
	 * @return PwUserTagRelationDao
	 */
	private function _getDao() {
		return Wekit::loadDao('usertag.dao.PwUserTagRelationDao');
	}
}