<?php

/**
 * ǩûĹϵ
 * 
 * @author xiaoxia.xu <xiaoxia.xuxx@aliyun-inc.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id: PwUserTagRelationDao.php 10043 2012-05-16 04:51:07Z jinlong.panjl $
 * @package src.service.usertag.dao
 */
class PwUserTagRelationDao extends PwBaseDao {
	protected $_table = 'user_tag_relation';
	protected $_dataStruct = array('uid', 'tag_id', 'created_time');
	
	/**
	 * ûIDûıǩϵ
	 *
	 * @param int $uid
	 * @param int $tag_id
	 * @return array
	 */
	public function getRelationByUidAndTagid($uid, $tag_id) {
		$sql = $this->_bindTable('SELECT * FROM %s WHERE `uid` = ? AND `tag_id` = ?');
		$smt = $this->getConnection()->createStatement($sql);
		return $smt->getOne(array($uid, $tag_id));
	}
	
	/**
	 * ûIDûıǩϵ
	 *
	 * @param int $uid
	 * @return array
	 */
	public function getRelationByUid($uid) {
		$sql = $this->_bindTable('SELECT * FROM %s WHERE `uid` = ?');
		$smt = $this->getConnection()->createStatement($sql);
		return $smt->queryAll(array($uid), 'tag_id');
	}

	/**
	 * ûIDͳƸûѾӵеıǩ
	 *
	 * @param int $uid
	 * @return array
	 */
	public function countByUid($uid) {
		$sql = $this->_bindTable('SELECT COUNT(*) FROM %s WHERE `uid` = ?');
		$smt = $this->getConnection()->createStatement($sql);
		return $smt->getValue(array($uid));
	}
	
	/**
	 * ݱǩIDøñǩû¼
	 *
	 * @param int $tag_id
	 * @return array
	 */
	public function countRelationByTagid($tag_id) {
		$sql = $this->_bindTable('SELECT COUNT(*) FROM %s WHERE `tag_id` = ?');
		$smt = $this->getConnection()->createStatement($sql);
		return $smt->getValue(array($tag_id));
	}
	
	/**
	 * ݱǩIDøñǩû¼
	 *
	 * @param int $tag_id
	 * @return array
	 */
	public function getRelationByTagid($tag_id, $limit, $start) {
		$sql = $this->_bindSql('SELECT * FROM %s WHERE `tag_id` = ? %s', $this->getTable(), $this->sqlLimit($limit, $start));
		$smt = $this->getConnection()->createStatement($sql);
		return $smt->queryAll(array($tag_id), 'uid');
	}
	
	/**
	 * ɾϵ
	 *
	 * @param int $uid
	 * @param int $tag_id
	 * @return boolean
	 */
	public function deleteRelation($uid, $tag_id) {
		$sql = $this->_bindTable('DELETE FROM %s WHERE `uid` = ? AND `tag_id` = ?');
		$result = $this->getConnection()->createStatement($sql)->execute(array($uid, $tag_id), true);
		if ($result) {
			PwSimpleHook::getInstance('PwUserTagRelationDao_deleteRelation')->runDo($tag_id, array(), array('used_count' => -1));
		}
		return $result;
	}
	
	/**
	 * ɾϵ
	 *
	 * @param int $uid
	 * @param array $tag_ids
	 * @return boolean
	 */
	public function batchDeleteRelation($uid, $tag_ids) {
		$sql = $this->_bindSql('DELETE FROM %s WHERE `uid` = ? AND `tag_id` IN %s', $this->getTable(), $this->sqlImplode($tag_ids));
		return $this->getConnection()->createStatement($sql)->execute(array($uid), true);
	}
	
	/**
	 * ݱǩIDбɾǩϵ
	 *
	 * @param array $tag_ids
	 */
	public function batchDeleteRelationByTagids($tag_ids) {
		$sql = $this->_bindSql('DELETE FROM %s WHERE `tag_id` IN %s', $this->getTable(), $this->sqlImplode($tag_ids));
		return $this->getConnection()->execute($sql);
	}
	
	/**
	 * ûIDɾûĹϵ
	 *
	 * @param int $uid
	 * @return boolean
	 */
	public function deleteRelationByUid($uid) {
		$sql = $this->_bindTable('DELETE FROM %s WHERE `uid` = ?');
		$smt = $this->getConnection()->createStatement($sql);
		return $smt->execute(array($uid));
	}
	
	/**
	 * ûIDбɾ
	 *
	 * @param int $uid
	 * @return boolean
	 */
	public function batchDeleteRelationByUids($uids) {
		$sql = $this->_bindSql('DELETE FROM %s WHERE `uid` IN %s', $this->getTable(), $this->sqlImplode($uids));
		return $this->getConnection()->execute($sql);
	}
	
	/**
	 * ӹϵ
	 *
	 * @param int $uid
	 * @param int $tag_id
	 * @param int $created_time
	 * @return boolean
	 */
	public function addRelation($uid, $tag_id, $created_time) {
		$sql = $this->_bindTable('REPLACE INTO %s (`uid`, `tag_id`, `created_time`) VALUES (?, ?, ?)');
		$smt = $this->getConnection()->createStatement($sql);
		return $smt->execute(array($uid, $tag_id, $created_time));
	}
}