<?php
Wind::import('SRV:usertag.dm.PwUserTagDm');
/**
 * ɾϵ¸ñǩ
 *
 * @author xiaoxia.xu <xiaoxia.xuxx@aliyun-inc.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id: PwDeleteRelationDoUpdateTag.php 8027 2012-04-14 06:54:11Z xiaoxia.xuxx $
 * @package src.service.usertag.srv.do
 */
class PwDeleteRelationDoUpdateTag {
	
	/**
	 * ûIDûйصıǩʹôһ
	 *
	 * @param int $uid
	 * @param PwUserTagRelation $bp
	 * @return boolean
	 */
	public function deleteRelationByUid($uid, PwUserTagRelation $bp) {
		$tag_ids = array_keys($bp->getRelationByUid($uid));
		if ($tag_ids) {
			foreach ($tag_ids as $_item) {
				$tagDm = new PwUserTagDm();
				$tagDm->setTagid($_item)->increaseCount(-1);
				$this->_getTagDs()->updateTag($tagDm);
			}
		}
		return true;
	}
	
	/**
	 * ݱǩIDЩǩʹô
	 *
	 * @param array $tag_ids
	 * @param PwUserTagRelation $bp
	 * @return boolean
	 */
	public function batchDeleteRelation($tag_ids, PwUserTagRelation $bp) {
		foreach ($tag_ids as $_tid) {
			$tagDm = new PwUserTagDm();
			$tagDm->setTagid($_tid)->increaseCount(-1);
			$this->_getTagDs()->updateTag($tagDm);
		}
		return true;
	}
	
	/**
	 * ûIDбɾûͱǩ£¸ñǩ
	 *
	 * @param array $uids
	 * @param PwUserTagRelation $bp
	 * @return boolean
	 */
	public function batchDeleteRelationByUids($uids, PwUserTagRelation $bp) {
		foreach ($uids as $_uid) {
			$this->deleteRelationByUid($_uid, $bp);
		}
		return true;
	}
	
	/**
	 * ǩDs
	 *
	 * @return PwUserTag
	 */
	private function _getTagDs() {
		return Wekit::load('usertag.PwUserTag');
	}
}