<?php
defined('WEKIT_VERSION') || exit('Forbidden');

/**
 * ΢
 *
 * @author Jianmin Chen <sky_hold@163.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.phpwind.com
 * @version $Id: PwWeibo.php 8959 2012-04-28 09:06:05Z jieyin $
 * @package fresh
 */

class PwWeibo {
	
	const TYPE_MEDAL = 1;
	const TYPE_LIKE = 2;
	
	/**
	 * ȡһ΢
	 *
	 * @param int $weiboId
	 * @return array
	 */
	public function getWeibo($weiboId) {
		if (empty($weiboId)) return array();
		return $this->_getDao()->getWeibo($weiboId);
	}

	/**
	 * ȡ΢б
	 *
	 * @param array $weiboIds
	 * @return array
	 */
	public function getWeibos($weiboIds) {
		if (empty($weiboIds) || !is_array($weiboIds)) return array();
		return $this->_getDao()->fetchWeibo($weiboIds);
	}

	/**
	 * һ΢
	 * עӿֻṩݲزķ΢ӿ PwSendWeibo::send()
	 *
	 * @param object $dm PwWeiboDm
	 * @return bool|PwError
	 */
	public function addWeibo(PwWeiboDm $dm) {
		if (($result = $dm->beforeAdd()) !== true) {
			return $result;
		}
		return $this->_getDao()->addWeibo($dm->getData());
	}
	
	/**
	 * һ΢
	 *
	 * @param object $dm PwWeiboDm
	 * @return bool|PwError
	 */
	public function updateWeibo(PwWeiboDm $dm) {
		if (($result = $dm->beforeUpdate()) !== true) {
			return $result;
		}
		return $this->_getDao()->updateWeibo($dm->weibo_id, $dm->getData(), $dm->getIncreaseData());
	}
	
	/**
	 * ɾһ΢
	 *
	 * @param int $weiboId
	 * @return bool
	 */
	public function deleteWeibo($weiboId) {
		if (!$weiboId) return false;
		return $this->_getDao()->deleteWeibo($weiboId);
	}

	/**
	 * ɾ΢
	 * עӿֻṩݲز΢ɾӿ PwWeiboService::batchDeleteWeibo()
	 *
	 * @param array $weiboIds
	 * @return bool
	 */
	public function batchDeleteWeibo($weiboIds) {
		if (empty($weiboIds) || !is_array($weiboIds)) return false;
		return $this->_getDao()->batchDeleteWeibo($weiboIds);
	}
	
	/**
	 * ȡб
	 *
	 * @param int $weiboId ΢id
	 * @param int $limit ȡ
	 * @param int $offset Ŀƫ
	 * @param bool $asc 
	 * @return array
	 */
	public function getComment($weiboId, $limit, $offset = 0, $asc = true) {
		return $this->_getCommentDao()->getComment($weiboId, $limit, $offset, $asc);
	}

	/**
	 * һ΢
	 * עӿֻṩݲزķ΢۽ӿ PwWeiboService::addComment()
	 *
	 * @param object $dm PwWeiboCommnetDm
	 * @return bool|PwError
	 */
	public function addComment(PwWeiboCommnetDm $dm) {
		if (($result = $dm->beforeAdd()) !== true) {
			return $result;
		}
		return $this->_getCommentDao()->addComment($dm->getData());
	}
	
	/**
	 * ɾ΢
	 *
	 * @param array $weiboIds
	 * @return bool
	 */
	public function batchDeleteCommentByWeiboId($weiboIds) {
		if (empty($weiboIds) || !is_array($weiboIds)) return false;
		return $this->_getCommentDao()->batchDeleteCommentByWeiboId($weiboIds);
	}

	protected function _getDao() {
		return Wekit::loadDao('weibo.dao.PwWeiboDao');
	}

	protected function _getCommentDao() {
		return Wekit::loadDao('weibo.dao.PwWeiboCommentDao');
	}
}