<?php
defined('WEKIT_VERSION') || exit('Forbidden');

/**
 * DS
 *
 * @author Mingqu Luo <luo.mingqu@gmail.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id: PwWord.php 17009 2012-08-30 08:19:36Z hejin $
 * @package wind
 */

class PwWord {
	
	const NAME_BANED = 1;		//
	const WORD_VERIFIED = 2;	//
	const WORD_REPLACE = 3; 	//滻
	
	/**
	 * б
	 * 
	 * @return array
	 */
	public function getTypeMap() {
		$map = array(
				self::NAME_BANED =>'',
				self::WORD_VERIFIED =>'',
				self::WORD_REPLACE =>'滻' 
		);
		return $map;
	}
	
	/**
	 * ȡдϢ
	 *
	 * @param int $wordId
	 * @return array
	 */
	public function get($wordId) {
		$wordId = intval($wordId);
		if ($wordId < 1) return array();
		return $this->_getDao()->get($wordId);
	}
	
	/**
	 * ĳдʼ¼
	 *
	 * @param string $word
	 * @return array
	 */
	public function getByWord($word) {
		if (!$word) return array();
		return $this->_getDao()->getByWord($word);
	}
	
	/**
	 * ĳд
	 *
	 * @param int $type
	 * @return array
	 */
	public function getWordByType($type) {
		$type = intval($type);
		if ($type < 1) return array();
		return $this->_getDao()->getByType($type);
	}
	
	/**
	 * öдϢ
	 *
	 * @param array $wordIds
	 * @return array
	 */
	public function fetch($wordIds) {
		if (empty($wordIds) || !is_array($wordIds)) return array();
		return $this->_getDao()->fetch($wordIds);
	}
	
	/**
	 * дʻб
	 *
	 * @param array $word
	 * @return array
	 */
	public function fetchByWord($word = array()) {
		if (empty($word) || !is_array($word)) return array();
		return $this->_getDao()->fetchByWord($word);
	}
	
	/**
	 * дб
	 *
	 * @param int $limit
	 * @param int $offset
	 * @return array
	 */
	public function getWordList($limit = 20, $offset = 0) {
		return $this->_getDao()->getWordList($limit, $offset);
	}
	
	/**
	 * ͳ
	 *
	 * @return int
	 */
	public function count() {
		return $this->_getDao()->count();
	}
	
	/**
	 * ݲͬԴͳд
	 *
	 * @param int $from Դ 0 local 1platform
	 * @return int
	 */
	public function countByFrom($from = 0) {
		return $this->_getDao()->countByFrom($from);
	}
	
	/**
	 * 
	 *
	 * @param PwWordDm $dm
	 */
	public function add(PwWordDm $dm) {
		if (($result = $dm->beforeAdd()) !== true) {
			return $result;
		}

		$result = $this->_getDao()->add($dm->getData());
		return $result;
	}

	/**
	 * ɾ
	 *
	 * @param int $wordId
	 * @return bool
	 */
	public function delete($wordId) {
		$wordId = intval($wordId);
		if ($wordId < 1) return false;
		$result = $this->_getDao()->delete($wordId);
		return $result;
	}
	
	/**
	 * ɾ
	 *
	 * @param int $type
	 * @return bool
	 */
	public function deleteByType($type) {
		if (!$type) return false;
		return $this->_getDao()->deleteByType($type);
	}

	/**
	 * ݹؼɾ
	 *
	 * @param string $keyword
	 * @return bool
	 */
	public function deleteByKeyword($keyword) {
		if (!$keyword) return false;
		return $this->_getDao()->deleteByKeyword($keyword);
	}

	/**
	 * ͡ؼɾ
	 *
	 * @param int $type
	 * @param string $keyword
	 * @return bool
	 */
	public function deleteByTypeAndKeyword($type, $keyword) {
		if (!$type || !$keyword) return false;
		return $this->_getDao()->deleteByTypeAndKeyword($type, $keyword);
	}
	/**
	 * 
	 *
	 * @param PwWordDm $dm
	 */
	public function update(PwWordDm $dm) {
		if (($result = $dm->beforeUpdate()) !== true) {
			return $result;
		}
		$fieldData = $dm->getData();
		if (!$fieldData) return false;

		$result = $this->_getDao()->update($dm->id, $fieldData);
		return $result;
	}
	
	/**
	 * 
	 *
	 * @param array $wordIds
	 * @param PwWordDm $dm
	 */
	public function batchUpdate($wordIds, PwWordDm $dm) {
		if (empty($wordIds) || !is_array($wordIds)) return false;
		if (($result = $dm->beforeUpdate()) !== true) {
			return $result;
		}
		
		$result = $this->_getDao()->batchUpdate($wordIds, $dm->getData());
		return $result;
	}
		
	/**
	 * ɾ
	 *
	 * @param array $wordIds
	 * @return bool
	 */
	public function batchDelete($wordIds) {
		if (empty($wordIds) || !is_array($wordIds)) return false;
		$result = $this->_getDao()->batchDelete($wordIds);
		return $result;
	}
	
	/**
	 * Ƿд
	 *
	 * @param string $word
	 * @param int $excludeId ųID
	 * @return bool
	 */
	private function _isExistWord($word, $excludeId = 0) {
		$word = $this->getByWord($word);
		if (!$word) return false;
		
		if ($excludeId && ($word['word_id'] == $excludeId)) return false;
		
		return true;
	}
	
	/**
	 * ͳ()
	 *
	 * @param PwWordSo $so
	 * @return int
	 */
	public function countSearchWord(PwWordSo $so) {
		return $this->_getDao()->countSearchWord($so->getData());
	}

	/**
	 * 
	 *
	 * @param PwWordSo $so
	 * @return array
	 */
	public function searchWord(PwWordSo $so, $limit = 20, $offset = 0) {
		return $this->_getDao()->searchWord($so->getData(), $limit, $offset);
	}

	/**
	 * ݱֱӻдб()
	 *
	 * @return array
	 */
	public function fetchAllWord() {
		return $this->_getDao()->fetchAllWord();
	}
	
	/**
	 * ()
	 *
	 */
	public function truncate() {
		return $this->_getDao()->truncate();
	}
	
	/**
	 * ȫ(̨ʹ)
	 *
	 */
	public function updateAllByTypeAndRelpace($type, $relpace) {
		$fieldData = array('word_type'=>$type, 'word_replace'=>$relpace);
		return $this->_getDao()->updateAll($fieldData);
	}
	
	/**
	 * жǷ滻
	 *
	 * @param int $type
	 * @return bool
	 */
	public function isReplaceWord($type) {
		return (intval($type) == self::WORD_REPLACE);
	}
	
	/**
	 * get PwWordDao
	 * 
	 * @access protected
	 * @return PwWordDao
	 */
	protected function _getDao() {
		return Wekit::loadDao('word.dao.PwWordDao');
	}
}