<?php

/**
 * ûDS
 *
 * @author xiaoxia.xu <xiaoxia.xuxx@aliyun-inc.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.phpwind.com
 * @version $Id: PwWork.php 1532 2012-1-1310:41:23 xiaoxiao $
 * @package src.service.user.hooks.experience_work
 */
class PwWork {

	/** 
	 * ӹ
	 *
	 * @param PwWorkDm $dm
	 * @return PwError|int
	 */
	public function addWorkExperience($dm) {
		if (!$dm instanceof PwWorkDm) return new PwError('USER:work.illegal.datatype');
		if (($result = $dm->beforeAdd()) instanceof PwError) return $result;
		return $this->_getDao()->add($dm->getData());
	}

	/** 
	 * ¹
	 *
	 * @param id $id
	 * @param PwWorkDm $dm
	 * @return PwError|boolean|int
	 */
	public function editWorkExperience($id, $dm) {
		$uid = intval($dm->getField('uid'));
		if (($id = intval($id)) < 1 || $uid < 1) return new PwError('USER:work.illegal.request');
		if (!$dm instanceof PwWorkDm) return new PwError('USER:work.illegal.datatype');
		if (($result = $dm->beforeUpdate()) instanceof PwError) return $result;
		return $this->_getDao()->update($id, $uid, $dm->getData());
	}

	/** 
	 * ɾ
	 *
	 * @param int $id  ID
	 * @param int $uid ӦûID
	 * @return PwError|int
	 */
	public function deleteWorkExperience($id, $uid) {
		if (($id = intval($id)) < 1 || ($uid = intval($uid)) < 1) return new PwError('USER:work.illegal.request');
		return $this->_getDao()->delete($id, $uid);
	}

	/** 
	 * IDû
	 *
	 * @param int $id  ID
	 * @param int $uid ûID 
	 * @return PwError|array
	 */
	public function getWorkExperienceById($id, $uid) {
		if (($id = intval($id)) < 1 || ($uid = intval($uid)) < 1) return new PwError('USER:work.illegal.request');
		return $this->_getDao()->get($id, $uid);
	}

	/** 
	 * ûIDɾûĹ
	 *
	 * @param int $uid
	 * @return PwError|int
	 */
	public function deleteWorkExperienceByUid($uid) {
		if (($uid = intval($uid)) < 1) return new PwError('USER:work.illegal.uid');
		return $this->_getDao()->deleteByUid($uid);
	}

	/** 
	 * ûIDûб
	 *
	 * @param int $uid
	 * @param int $number ĬΪ10
	 * @param int $start ʼλ
	 * @return array
	 */
	public function getByUid($uid, $number = 10, $start = 0) {
		if (($uid = intval($uid)) < 1) return array();
		return $this->_getDao()->getByUid($uid, $number, $start);
	}

	/** 
	 * ûIDͳƸûӵеĹ
	 *
	 * @param int $uid
	 * @return int
	 */
	public function countByUid($uid) {
		if (($uid = intval($uid)) < 1) return 0;
		return $this->_getDao()->countByUid($uid);
	}

	/** 
	 * ùdao
	 *
	 * @return PwWorkDao
	 */
	private function _getDao() {
		return Wekit::loadDao('SRV:work.dao.PwWorkDao');
	}
}