<?php

/**
 * Dao
 *
 * @author xiaoxia.xu <xiaoxia.xuxx@aliyun-inc.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.phpwind.com
 * @version $Id: PwWorkDao.php 1532 2012-1-1003:21:54 xiaoxiao $
 * @package src.service.user.hooks.experience_work.dao
 */
class PwWorkDao extends PwBaseDao {
	protected $_table = 'user_work';
	protected $_dataStruct = array('id', 'uid', 'company', 'starty', 'startm', 'endy', 'endm');
	
	/** 
	 * ӹ
	 *
	 * @param array $data
	 * @return boolean|int
	 */
	public function add($data) {
		if (!($data = $this->_filterStruct($data))) return false;
		$sql = $this->_bindSql('INSERT INTO %s SET %s', $this->getTable(), $this->sqlSingle($data));
		$smt = $this->getConnection()->execute($sql);
		return $this->getConnection()->lastInsertId();
	}
	
	/** 
	 * ¹
	 *
	 * @param int $id  ID
	 * @param int $uid ûID
	 * @param array $data
	 * @return boolean|int
	 */
	public function update($id, $uid, $data) {
		if (!($data = $this->_filterStruct($data))) return false;
		unset($data['uid']);
		$sql = $this->_bindSql('UPDATE %s SET %s WHERE `id` = ? AND `uid` = ?', $this->getTable(), $this->sqlSingle($data));
		$smt = $this->getConnection()->createStatement($sql);
		return $smt->update(array($id, $uid));
	}
	
	/** 
	 * ɾ
	 *
	 * @param int $id  ID
	 * @param int $uid ӦûID
	 * @return boolean|int
	 */
	public function delete($id, $uid) {
		$sql = $this->_bindTable('DELETE FROM %s WHERE `id` =? AND `uid` = ?');
		$smt = $this->getConnection()->createStatement($sql);
		return $smt->update(array($id, $uid));
	}

	/** 
	 * ݹIDȡùϸϢ
	 *
	 * @param int $id ID
	 * @param int $uid ûID
	 * @return array
	 */
	public function get($id, $uid) {
		$sql = $this->_bindTable('SELECT * FROM %s WHERE `id` =? AND `uid` = ?');
		$smt = $this->getConnection()->createStatement($sql);
		return $smt->getOne(array($id, $uid));
	}
	
	/** 
	 * ûIDɾû
	 *
	 * @param int $uid
	 * @return boolean|int
	 */
	public function deleteByUid($uid) {
		$sql = $this->_bindTable('DELETE FROM %s WHERE `uid` =?');
		$smt = $this->getConnection()->createStatement($sql);
		return $smt->update(array($uid));
	}
	
	/** 
	 * ûIDøûĹб
	 *
	 * @param int $uid ûID
	 * @param int $limit 
	 * @param int $start ʼλ
	 * @return array
	 */
	public function getByUid($uid, $limit, $start) {
		$sql = $this->_bindTable('SELECT * FROM %s WHERE `uid` =? ORDER BY `starty` DESC, `startm` DESC' . $this->sqlLimit($limit, $start));
		$smt = $this->getConnection()->createStatement($sql);
		return $smt->queryAll(array($uid), 'id');
	}
	
	/** 
	 * ûIDͳƸûĹ
	 *
	 * @param int $uid
	 * @return int
	 */
	public function countByUid($uid) {
		$sql = $this->_bindTable('SELECT COUNT(*) FROM %s WHERE `uid` =?');
		$smt = $this->getConnection()->createStatement($sql);
		return $smt->getValue(array($uid));
	}
}