<?php
define('WEKIT_PATH', dirname(__FILE__) . DIRECTORY_SEPARATOR);
define('WEKIT_VERSION', '0.3.9');
define('NEXT_VERSION', '9.0');
define('NEXT_RELEASE', '20140428');
define('NEXT_FIXBUG','9000003');
defined('WIND_DEBUG') || define('WIND_DEBUG', 0);

require WEKIT_PATH . '../wind/Wind.php';


/**
 * @author Jianmin Chen <sky_hold@163.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.phpwind.com
 * @version $Id: wekit.php 29883 2014-04-28 07:48 phpwind.net.cn $
 * @package wekit
 */
class Wekit {

	protected static $_sc;				//ϵͳ
	protected static $_var;				//ȫñ
	protected static $_app = array();	//Ӧö

	/**
	 * еǰӦ
	 *
	 * @param string $name ӦĬϡphpwind
	 * @param array $components 齨Ϣ 齨ýḲԭ齨ãĬΪ
	 */
	public static function run($name = 'phpwind', $components = array()) {
		self::init($name);
		if (!empty($components)) self::$_sc['components'] = (array)$components + self::$_sc['components'];

		/* @var $application WindWebFrontController */
		$application = Wind::application($name, self::$_sc);
		$application->registeFilter(new PwFrontFilters($application));
		$application->run();
	}

	/**
	 * phpwindʼ
	 *
	 * @return void
	 */
	public static function init($name) {
		function_exists('set_magic_quotes_runtime') && @set_magic_quotes_runtime(0);
		self::_loadSystemConfig($name);

		$_conf = include WEKIT_PATH . self::S('directory');
		foreach ($_conf as $namespace => $path) {
			$realpath = realpath(WEKIT_PATH . $path);
			Wind::register($realpath, $namespace);
			define($namespace . '_PATH', $realpath . DIRECTORY_SEPARATOR);
		}
		Wind::register(WEKIT_PATH, 'WEKIT');
		self::_loadBase();
		self::$_var = self::S('global-vars');
	}

	/**
	 * ȡʵ
	 *
	 * @param string $path ·
	 * @param string $loadway طʽ
	 * @param array $args 
	 * @return object
	 */
	public static function getInstance($path, $loadway = '', $args = array()) {
		switch ($loadway) {
			case 'loadDao':
				return self::loadDao($path);
			case 'load':
				return self::load($path);
			case 'static':
				return Wind::import($path);
			default:
				$reflection = new ReflectionClass(Wind::import($path));
				return call_user_func_array(array($reflection, 'newInstance'), $args);
		}
	}

	/**
	 * ()
	 *
	 * @param string $path ·
	 * @return object
	 */
	public static function load($path) {
		return PwLoader::load($path);
	}

	/**
	 * Dao()
	 *
	 * @param string $path ·
	 * @return object
	 */
	public static function loadDao($path) {
		return PwLoader::loadDao($path);
	}

	/**
	 * ȡDao()
	 *
	 * @param int $index 
	 * @param array $daoMap daoб
	 * @param string $vkey ַ
	 * @return object
	 */
	public static function loadDaoFromMap($index, $daoMap, $vkey) {
		return PwLoader::loadDaoFromMap($index, $daoMap, $vkey);
	}

	/**
	 * ȫֱ
	 *
	 * @param array|string|object $data
	 * @param string $key
	 * @see WindWebApplication::setGlobal
	 */
	public static function setGlobal($data, $key = '') {
		if ($key)
			$_G[$key] = $data;
		else {
			if (is_object($data)) $data = get_object_vars($data);
			$_G = $data;
		}
		Wind::getApp()->getResponse()->setData($_G, 'G', true);
	}

	/**
	 * ȫֱ
	 *
	 * @return array|string|object
	 * @see WindWebApplication::getGlobal
	 */
	public static function getGlobal() {
		$_args = func_get_args();
		array_unshift($_args, 'G');
		return call_user_func_array(array(Wind::getApp()->getResponse(), 'getData'), $_args);
	}

	/**
	 * ȡǰӦ
	 *
	 * @return phpwindBoot
	 */
	public static function app($re = 'global') {
		return self::$_app[$re];
	}

	/**
	 * ǰӦʵ
	 *
	 * @param string $appName Ӧ
	 * @param string $re л(Ӧû¿)
	 */
	public static function createapp($appName, $re = 'global') {
		if (isset(self::$_app[$re])) {
			return;
		}
		$class = Wind::import('SRC:bootstrap.' . $appName . 'Boot');
		self::$_app[$re] = new $class($re);
		self::$_app[$re]->cache = self::$_app[$re]->getCache();
		self::$_app[$re]->config = self::$_app[$re]->getConfigBo();
		self::$_app[$re]->config->sets(self::$_app[$re]->getConfig());
		self::$_app[$re]->time = self::$_app[$re]->getTime();
		self::$_app[$re]->charset = self::$_app[$re]->getCharset();
		self::$_app[$re]->url = self::$_app[$re]->getUrl();

		if ($re == 'global') {
			define('WEKIT_TIMESTAMP', self::$_app[$re]->time);
			self::setV('charset', self::$_app[$re]->charset);
		}
	}

	public static function setapp($re, $app) {
		self::$_app[$re] = $app;
	}

	/**
	 * ȡǰ¼û
	 *
	 * @return PwUserBo
	 */
	public static function getLoginUser() {
		return self::$_app['global']->getLoginUser();
	}

	/**
	 * ȡȫֻ
	 *
	 * @param string $key
	 * @return mixed
	 */
	public static function V($key) {
		return self::$_var[$key];
	}

	/**
	 * ȫֻ
	 *
	 * @param string $key
	 * @param mixed $value
	 */
	public static function setV($key, $value) {
		self::$_var[$key] = $value;
	}

	/**
	 * ȡӦ config
	 *
	 * @param string $namespace 
	 * @param string $key üֵ
	 * @return mixted
	 */
	public static function C($namespace = '', $key = '') {
		return self::$_app['global']->config->C($namespace, $key);
	}

	/**
	 * ȡͨû
	 *
	 * @return object
	 */
	public static function cache() {
		return self::$_app['global']->cache;
	}

	public static function url() {
		return self::$_app['global']->url;
	}

	/**
	 * ȡϵͳ
	 */
	public static function S($key = 'ALL') {
		if ($key == 'ALL') {
			return self::$_sc;
		}
		$var = self::$_sc[$key];
		if (is_array($var) && isset($var['resource'])) {
			$resource = $var['resource'];
			unset($var['resource']);
			if (is_array($resource)) {
				$tmp = array();
				foreach ($resource as $key => $value) {
					$tmp = array_merge($tmp, include(Wind::getRealPath($value, true)));
				}
			} else {
				$tmp = include(Wind::getRealPath($resource, true));
			}
			$var = WindUtility::mergeArray($var, $tmp);
		}
		return $var;
	}

	/**
	 * ϵͳ
	 */
	protected static function _loadSystemConfig($name) {
		self::$_sc = WindUtility::mergeArray(
			include WEKIT_PATH . '../conf/application/default.php',
			include WEKIT_PATH . '../conf/application/' . $name . '.php'
		);
	}

	/**
	 * Ԥļ
	 *
	 * @return void
	 */
	protected static function _loadBase() {
		Wind::import('WIND:utility.WindFolder');
		Wind::import('WIND:utility.WindJson');
		Wind::import('WIND:utility.WindFile');
		Wind::import('WIND:utility.WindValidator');
		Wind::import('WIND:utility.WindCookie');
		Wind::import('WIND:utility.WindSecurity');
		Wind::import('WIND:utility.WindString');
		Wind::import('WIND:utility.WindConvert');

		Wind::import('LIB:base.*');
		Wind::import('LIB:engine.extension.viewer.*');
		Wind::import('LIB:engine.component.*');
		Wind::import('LIB:engine.error.*');
		Wind::import('LIB:engine.exception.*');
		Wind::import('LIB:engine.hook.*');
		Wind::import('LIB:engine.PwCache');
		Wind::import('LIB:engine.PwConfigBo');
		Wind::import('LIB:engine.PwConfigSet');
		Wind::import('LIB:Pw');
		Wind::import('LIB:PwLoader');
		Wind::import('LIB:filter.PwFrontFilters');

		Wind::import('WINDID:WindidApi');
	}
}
