<?php
/**
 * the last known user to change this file in the repository  <$LastChangedBy: jieyin $>
 * @author $Author: jieyin $ Foxsee@aliyun.com
 * @copyright ?2003-2103 phpwind.com
 * @license http://www.phpwind.com
 * @version $Id: WindidMessageApi.php 24706 2013-02-16 06:02:32Z jieyin $ 
 * @package 
 */

class WindidMessageApi {
	
	/**
	 * ȡ˽
	 * 
	 * @param int $messageId ˽ID
	 */
	public function getMessageById($messageId) {
		$params = array(
			'messageId' => $messageId,
		);
		return WindidApi::open('message/getMessageById', $params);
	}
	
	/**
	 * ȡûδϢ
	 *
	 * @param int $uid
	 * @return int
	 */
	public function getUnRead($uid) {
		$params = array(
			'uid' => $uid
		);
		return WindidApi::open('message/getNum', $params);
	}
	
	/**
	 * ͳһỰϢ
	 *
	 * @param int $dialogId
	 * @return int
	 */
	public function countMessage($dialogId) {
		$params = array(
			'dialogId' => $dialogId,
		);
		return WindidApi::open('message/countMessage', $params);
	}
	
	/**
	 * ȡϢб
	 *
	 * @param int $dialogId
	 * @param int $start
	 * @param int $limit
	 * @return array
	 */
	public function getMessageList($dialogId, $start = 0, $limit = 10) {
		$params = array(
			'dialogId' => $dialogId,
			'start' => $start,
			'limit' => $limit,
		);
		return WindidApi::open('message/getMessageList', $params);
	}
	
	/**
	 * ȡһԻϢ
	 * 
	 * @param int $dialogId
	 */
	public function getDialog($dialogId) {
		$params = array(
			'dialogId' => $dialogId,
		);
		return WindidApi::open('message/getDialog', $params);
	}
	
	/**
	 * ỰidsȡԻϢб
	 * 
	 * @param array $dialogIds
	 * @return array 
	 */
	public function fetchDialog($dialogIds) {
		$params = array(
			'dialogIds' => $dialogIds,
		);
		return WindidApi::open('message/fetchDialog', $params);
	}
	
	/**
	 * ȡϢϢ
	 * 
	 * @param int $toUid
	 * @param int $fromUid
	 */
	public function getDialogByUser($uid, $dialogUid) {
		$params = array(
			'uid' => $uid,
			'dialogUid' => $dialogUid,
		);
		return WindidApi::open('message/getDialogByUser', $params);
	}
	
	/**
	 * ȡϢϢ
	 * 
	 * @param int $uid
	 * @param int $from_uids
	 */
	public function getDialogByUsers($uid, $dialogUids) {
		$params = array(
			'uid' => $uid,
			'dialogUids' => $dialogUids,
		);
		return WindidApi::open('message/getDialogByUsers', $params);
	}
	
	/**
	 * ȡԻϢб
	 * 
	 * @param int $uid
	 * @param int $start
	 * @param int $limit
	 * @return array 
	 */
	public function getDialogList($uid, $start = 0, $limit = 10) {
		$params = array(
			'uid' => $uid,
			'start' => $start,
			'limit' => $limit,
		);
		return WindidApi::open('message/getDialogList', $params);
	}
	
	/**
	 * ͳƷϢб
	 * 
	 * @param int $uid
	 * @return int 
	 */
	public function countDialog($uid) {
		$params = array(
			'uid' => $uid,
		);
		return WindidApi::open('message/countDialog', $params);
	}
	
	/**
	 * ȡδԻ
	 * 
	 * @param int $uid
	 * @param int $limit
	 * @return array
	 */
	public function getUnreadDialogsByUid($uid, $limit =10) {
		$params = array(
			'uid' => $uid,
			'limit' => $limit,
		);
		return WindidApi::open('message/getUnreadDialogsByUid', $params);
	}
	
	/**
	 * Ϣ
	 * 
	 * @param array $search array('fromuid', 'keyword', 'username', 'starttime', 'endtime')
	 * @param int $start
	 * @param int $limit
	 * @return array(count, list)
	 */
	public function searchMessage($search, $start = 0, $limit = 10) {
		if (!is_array($search)) return array(0, array());
		$params = array(
			'start' => $start,
			'limit' => $limit,
		);
		$array = array('fromuid', 'keyword', 'username', 'starttime', 'endtime');
		foreach ($search as $k => $v) {
			if (!in_array($k, $array)) continue;
			$params[$k] = $v;
		}
		return WindidApi::open('message/searchMessage', $params);
	}

	/**
	 * Ϣ
	 *
	 * @param int $uid
	 * @param int $num
	 */
	public function editMessageNum($uid, $num) {
		$params = array(
			'uid' => $uid,
			'num' => $num,
		);
		return WindidApi::open('message/editNum', array(), $params);
	}
	
	/**
	 * Ϣ
	 *
	 * @param array $uids ռuids
	 * @param string $content Ϣ
	 * @param int $fromUid 
	 * @return int
	 */
	public function send($uids, $content, $fromUid = 0) {
		$params = array(
			'uids' => $uids,
			'content' => $content,
			'fromUid' => $fromUid,
		);
		return WindidApi::open('message/send', array(), $params);
	}
	
	/**
	 * Ѷ
	 *
	 * @param int $uid
	 * @param int $dialogId
	 * @param array $messageIds
	 * @return int ǳɹ    
	 */
	public function read($uid, $dialogId, $messageIds = array()) {
		$params = array(
			'uid' => $uid,
			'dialogId' => $dialogId,
			'messageIds' => $messageIds,
		);
		return WindidApi::open('message/read', array(), $params);
	}
	
	public function readDialog($dialogIds) {
		$params = array(
			'dialogIds' => $dialogIds,
		);
		return WindidApi::open('message/readDialog', array(),$params);
	}
	
	public function delete($uid, $dialogId, $messageIds = array()) {
		$params = array(
			'uid' => $uid,
			'dialogId' => $dialogId,
			'messageIds' => $messageIds,
		);
		return WindidApi::open('message/delete', array(), $params);
	}
	
	public function batchDeleteDialog($uid, $dialogIds) {
		$params = array(
			'uid' => $uid,
			'dialogIds' => $dialogIds,
		);
		return WindidApi::open('message/batchDeleteDialog', array(), $params);
	}
	
	public function deleteByMessageIds($messageIds) {
		$params = array(
			'messageIds' => $messageIds,
		);
		return WindidApi::open('message/deleteByMessageIds', array(), $params);
	}
	
	public function deleteUserMessages($uid) {
		$params = array(
			'uid' => $uid,
		);
		return WindidApi::open('message/deleteUserMessages', array(), $params);
	}
	
	/********************** ͳռ䣬ӿstart *********************/
	
	/**
	 * 
	 *
	 * @return array
	 */
	public function fromBox($fromUid, $start = 0, $limit = 10) {
		$params = array(
			'uid' => $fromUid,
			'start' => $start,
			'limit' => $limit
		);
		return WindidApi::open('message/fromBox', $params);
	}
	
	/**
	 * ռ
	 *
	 * @return array
	 */
	public function toBox($toUid, $start = 0, $limit = 10) {
		$params = array(
			'uid' => $uid,
			'start' => $start,
			'limit' => $limit
		);
		return WindidApi::open('message/toBox', $params);
	}
	
	public function readMessages($uid, $messageIds) {
		$params = array(
			'uid' => $uid,
			'messageIds' => $messageIds,
		);
		return WindidApi::open('message/readMessages', array(), $params);
	}
	
	public function deleteMessages($uid, $messageIds) {
		$params = array(
			'uid' => $uid,
			'messageIds' => $messageIds,
		);
		return WindidApi::open('message/deleteMessages', array(), $params);
	}
	
	/**********************ͳռ䣬ӿend *********************/
}
?>