<?php
/**
 * windidûӿ
 * the last known user to change this file in the repository  <$LastChangedBy: jieyin $>
 * @author $Author: jieyin $ Foxsee@aliyun.com
 * @copyright ?2003-2103 phpwind.com
 * @license http://www.phpwind.com
 * @version $Id: WindidUserApi.php 24943 2013-02-27 03:52:21Z jieyin $ 
 * @package 
 */
class WindidUserApi {
	
	/**
	 * û¼
	 *
	 * @param string $userid
	 * @param string $password
	 * @param int $type $type 1-uid ,2-username 3-email
	 * @param string $question
	 * @param string $answer
	 * @return array
	 */
	public function login($userid, $password, $type = 2, $ifcheck = false, $question = '', $answer = '') {
		$params = array(
			'userid' => $userid,
			'password' => $password,
			'type' => $type,
			'ifcheck' => $ifcheck,
			'question' => $question,
			'answer' => $answer,
		);
		return WindidApi::open('user/login', array(), $params);
	}
	
	/**
	 * ص¼ɹͬ¼֪ͨ
	 * 
	 * @param int $uid
	 * @return string
	 */
	public function synLogin($uid) {
		$params = array(
			'uid' => $uid,
		);
		return WindidApi::open('user/synLogin', array(), $params);
	}
	
	/**
	 * صǳɹͬǳ
	 *
	 * @param int $uid
	 * @param string $backurl
	 * @return string
	 */
	public function synLogout($uid) {
		$params = array(
			'uid' => $uid,
		);
		return WindidApi::open('user/synLogout',  array(), $params);
	}
	
	/**
	 * ûύϢǷwindidù淶
	 *
	 * @param string $input
	 * @param int $type ۺϼͣ 1-û, 2-,  3-
	 * @param int $uid
	 * @return bool
	 */
	public function checkUserInput($input, $type, $username = '', $uid = 0) {
		$params = array(
			'input' => $input,
			'type' => $type,
			'username' => $username,
			'uid' => $uid,
		);
		return WindidApi::open('user/checkInput', array(), $params);
	}
	
	/**
	 * ֤ȫ
	 *
	 * @param int $uid
	 * @param int $question
	 * @param int $answer
	 * @return bool
	 */ 
	public function checkQuestion($uid, $question, $answer) {
		$params = array(
			'uid' => $uid,
			'question' => $question,
			'answer' => $answer,
		);
		return WindidApi::open('user/checkQuestion', array(),$params);
	}
	
	/**
	 * ȡһû
	 *
	 * @param multi $userid
	 * @param int $type 1-uid ,2-username 3-email
	 * @param int $fetchMode
	 * @return array
	 */
	public function getUser($userid, $type = 1, $fetchMode = 1) {
		$params = array(
			'userid' => $userid,
			'type' => $type,
			'fetch' => $fetchMode
		);
		return WindidApi::open('user/get', $params);
	}
	
	/**
	 * ȡûϢ
	 *
	 * @param array $uids/$username
	 * @param int $type 1-uid ,2-username
	 * @param int $fetchMode
	 * @return array
	 */
	public function fecthUser($userids, $type = 1, $fetchMode = 1) {
		$params = array(
			'userids' => $userids,
			'type' => $type,
			'fetch' => $fetchMode
		);
		return WindidApi::open('user/fecth', $params);
	}
	
	/**
	 * ûע
	 *
	 * @param string $username
	 * @param string $email
	 * @param string $password
	 * @param string $question
	 * @param string $answer
	 * @param string $regip
	 * @return int
	 */
	public function register($username, $email, $password, $question = '', $answer = '', $regip = '') {
		$params = array(
			'username' => $username,
			'email' => $email,
			'password' => $password,
			'question' => $question,
			'answer' => $answer,
			'regip' => $regip,
		);
		return WindidApi::open('user/addUser', array(), $params);
	}
	
	/**
	 * ûӿڣʹǰʹWidnidApi::getDm('user') 
	 *
	 * @param WindidUserDm $dm
	 * @return int
	 */
	public function addDmUser(WindidUserDm $dm) {
		/*
		if (($result = $dm->beforeAdd()) instanceof WindidError) {
			return $result->getCode();
		}
		*/
		$params = $dm->getData();
		$params['password'] = $dm->password;
		unset($params['salt'], $params['safecv']);
		return WindidApi::open('user/addUser', array(), $params);
	}
	
	/**
	 * ޸ûϢ
	 *
	 * @param int $uid
	 * @param string $password ǷУ
	 * @param array $editInfo  array('username', 'password', 'email', 'question', 'answer')
	 */
	public function editUser($uid, $password, $editInfo) {
		$dm = $this->_getUserService()->getBaseUserDm($uid, $password, $editInfo);
		return $this->editDmUser($dm);
	}
	
	/**
	 * ޸û
	 *
	 * @param int $uid
	 * @param array $editInfo
	 */
	public function editInfo($uid, $editInfo) {
		$dm = $this->_getUserService()->getInfoUserDm($uid, $editInfo);
		return $this->editDmUser($dm);
	}
	
	public function editDmUser(WindidUserDm $dm) {
		/*
		if (($result = $dm->beforeUpdate()) instanceof WindidError) {
			return $result->getCode();
		}
		*/
		$params = $dm->getData();
		$params['uid'] = $dm->uid;
		if (isset($params['password'])) {
			$params['password'] = $dm->password;
		}
		unset($params['salt'], $params['safecv']);
		return WindidApi::open('user/editUser', array(), $params);
	}
	
	/**
	 * ɾһû
	 *
	 * @param int $uid
	 */
	public function deleteUser($uid) {
		$params = array(
			'uid' => $uid,
		);
		return WindidApi::open('user/delete', array(), $params);
	}
	
	/**
	 * ɾû
	 *
	 * @param array $uids
	 */
	public function batchDeleteUser($uids) {
		$params = array(
			'uids' => $uids,
		);
		return WindidApi::open('user/batchDelete', array(), $params);
	}
	
	/**
	 * ȡû
	 *
	 * @param int $uid
	 */
	public function getUserCredit($uid) {
		$params = array(
			'uid' => $uid,
		);
		return WindidApi::open('user/getCredit', $params);
	}
	
	/**
	 * ȡû
	 *
	 * @param array $uids
	 * @return array
	 */
	public function fecthUserCredit($uids) {
		$params = array(
			'uids' => $uids,
		);
		return WindidApi::open('user/fecthCredit', $params);
	}
	
	/**
	 * û
	 *
	 * @param int $uid
	 * @param int $cType (1-8)
	 * @param int $value
	 */
	public function editCredit($uid, $cType, $value, $isset = false) {
		$params = array(
			'uid' => $uid,
			'cType' => $cType,
			'value' => $value,
			'isset' => $isset,
		);
		return WindidApi::open('user/editCredit', array(), $params);
	}
	
	public function editDmCredit(WindidCreditDm $dm) {
		$params = array(
			'uid' => $dm->uid,
			'set' => array(),
			'add' => array()
		);
		$data = $dm->getData();
		$increase = $dm->getIncreaseData();
		if ($data) {
			foreach ($data as $key => $value) {
				$params['set'][substr($key, 6)] = $value;
			}
		}
		if ($increase) {
			foreach ($increase as $key => $value) {
				$params['add'][substr($key, 6)] = $value;
			}
		}
		return WindidApi::open('user/editDmCredit', array(), $params);
	}
	
	/**
	 * һֶ
	 *
	 * @param int $num >8
	 */
	public function clearCredit($num) {
		$params = array(
			'num' => $num,
		);
		return WindidApi::open('user/clearCredit',array(), $params);
	}
	
	/**
	 * ȡû
	 *
	 * @param int $uid
	 * @return array uids
	 */
	public function getBlack($uid) {
		$params = array(
			'uid' => $uid,
		);
		return WindidApi::open('user/getBlack', $params);
	}
	
	public function fetchBlack($uids) {
		$params = array(
			'uids' => $uids,
		);
		return WindidApi::open('user/fetchBlack', $params);
	}
	
	/**
	 * Ӻ
	 *
	 * @param int $uid
	 * @param int $blackUid
	 */
	public function addBlack($uid, $blackUid) {
		$params = array(
			'uid' => $uid,
			'blackUid' => $blackUid,
		);
		return WindidApi::open('user/addBlack', array(), $params);
	}
	
	public function replaceBlack($uid, $blackList) {
		$params = array(
			'uid' => $uid,
			'blackList' => $blackList,
		);
		return WindidApi::open('user/replaceBlack', array(), $params);
	}
	
	/**
	 * ɾĳĺ $blackUidΪɾ
	 *
	 * @param int $uid
	 * @param int $blackUid
	 */
	public function delBlack($uid, $blackUid = '') {
		$params = array(
			'uid' => $uid,
			'blackUid' => $blackUid,
		);
		return WindidApi::open('user/delBlack', array(), $params);
	}
}
?>