<?php

Wind::import('WIND:http.transfer.WindHttpSocket');
/**
 * Ӧù
 * 
 * @author Jianmin Chen <sky_hold@163.com>
 * @license http://www.phpwind.com
 * @version $Id: WindidApp.php 24398 2013-01-30 02:45:05Z jieyin $
 * @package windid.service.app
 */
class WindidApp {

	/**
	 * ȡӦ
	 *
	 * @return array
	 */
	public function getApp($id) {
		return $this->_getDao()->get($id);
	}
	
	public function fetchApp($ids) {
		if (!is_array($ids)  || !$ids) return array();
		return $this->_getDao()->fetch($ids);
	}

	/**
	 * ȡӦб
	 *
	 * @return array
	 */
	public function getList() {
		return $this->_getDao()->getList();
	}

	/**
	 * һӦ
	 *
	 * @param WindidAppDm $dm Ӧݶ
	 * @return int עӦid
	 */
	public function addApp(WindidAppDm $dm) {
		if (true !== ($check = $dm->beforeAdd())) return $check;
		return $this->_getDao()->add($dm->getData());
	}

	/**
	 * ɾһӦ
	 *
	 * @param int $id Ӧid
	 * @return bool true|false
	 */
	public function delApp($id) {
		$result = $this->_getDao()->delete($id);
		return $result;
	}

	/**
	 * ༭ӦϢ
	 *
	 * @param int $id Ӧid
	 * @param WindidAppDm $dm ӦϢ
	 * @return bool true|false
	 */
	public function editApp(WindidAppDm $dm) {
		if (true !== ($check = $dm->beforeUpdate())) return $check;
		return $this->_getDao()->update($dm->id, $dm->getData());
	}

	/**
	 * ӦDao
	 * 
	 * @return WindidAppDao
	 */
	private function _getDao() {
		return Wekit::loadDao('WSRV:app.dao.WindidAppDao');
	}
}