<?php
/**
 * DS
 *
 * @author xiaoxia.xu <xiaoxia.xuxx@aliyun-inc.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id: WindidArea.php 24398 2013-01-30 02:45:05Z jieyin $
 * @package windid.service.area
 */
class WindidArea {
	
	/**
	 * ݵһIDһ
	 *
	 * @param int $parentid ID
	 * @return array
	 */
	public function getAreaByParentid($parentid) {
		return $this->_getDao()->getAreaByParentid(intval($parentid));
	}
	
	/**
	 * ݵIDøõϢ
	 *
	 * @param int $areaid ID
	 * @return array
	 */
	public function getArea($areaid) {
		$areaid = intval($areaid);
		if ($areaid < 1) return array();
		return $this->_getDao()->getArea($areaid);
	}
	
	/**
	 * ݵIDбȡЩϢ
	 *
	 * @param array $areaids
	 * @return array
	 */
	public function fetchByAreaid($areaids) {
		if (!$areaids) return array();
		return $this->_getDao()->fetchByAreaid($areaids);
	}
	
	/**
	 * ȡеĵ
	 *
	 * @return array
	 */
	public function fetchAll() {
		return $this->_getDao()->fetchAll();
	}
	
	/**
	 * ӵ
	 *
	 * @param WindidAreaDm $dm DM
	 * @return boolean
	 */
	public function addArea(WindidAreaDm $dm) {
		if (($r = $dm->beforeUpdate()) !== true) return $r;
		return $this->_getDao()->addArea($dm->getData());
	}
	
	/**
	 * ĳһĵӵ
	 *
	 * @param array $dms 
	 * @return boolean
	 */
	public function batchAddArea($dms) {
		$data = array();
		foreach ($dms as $_item) {
			if (!$_item instanceof WindidAreaDm) continue;
			if ($_item->beforeAdd() !== true) continue;
			$data[] = $_item->getData();
		}
		if (!$data) return false;
		return $this->_getDao()->batchAddArea($data);
	}
	
	/**
	 * ݵIDһϢ
	 *
	 * @param WindidAreaDm $dm Dm
	 * @return boolean
	 */
	public function updateArea(WindidAreaDm $dm) {
		if (($r = $dm->beforeUpdate()) !== true) return $r;
		return $this->_getDao()->updateArea($dm->areaid, $dm->getData());
	}
	
	/**
	 * ݵIDɾϢ
	 *
	 * @param int $areaid ID
	 * @return boolean
	 */
	public function deleteArea($areaid) {
		if (($areaid = intval($areaid)) < 1) return false;
		return $this->_getDao()->deleteArea($areaid);
	}
	
	/**
	 * ɾϢ
	 *
	 * @param array $areaids  IDб
	 * @return boolean|number
	 */
	public function batchDeleteArea($areaids) {
		if (!$areaids) return false;
		return $this->_getDao()->batchDeleteArea($areaids);
	}
	
	/**
	 * ȡDAO
	 *
	 * @return WindidAreaDao
	 */
	private function _getDao() {
		return Wekit::loadDao('WSRV:area.dao.WindidAreaDao');
	}
}