<?php

/**
 * DAO
 *
 * @author xiaoxia.xu <xiaoxia.xuxx@aliyun-inc.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id: WindidAreaDao.php 23820 2013-01-16 06:14:07Z jieyin $
 * @package windid.service.area.dao
 */
class WindidAreaDao extends WindidBaseDao {
	
	protected $_table = 'area';
	protected $_pk = 'areaid';
	protected $_dataStruct = array('areaid', 'name', 'parentid', 'joinname');
	
	/**
	 * һIDһе
	 *
	 * @param int $parentid
	 * @return array
	 */
	public function getAreaByParentid($parentid) {
		$sql = $this->_bindTable('SELECT * FROM %s WHERE `parentid` = ? ORDER BY areaid');
		$smt = $this->getConnection()->createStatement($sql);
		return $smt->queryAll(array($parentid), 'areaid');
	}
	
	/**
	 * ݵIDøõϢ
	 *
	 * @param int $areaid
	 * @return array
	 */
	public function getArea($areaid) {
		return $this->_get($areaid);
	}
	
	/**
	 * ݵIDбȡб
	 *
	 * @param array $areaids
	 * @return array
	 */
	public function fetchByAreaid($areaids) {
		return $this->_fetch($areaids, 'areaid');
	}
	
	/**
	 * ȡеĵ
	 *
	 * @return array
	 */
	public function fetchAll() {
		$sql = $this->_bindTable('SELECT * FROM %s ORDER BY areaid');
		return $this->getConnection()->query($sql)->fetchAll('areaid');
	}
	
	/**
	 * ӵ
	 *
	 * @param array $data 
	 * @return int
	 */
	public function addArea($data) {
		return $this->_add($data);
	}
	
	/**
	 * 
	 *
	 * @param array $data 
	 * @return int
	 */
	public function batchAddArea($data) {
		$clear = array();
		foreach ($data as $_item) {
			if (!($_item = $this->_filterStruct($_item))) continue;
			$clear[] = array($_item['name'], $_item['parentid'], $_item['joinname']);
		}
		if (!$clear) return false;
		$sql = $this->_bindSql('INSERT INTO %s (`name`, `parentid`, `joinname`) VALUES %s', $this->getTable(), $this->sqlMulti($clear));
		return $this->getConnection()->execute($sql);
	}
	
	/**
	 * µ
	 *
	 * @param int $areaid ID
	 * @param array $data 
	 * @return int
	 */
	public function updateArea($areaid, $data) {
		return $this->_update($areaid, $data);
	}
	
	/**
	 * ݵIDɾϢ
	 *
	 * @param int $areaid
	 * @return boolean
	 */
	public function deleteArea($areaid) {
		return $this->_delete($areaid);
	}
	
	/**
	 * ݵIDɾ
	 *
	 * @param array $areaids
	 * @return int
	 */
	public function batchDeleteArea($areaids) {
		return $this->_batchDelete($areaids);
	}
}