<?php
defined('WEKIT_VERSION') || exit('Forbidden');

/**
 * ַ
 *
 * @author xiaoxia.xu <xiaoxia.xuxx@aliyun-inc.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.phpwind.com
 * @version $Id: WindidCreditSetService.php 24718 2013-02-17 06:42:06Z jieyin $
 * @package src.service.credit
 */
class WindidCreditSetService {

	/** 
	 * û
	 * 
	 * @param array $credit Ϣ<array('1' => array('name'=>?,'unit'=>?,'descrip'=>?), '2' => ?, ...)>
	 * @param array $new ӵĻ
	 * @return boolean
	 */
	public function setCredits($credits, $newCredit = array()) {
		is_array($credits) || $credits = array();
		if ($newCredit) {
			$keys = array_keys($credits);
			$maxKey = intval(max($keys));
			$range = range(1, $maxKey + count($newCredit));
			$freeKeys = array_diff($range, $keys);
			asort($freeKeys);

			foreach ($newCredit as $key => $value) {
				if (!$value['name']) continue;
				$_key = array_shift($freeKeys);
				$credits[$_key] = $value;
			}
		}
		$this->setLocalCredits($credits);
		return true;
	}

	public function setLocalCredits($credits) {
		$struct = $this->_getDs()->getCreditStruct();
		foreach ($credits as $key => $value) {
			if (!in_array('credit' . $key, $struct)) {
				$this->_getDs()->alterAddCredit($key);
			}
		}
		foreach ($struct as $key => $value) {
			$_key = substr($value, 6);
			if (!isset($credits[$_key])) {
				if ($_key < 9) {
					$this->_getDs()->clearCredit($_key);
				} else {
					$this->_getDs()->alterDropCredit($_key);
				}
			}
		}

		//windidĻ
		Wind::import('WSRV:config.srv.WindidConfigSet');
		$config = new WindidConfigSet('credit');
		$config->set('credits', $credits)->flush();
		return true;
	}

	/** 
	 * ɾ
	 * 
	 * 漰£
	 * 1windidϵĻ
	 * 2صĻ
	 * 3ûֵֶ
	 * 3.1: ֶ8ֻݣֶ8ϣɾӦֶ
	 *
	 * @param int $creditId ID
	 * @return PwError|boolean
	 */
	public function deleteCredit($creditId) {
		if ($creditId < 0) {
			return false;
		}
		$credit = $this->_getConfigDs()->getValues('credit');
		$credits = $credit['credits'];
		unset($credits[$creditId]);

		$this->setLocalCredits($credits);
		return true;
	}

	/**
	 * ȡDS
	 *
	 * @return PwUserDataExpand
	 */
	private function _getDs() {
		return Wekit::load('WSRV:user.WindidUser');
	}

	private function _getConfigDs() {
		return Wekit::load('WSRV:config.WindidConfig');
	}
}