<?php
/**
 * @author Qiong Wu <papa0924@gmail.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.phpwind.com/license.php
 * @version $Id$
 * @package wind
 */
class PwHookInject {

	/**
	 * עϢ
	 *
	 * @param PwHookInjectDm $inject
	 * @return PwError|true
	 */
	public function add($inject) {
		$error = $inject->beforeAdd();
		if ($error !== true) return new PwError($error[0], $error[1]);
		return $this->_load()->add($inject->getData());
	}

	/**
	 * ޸עϢ
	 *
	 * @param PwHookInjectDm $inject
	 * @return PwError|true
	 */
	public function update($inject) {
		$error = $inject->beforeUpdate();
		if ($error !== true) return new PwError($error[0], $error[1]);
		return $this->_load()->update($inject->getId(), $inject->getData());
	}

	/**
	 * ӹעϢ
	 *
	 * @param array $injects
	 */
	public function batchAdd($injects) {
		return $this->_load()->batchAdd($injects);
	}

	/**
	 * injectIdɾinjector
	 *
	 * @param int $id
	 * @return PwError|boolean
	 */
	public function del($id) {
		return $this->_load()->del($id);
	}

	/**
	 * injectIdɾinjector
	 *
	 * @param array $ids
	 * @return PwError|boolean
	 */
	public function batchDel($ids) {
		return $this->_load()->batchDelById($ids);
	}

	/**
	 * HookNameɾinjectorϢ
	 *
	 * @param string $hookName
	 * @return Ambigous <boolean, Ambigous, rowCount, number>
	 */
	public function delByHookName($hookName) {
		return $this->_load()->delByHookName($hookName);
	}

	/**
	 * ݹɾinjector
	 *
	 * @param array $hookNames
	 * @return Ambigous <boolean, Ambigous, rowCount, number>
	 */
	public function batchDelByHookName($hookNames) {
		return $this->_load()->batchDelByHookName($hookNames);
	}

	/**
	 * ݱɾinjector
	 *
	 * @param string $alias
	 * @return Ambigous <boolean, rowCount, number>
	 */
	public function delByAlias($alias) {
		return $this->_load()->delByAlias($alias);
	}

	/**
	 * ݱɾinjector
	 *
	 * @param array $alias
	 * @return Ambigous <boolean, Ambigous, rowCount, number>
	 */
	public function batchDelByAlias($alias) {
		return $this->_load()->batchDelByAlias($alias);
	}

	/**
	 * ݱ͹ɾչ¼
	 *
	 * @param string $alias
	 * @param string $hookName
	 * @return Ambigous <Ambigous, rowCount, boolean, number>
	 */
	public function delByAliasAndHookName($alias, $hookName) {
		return $this->_load()->delByHookNameAndAlias($alias, $hookName);
	}

	/**
	 * @return Ambigous <number, string, boolean>
	 */
	public function count() {
		return $this->_load()->count();
	}

	/**
	 * ݱinjector
	 *
	 * @param string $alias
	 * @return Ambigous <multitype:, multitype:multitype: Ambigous <multitype:, multitype:unknown , mixed> >
	 */
	public function fetchByAlias($alias) {
		return $this->_load()->findByAlias($alias);
	}

	/**
	 * ݱע
	 *
	 * @param array $alias
	 * @return Ambigous <Ambigous, rowCount, boolean, number>
	 */
	public function batchFetchByAlias($alias) {
		is_array($alias) || $alias = array($alias);
		return $this->_load()->batchFindByAlias($alias);
	}

	/**
	 * HookƲinjector
	 *
	 * @param string $hookName
	 * @return array
	 */
	public function findByHookName($hookName) {
		return $this->_load()->findByHookName($hookName);
	}
	
	/**
	 * Hookinjector
	 *
	 * @param array $hookName
	 * @return array
	 */
	public function fetchByHookName($hookNames) {
		if (empty($hookNames)) return array();
		return $this->_load()->fetchByHookName($hookNames);
	}

	/**
	 * IDhookInjectעϢhook
	 *
	 * @param string $appId
	 * @return array
	 */
	public function find($id) {
		return (0 >= ($id = intval($id))) ? array() : $this->_load()->find($id);
	}
	
	/**
	 * idȡhook
	 *
	 * @param array $ids
	 * @return array
	 */
	public function fetch($ids) {
		if (!$ids) return array();
		return $this->_load()->_fetch((array)$ids);
	}

	/**
	 * ҳinjector
	 *
	 * @param int $num
	 * @param int $start
	 * @param int $index
	 * @param string $order
	 * @return Ambigous <boolean, Ambigous, multitype:, multitype:multitype: Ambigous <multitype:, multitype:unknown , mixed> >
	 */
	public function fetchByPage($num = 10, $start = 0, $index = 'id', $order = 'alias') {
		return $this->_load()->findByPage($num, $start, $index, $order);
	}
	
	/**
	 * Ӧɾ
	 *
	 * @param string $appName
	 * @return Ambigous <rowCount, boolean, number>
	 */
	public function deleteByAppName($appName) {
		return $this->_load()->deleteByAppName($appName);
	}
	
	/**
	 * Ӧidɾ
	 *
	 * @param string $appName
	 * @return Ambigous <rowCount, boolean, number>
	 */
	public function deleteByAppId($appid) {
		return $this->_load()->deleteByAppId($appid);
	}
	
	/**
	 * appidȡӦעб
	 *
	 * @param string $appid
	 * @return array
	 */
	public function findByAppId($appid) {
		return $this->_load()->findByAppid($appid);
	}

	/**
	 * @return PwHookInjectDao
	 */
	private function _load() {
		return Wekit::loadDao('SRV:hook.dao.PwHookInjectDao');
	}
}

?>