<?php
/**
 * @author Qiong Wu <papa0924@gmail.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.phpwind.com/license.php
 * @version $Id$
 * @package wind
 */
class PwHookInjectDao extends PwBaseDao {
	protected $_table = 'hook_inject';
	protected $_pk = 'id';
	protected $_dataStruct = array(
		'id', 
		'app_id',
		'app_name',
		'hook_name', 
		'alias', 
		'class', 
		'method', 
		'loadway', 
		'expression', 
		'created_time', 
		'modified_time', 
		'description');

	/**
	 * ӹӶ
	 *
	 * @param array $fields
	 * @return boolean
	 */
	public function add($fields) {
		if (!$fields = $this->_filterStruct($fields)) return false;
		$sql = $this->_bindTable('INSERT INTO %s SET ') . $this->sqlSingle($fields);
		$statement = $this->getConnection()->createStatement($sql);
		$statement->execute();
		return $this->getConnection()->lastInsertId();
	}

	/**
	 * ӹչϢ, Ӱ
	 *
	 * @param array $fields
	 * @return int
	 */
	public function batchAdd($fields) {
		foreach ($fields as $key => $value) {
			$_tmp = array();
			$_tmp['app_id'] = $value['app_id'];
			$_tmp['app_name'] = $value['app_name'];
			$_tmp['hook_name'] = $value['hook_name'];
			$_tmp['alias'] = $value['alias'];
			$_tmp['class'] = $value['class'];
			$_tmp['method'] = $value['method'];
			$_tmp['loadway'] = $value['loadway'];
			$_tmp['expression'] = $value['expression'];
			$_tmp['created_time'] = intval($value['created_time']);
			$_tmp['modified_time'] = intval($value['modified_time']);
			$_tmp['description'] = $value['description'];
			$fields[$key] = $_tmp;
		}
		$sql = $this->_bindSql(
			'INSERT INTO %s (`app_id`, `app_name`, `hook_name`, `alias`, `class`, `method`, `loadway`, `expression`, `created_time`, `modified_time`, `description`) VALUES %s', 
			$this->getTable(), $this->sqlMulti($fields));
		return $this->getConnection()->createStatement($sql)->execute();
	}

	/**
	 * hhookӰ
	 *
	 * @param string $id
	 * @return int
	 */
	public function del($id) {
		$sql = $this->_bindTable('DELETE FROM %s WHERE id=?');
		return $this->getConnection()->createStatement($sql)->execute(array($id));
	}

	/**
	 * ݹɾӶ
	 *
	 * @param string $alias
	 * @return boolean
	 */
	public function delByAlias($alias) {
		$sql = $this->_bindTable('DELETE FROM %s WHERE alias=?');
		return $this->getConnection()->createStatement($sql)->execute(array($alias));
	}

	/**
	 * Inject idɾinjectorϢ
	 *
	 * @param array $ids
	 * @return Ambigous <rowCount, boolean, number>
	 */
	public function batchDelById($ids) {
		$sql = $this->_bindSql('DELETE FROM %s WHERE id IN %s', $this->getTable(), $this->sqlImplode($ids));
		return $this->getConnection()->createStatement($sql)->execute();
	}

	/**
	 * ݱɾinjector
	 *
	 * @param array $alias
	 * @return Ambigous <rowCount, boolean, number>
	 */
	public function batchDelByAlias($alias) {
		$sql = $this->_bindSql('DELETE FROM %s WHERE alias IN %s', $this->getTable(), $this->sqlImplode($alias));
		return $this->getConnection()->createStatement($sql)->execute();
	}

	/**
	 * HookNameɾinjector
	 *
	 * @param string $hookName
	 * @return Ambigous <rowCount, boolean, number>
	 */
	public function delByHookName($hookName) {
		$sql = $this->_bindTable('DELETE FROM %s WHERE hook_name=?');
		return $this->getConnection()->createStatement($sql)->execute(array($hookName));
	}

	/**
	 * HookNameɾinjector
	 *
	 * @param array $hookNames
	 * @return Ambigous <rowCount, boolean, number>
	 */
	public function batchDelByHookName($hookNames) {
		$sql = $this->_bindSql('DELETE FROM %s WHERE hook_name IN %s', $this->getTable(), $this->sqlImplode($hookNames));
		return $this->getConnection()->createStatement($sql)->execute();
	}

	/**
	 * ݹƺչɾһչ
	 *
	 * @param string $alias
	 * @param string $hookname
	 * @return Ambigous <rowCount, boolean, number>
	 */
	public function delByHookNameAndAlias($alias, $hookname) {
		$sql = $this->_bindSql('DELETE FROM %s WHERE hook_name=? AND alias=?', $this->getTable());
		return $this->getConnection()->createStatement($sql)->execute(array($hookname, $alias));
	}

	/**
	 * hook id £Ӱ
	 *
	 * @param string $id
	 * @param array $fields
	 * @return int
	 */
	public function update($id, $fields) {
		if (!$fields = $this->_filterStruct($fields)) return false;
		$sql = $this->_bindTable('UPDATE %s set ') . $this->sqlSingle($fields) . ' WHERE id=?';
		return $this->getConnection()->createStatement($sql)->execute(array($id));
	}

	/**
	 * IDhookעϢhook
	 *
	 * @param string $appId
	 * @return array
	 */
	public function find($id) {
		if (!$id) return false;
		$sql = $this->_bindTable('SELECT * FROM %s ') . ' WHERE id=?';
		return $this->getConnection()->createStatement($sql)->getOne(array($id));
	}
	
	/**
	 * idȡhook
	 *
	 * @param array $ids
	 * @return array
	 */
	public function fetch($ids) {
		return $this->_fetch($ids);
	}

	/**
	 * HookNameȡעб
	 *
	 * @param int $hookId
	 * @return array
	 */
	public function findByHookName($hookName) {
		$sql = $this->_bindTable('SELECT * FROM %s ') . ' WHERE hook_name=? ORDER BY `id`';
		return $this->getConnection()->createStatement($sql)->queryAll(array($hookName), 'alias');
	}
	
	/**
	 * HookNameȡעб
	 *
	 * @param int $hookId
	 * @return array
	 */
	public function fetchByHookName($hookNames) {
		$sql = $this->_bindSql('SELECT * FROM %s WHERE hook_name IN %s', $this->getTable(), $this->sqlImplode($hookNames));
		return $this->getConnection()->query($sql)->fetchAll('id');
	}

	/**
	 * ݱȡӦעб
	 *
	 * @param string $alias
	 * @return array
	 */
	public function findByAlias($alias) {
		$sql = $this->_bindTable('SELECT * FROM %s ') . ' WHERE alias=?';
		return $this->getConnection()->createStatement($sql)->queryAll(array($alias));
	}

	/**
	 * ݱע
	 *
	 * @param array $alias
	 * @return Ambigous <rowCount, boolean, number>
	 */
	public function batchFindByAlias($alias) {
		$sql = $this->_bindSql('SELECT * FROM %s WHERE alias IN %s', $this->getTable(), $this->sqlImplode($alias));
		return $this->getConnection()->createStatement($sql)->queryAll(array(), $this->_pk);
	}

	/**
	 * ҳҹϢ
	 *
	 * @param int $num ĬΪ10
	 * @param int $start
	 * @param int $index
	 * @param string $order
	 * @return boolean|Ambigous <multitype:, multitype:multitype: Ambigous <multitype:, multitype:unknown , mixed> >
	 */
	public function findByPage($num = 10, $start = 0, $index = 'id', $order = 'alias') {
		if (!in_array($order, $this->_dataStruct)) return false;
		$sql = $this->_bindSql('SELECT * FROM %s ORDER BY `' . $order . '` %s', $this->getTable(), 
			$this->sqlLimit($num, $start));
		return $this->getConnection()->createStatement($sql)->queryAll(array('style'), $index);
	}

	/**
	 * ȡ
	 *
	 * @return int
	 */
	public function count() {
		$sql = $this->_bindTable('SELECT COUNT(*) FROM %s');
		return $this->getConnection()->createStatement($sql)->getValue();
	}
	
	/**
	 * Ӧɾ
	 *
	 * @param string $appName
	 * @return Ambigous <rowCount, boolean, number>
	 */
	public function deleteByAppName($appName) {
		$sql = $this->_bindTable('DELETE FROM %s WHERE `app_name` = ?');
		return $this->getConnection()->createStatement($sql)->execute(array($appName));
	}
	
	/**
	 * Ӧidɾ
	 *
	 * @param string $appName
	 * @return Ambigous <rowCount, boolean, number>
	 */
	public function deleteByAppId($appid) {
		$sql = $this->_bindTable('DELETE FROM %s WHERE `app_id` = ?');
		return $this->getConnection()->createStatement($sql)->execute(array($appid));
	}
	
	/**
	 * appidȡӦעб
	 *
	 * @param string $appid
	 * @return array
	 */
	public function findByAppid($appid) {
		$sql = $this->_bindTable('SELECT * FROM %s ') . ' WHERE app_id=?';
		return $this->getConnection()->createStatement($sql)->queryAll(array($appid), $this->_pk);
	}
	
}

?>