<?php

/**
 * Ϣۺϱ
 *
 * @author peihong.zhang
 * @copyright 2003-2103 phpwind.com
 * @license http://www.phpwind.com
 * @version $Id: WindidMessageDialogDao.php 23820 2013-01-16 06:14:07Z jieyin $
 * @package forum
 */

class WindidMessageDialogDao extends WindidBaseDao {
	
	protected $_pk = 'dialog_id';
	protected $_table = 'message_dialog';
	protected $_dataStruct = array('dialog_id', 'to_uid', 'from_uid',  'unread_count', 'message_count','last_message', 'modified_time');
	
	/**
	 * ȡһ
	 * 
	 * @param int $dialogId
	 * @return array
	 */
	public function getDialog($dialogId) {
		return $this->_get($dialogId);
	}
	
	/**
	 * uidȡһ
	 * 
	 * @param int $toUid
	 * @param int $fromUid
	 * @return array
	 */
	public function getDialogByUid($toUid,$fromUid){
		$sql = $this->_bindSql('SELECT * FROM %s WHERE `to_uid`=? AND `from_uid`=?', $this->getTable());
		$smt = $this->getConnection()->createStatement($sql);
		return $smt->getOne(array($toUid,$fromUid));
	}
	
	/**
	 * ȡ
	 * 
	 * @param int $uid
	 * @param array $fromUids
	 * @return array
	 */
	public function getDialogByUids($uid,$fromUids) {
		$sql = $this->_bindSql('SELECT * FROM %s WHERE `to_uid`=? AND `from_uid` IN %s ', $this->getTable(), $this->sqlImplode($fromUids));
		$smt = $this->getConnection()->createStatement($sql);
		return $smt->queryAll(array($uid));
	}
	
	/**
	 * ȡδԻ
	 * 
	 * @param int $uid
	 * @param int $limit
	 * @return array
	 */
	public function getUnreadDialogsByUid($uid,$limit) {
		$sql = $this->_bindSql('SELECT * FROM %s WHERE `to_uid`=? AND `unread_count` > 0 ORDER BY `modified_time` DESC %s ', $this->getTable(), $this->sqlLimit($limit));
		$smt = $this->getConnection()->createStatement($sql);
		return $smt->queryAll(array($uid));
	}	
	
	/**
	 * Ϣۺ 
	 * 
	 * @param array $fields
	 * @return bool
	 */
	public function addDialog($fields) {
		if (!$fields = $this->_filterStruct($fields)) {
			return false;
		}
		$sql = $this->_bindSql('INSERT INTO %s SET %s ', $this->getTable(), $this->sqlSingle($fields));
		$this->getConnection()->execute($sql);
		return $this->getConnection()->lastInsertId();
	}
	
	/**
	 * ¶Ի
	 * 
	 * @param int $dialogId
	 * @param array $fields
	 * @param array $increaseFields
	 * @return bool
	 */
	public function updateDialog($dialogId,$fields = array(),$increaseFields = array()) {
		$fields = $this->_filterStruct($fields);
		$increaseFields = $this->_filterStruct($increaseFields);
		if (!$fields && !$increaseFields) {
			return false;
		}
		$sql = $this->_bindSql('UPDATE %s SET %s WHERE `dialog_id` =? ', $this->getTable(), $this->sqlMerge($fields, $increaseFields));
		$smt = $this->getConnection()->createStatement($sql);
		return $smt->update(array($dialogId));
	}
	
	/**
	 * ¶Ի
	 * 
	 * @param int $dialogId
	 * @param array $fields
	 * @param array $increaseFields
	 * @return bool
	 */
	public function batchUpdateDialog($dialogIds,$fields = array(),$increaseFields = array()) {
		$fields = $this->_filterStruct($fields);
		$increaseFields = $this->_filterStruct($increaseFields);
		if (!$fields && !$increaseFields) {
			return false;
		}
		$sql = $this->_bindSql('UPDATE %s SET %s WHERE `dialog_id` IN %s', $this->getTable(), $this->sqlMerge($fields, $increaseFields),$this->sqlImplode($dialogIds));
		$smt = $this->getConnection()->createStatement($sql);
		return $smt->update();
	}
	
	/**
	 * ͳû˽
	 * 
	 * @param int $uid
	 * @return array
	 */
	public function countUserMessages($uid) {
		$sql = $this->_bindTable('SELECT SUM(message_count) AS `count`,SUM(`unread_count`) AS `unreads` FROM %s WHERE `to_uid`=?');
		$smt = $this->getConnection()->createStatement($sql);
		return $smt->getOne(array($uid),PDO::FETCH_NUM);
	}
	
	/**
	 * ȡϢб
	 * 
	 * @param int $uid
	 * @param int $from_uid
	 * @return int
	 */
	public function countDialogs($uid) {
		$sql = $this->_bindTable('SELECT COUNT(*) FROM %s WHERE to_uid=?');
		$smt = $this->getConnection()->createStatement($sql);
		return $smt->getValue(array($uid));
	}
	
	/**
	 * Ϣб
	 *
	 * @param int $uid 
	 * @param int $start
	 * @param int $limit
	 * @return array
	 */
	public function getDialogs($uid,$start,$limit){
		$sql = $this->_bindSql('SELECT * FROM %s WHERE to_uid=? ORDER BY modified_time DESC %s ', $this->getTable(), $this->sqlLimit($limit,$start));
		$smt = $this->getConnection()->createStatement($sql);
		return $smt->queryAll(array($uid));
	}
	
	public function getDialogIds($uid){
		$sql = $this->_bindSql('SELECT dialog_id FROM %s WHERE to_uid=?', $this->getTable());
		$smt = $this->getConnection()->createStatement($sql);
		return $smt->queryAll(array($uid));
	}
	
	public function fetchDialogByDialogIds($dialogIds){
		return $this->_fetch($dialogIds,'dialog_id');
	}
	
	public function deleteDialog($dialogId) {
		return $this->_delete($dialogId);
	}
	
	public function batchDeleteDialog($dialogIds){
		return $this->_batchDelete($dialogIds);
	}
	
}