<?php
Wind::import('WSRV:user.error.WindidUserError');

/**
 * ûϢdata service
 * 
 * @author xiaoxia.xu <xiaoxia.xuxx@aliyun-inc.com> 2010-11-2
 * @license http://www.phpwind.com
 * @version $Id: WindidUser.php 24398 2013-01-30 02:45:05Z jieyin $
 * @package windid.service.user
 */
class WindidUser {

	const FETCH_MAIN = 1; //ȡûϢ
	const FETCH_DATA = 2; //ȡû
	const FETCH_INFO = 4; //ȡû
	const FETCH_ALL = 7; //ȡȫ
	
	/**
	 * ͨûuidȡûϢ
	 *
	 * @param int $uid ûuid
	 * @param int $type ûϢͣĬΪ1<pre>
	 * ܴ17֣֮1ȡmain2ȡinfo4ȡcreditʣ3567ֱ124</pre>
	 * @return array
	 */
	public function getUserByUid($uid, $type = self::FETCH_MAIN) {
		if (empty($uid)) return array();
		return $this->_getDao($type)->getUserByUid($uid);
	}

	/**
	 * ͨûȡûϢ
	 *
	 * @param string $username û
	 * @param int $type ûϢͣĬΪ1<pre>
	 * ܴ17֣֮1ȡmain2ȡinfo4ȡcreditʣ3567ֱ124</pre>
	 * @return array
	 */
	public function getUserByName($username, $type = self::FETCH_MAIN) {
		if (empty($username)) return array();
		return $this->_getDao($type)->getUserByName($username);
	}

	/**
	 * ͨȡûϢ
	 *
	 * @param string $email 
	 * @param int $type ûϢͣĬΪ1<pre>
	 * ܴ17֣֮1ȡmain2ȡinfo4ȡcreditʣ3567ֱ124</pre>
	 * @return array
	 */
	public function getUserByEmail($email, $type = self::FETCH_MAIN) {
		if (empty($email)) return array();
		return $this->_getDao($type)->getUserByEmail($email);
	}

	/**
	 * ͨûuidsȡûϢ
	 *
	 * @param array $uids ûuids
	 * @param int $type ûϢͣĬΪ1<pre>
	 * ܴ17֣֮1ȡmain2ȡinfo4ȡcreditʣ3567ֱ124</pre>
	 * @return array
	 */
	public function fetchUserByUid($uids, $type = self::FETCH_MAIN) {
		if (!($uids = $this->_filterIds($uids))) return array();
		return $this->_getDao($type)->fetchUserByUid($uids);
	}

	/**
	 * ͨûȡûϢ
	 *
	 * @param array $usernames û
	 * @param int $type ûϢͣĬΪ1<pre>
	 * ܴ17֣֮1ȡmain2ȡinfo4ȡcreditʣ3567ֱ124</pre>
	 * @return array
	 */
	public function fetchUserByName($usernames, $type = self::FETCH_MAIN) {
		if (empty($usernames)) return array();
		return $this->_getDao($type)->fetchUserByName($usernames);
	}
	
	public function searchUser(WindidUserSo $vo, $limit = 10, $start = 0) {
		return $this->_getSearchDao()->searchUserAllData($vo->getData(), $limit, $start, $vo->getOrderby());
	}
	
	public function countSearchUser(WindidUserSo $vo) {
		return $this->_getSearchDao()->countSearchUser($vo->getData());
	}

	/**
	 * һû
	 *
	 * @param WindidUserDm $dm û
	 * @param int $type û
	 * @return int|bool ûעuid|ʧʱfalse
	 */
	public function addUser(WindidUserDm $dm) {
		if (($check = $dm->beforeAdd()) !== true) return $check;
		return $this->_getDao(self::FETCH_ALL)->addUser($dm->getData());
	}

	/**
	 * ûϢ
	 *
	 * @param int $uid ûID
	 * @param WindidUserDm $dm û
	 * @return int|bool ûעuid|ʧʱfalse
	 */
	public function editUser(WindidUserDm $dm) {
		if (($check = $dm->beforeUpdate()) !== true) return $check;
		return $this->_getDao(self::FETCH_ALL)->editUser($dm->uid, $dm->getData(), $dm->getIncreaseData());
	}
	
	/**
	 * ûϢ
	 *
	 * @param WindidUserDm $dm û
	 * @return int|bool ûעuid|ʧʱfalse
	 */
	public function updateCredit(WindidCreditDm $dm) {
		if (($check = $dm->beforeUpdate()) !== true) return false;
		return $this->_getDao(self::FETCH_DATA)->updateCredit($dm->uid, $dm->getData(), $dm->getIncreaseData());
	}
	
	/**
	 * ȡûϢ
	 *
	 * @param int $uid
	 * @return array
	 */
	public function getCredit($uid) {
		return $this->_getDao(self::FETCH_DATA)->getCredit($uid);
	}

	/**
	 * ɾû
	 *
	 * @param int $uid ûuid
	 * @return bool true|false
	 */
	public function deleteUser($uid) {
		if (empty($uid)) return false;
		return $this->_getDao(self::FETCH_ALL)->deleteUser($uid);
	}

	/**
	 * ɾû
	 *
	 * @param array $uid ûuid
	 * @return bool true|false
	 */
	public function batchDeleteUser($uids) {
		if (!($uids = $this->_filterIds($uids))) return false;
		return $this->_getDao(self::FETCH_ALL)->batchDeleteUser($uids);
	}
	
	public function getCreditStruct() {
		$struct = $this->_getDao(self::FETCH_DATA)->getStruct();
		$credit = array();
		foreach ($struct as $_key) {
			if (strpos($_key, 'credit') === 0) $credit[] = $_key;
		}
		return $credit;
	}
	
	/**
	 * ûdatacreditֶ
	 *
	 * @param int $num
	 * @return boolean
	 */
	public function alterAddCredit($num) {
		$num = intval($num);
		return $num < 9 ? false : $this->_getDao(self::FETCH_DATA)->alterAddCredit($num);
	}
	
	/**
	 * ɾûֶΣ1-8ɾ
	 *
	 * @param int $num
	 * @return boolean
	 */
	public function alterDropCredit($num) {
		$num = intval($num);
		return $num < 9 ? false : $this->_getDao(self::FETCH_DATA)->alterDropCredit($num);
	}
	
	/**
	 * ûֵĳһ
	 *
	 * @param int $num
	 * @return boolean
	 */
	public function clearCredit($num) {
		$num = intval($num);
		return ($num > 8 || $num < 1) ? false : $this->_getDao(self::FETCH_DATA)->clearCredit($num);
	}

	/**
	 * idб
	 *
	 * @param array|int $id idб
	 * @return array
	 */
	private function _filterIds($id) {
		!is_array($id) && $id = array($id);
		$clearIds = array();
		foreach ($id as $item) {
			if (WindValidator::isPositive($item)) $clearIds[] = $item;
		}
		return $clearIds;
	}

	/**
	 * ṩĻȡͻȡӦdao
	 *
	 * @param int $type װֵ
	 * @return WindidUserInterface
	 */
	private function _getDao($type = self::FETCH_MAIN) {
		if (!($type & self::FETCH_ALL)) return Wekit::loadDao('WSRV:user.dao.WindidUserDefaultDao');
		$maps = array(
			self::FETCH_MAIN => 'WSRV:user.dao.WindidUserDao',
			self::FETCH_DATA => 'WSRV:user.dao.WindidUserDataDao',
			self::FETCH_INFO => 'WSRV:user.dao.WindidUserInfoDao'
		);
		return Wekit::loadDaoFromMap($type, $maps, 'WindidUser');
	}
	
	private function _getSearchDao() {
		return Wekit::loadDao('WSRV:user.dao.WindidUserSearchDao');
	}
}