<?php
/**
 * ǰ˿
 * ʼϵͳϢ,ʼӦʵȡϵͳáãн
 * 
 * @author Qiong Wu <papa0924@gmail.com> 2011-12-27
 * @copyright 2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $$Id$$
 * @package base
 */
abstract class AbstractWindFrontController {
	/**
	 * Ӧ
	 * 
	 * @var WindHttpResponse
	 */
	protected $_response = null;
	/**
	 * 
	 * 
	 * @var WindHttpRequest
	 */
	protected $_request = null;
	/**
	 * ʵ
	 * 
	 * @var WindFactory
	 */
	protected $_factory = null;
	/**
	 * Ӧ
	 * 
	 * @var array
	 */
	protected $_config = array(
		'isclosed' => false, 
		'web-apps' => array(
			'default' => array(
				'error-dir' => 'WIND:web.view', 
				'compress' => true, 
				'root-path' => '', 
				'charset' => 'utf-8', 
				'modules' => array(
					'default' => array(
						'controller-path' => 'controller', 
						'controller-suffix' => 'Controller', 
						'error-handler' => 'WIND:web.WindErrorHandler')))), 
		'components' => array());
	/**
	 * ǰapp
	 * 
	 * @var string
	 */
	protected $_appName = 'default';
	/**
	 * Ӧö
	 * 
	 * @var WindWebApplication
	 */
	protected $_app = null;
	/**
	 *
	 * @var WindHandlerInterceptorChain
	 */
	private $_chain = null;

	/**
	 *
	 * @param string $appName
	 *        Ĭapp
	 * @param Array|string $config
	 *        ӦϢ,֧ΪջӦ
	 */
	public function __construct($appName, $config) {
		$appName && $this->_appName = $appName;
		$this->init($config);
	}

	/**
	 * Ԥϵͳļ,Ԥϵͳļ
	 * Ԥϵͳļʽ£ֵΪ=>ֵΪincludePathԵģincludePathѾ˸õַ
	 * ҲǾԵַwindռʽĵַ<pre>
	 * return array(
	 * 'WindController' => 'web/WindController',
	 * 'WindDispatcher' => 'web/WindDispatcher'
	 * </pre>
	 * 
	 * @return void
	 * @return array
	 */
	abstract protected function _loadBaseLib();

	/**
	 * 齨Ϣ
	 * ñǩ˵
	 * name: ֣ΨһӦлȡӦĶʵ
	 * path: ʵ
	 * scope: ķΧ {singleton: ; application: Ӧã prototype: ǰʹ}
	 * initMethod: Ӧöʱִеķ
	 * destroy ӦýʱִеĲ
	 * proxy Ƿôķʽ
	 * constructor-args췽Ĳ
	 * constructor-arg
	 * nameλ,ʼλô0ʼһΪ0ڶΪ1
	 * ֵıʾʽһ¼֣
	 * ref: һrefֵӦ
	 * value: һִֵ
	 * path: pathָʵᱻݸ
	 * properties: ԵãΪе
	 * property:
	 * name:
	 * ֵıʾʽ¼֣
	 * ref: һrefֵӦ֣ΪлȡʽΪ_get+()ȡ
	 * value: һִֵ
	 * path: pathָʵᱻݸ
	 * config -ֵӦûͨsetConfigӿڴݸ
	 * resource: ָһⲿַȥļ
	 * 
	 * @return array()
	 */
	abstract protected function _components();

	/**
	 * ʼӦ
	 * 
	 * @param array $config
	 *        ǰӦϢ
	 * @param WindFactory $factory        
	 * @return WindWebApplication
	 */
	abstract protected function createApplication($config, $factory);

	/**
	 * ʼǰ˿
	 * <ul>
	 * <li>ʼӦ<li>
	 * <li>ӵϵͳʼ</li>
	 * <li>ʼ齨齨齨ΪϵͳúԶ</li>
	 * <li>ʼӦøĿ¼</li>
	 * </ul>
	 * 
	 * @param array|string $config
	 *        Ӧ
	 */
	protected function init($config) {
		$factory = WindFactory::_getInstance();
		$factory->setClassDefinitions($this->_components());
		$this->_loadBaseLib();
		$this->_initConfig($config, $factory);
		if (!empty($this->_config['components'])) {
			if (!empty($this->_config['components']['resource'])) {
				$this->_config['components'] += $factory->getInstance('configParser')->parse(
					Wind::getRealPath($this->_config['components']['resource'], true, true));
			}
			$factory->loadClassDefinitions($this->_config['components']);
		}
		$rootPath = empty($this->_config['web-apps'][$this->_appName]['root-path']) ? dirname(
			$_SERVER['SCRIPT_FILENAME']) : Wind::getRealPath(
			$this->_config['web-apps'][$this->_appName]['root-path'], false);
		Wind::register($rootPath, $this->_appName, true);
		
		if ($this->_appName === 'default') {} elseif (isset(
			$this->_config['web-apps'][$this->_appName])) {
			$this->_config['web-apps'][$this->_appName] = WindUtility::mergeArray(
				$this->_config['web-apps']['default'], $this->_config['web-apps'][$this->_appName]);
		} else
			throw new WindException(
				'Your requested application \'' . $this->_appName . '\' was not found on this server, please check your application configuration.', 
				WindException::ERROR_SYSTEM_ERROR);
	}

	/**
	 * ʼϢ
	 * 
	 * @param array|string $config        
	 * @param WindFactory $factory        
	 */
	protected function _initConfig($config, $factory) {
		if (!$config) return;
		if (is_string($config)) {
			$config = $factory->getInstance('configParser')->parse($config);
		}
		$this->_config = WindUtility::mergeArray($this->_config, $config);
	}

	/**
	 * ִеǰӦ,Ӧ÷
	 */
	public function run() {
		$this->_app = $this->createApplication($this->_config['web-apps'][$this->_appName], 
			WindFactory::_getInstance());
		
		set_error_handler(array($this, '_errorHandle'), error_reporting());
		set_exception_handler(array($this, '_exceptionHandle'));
		if ($this->_config['isclosed']) {
			throw new Exception('Sorry, Site has been closed!');
		}
		if ($this->_chain !== null) $this->_chain->getHandler()->handle('onCreate');
		/* @var $router WindRouter */
		$router = $this->_app->getFactory()->getInstance('router');
		$router->route($this->_app->getRequest());
		
		if ($this->_chain !== null) $this->_chain->getHandler()->handle('onStart');
		$this->_app->run($router);
		
		if ($this->_chain !== null) $this->_chain->getHandler()->handle('onResponse');
		$this->_app->getResponse()->sendResponse();
		$this->_app->getFactory()->executeDestroyMethod();
		restore_error_handler();
		restore_exception_handler();
	}

	/**
	 * ע,Application Run
	 * 
	 * @param WindHandlerInterceptor $filter        
	 */
	public function registeFilter($filter) {
		if ($this->_chain === null) {
			Wind::import("WIND:filter.WindHandlerInterceptorChain");
			$this->_chain = new WindHandlerInterceptorChain();
		}
		if ($filter instanceof AbstractWindBootstrap) {
			$this->_chain->addInterceptors($filter);
		}
	}

	/**
	 * 
	 * 
	 * @param int $errno        
	 * @param string $errstr        
	 * @param string $errfile        
	 * @param int $errline        
	 */
	public function _errorHandle($errno, $errstr, $errfile, $errline) {
		if (0 === error_reporting()) return;
		restore_error_handler();
		/* @var $error WindError */
		$error = $this->_app->getFactory()->getInstance('error', 
			array(
				$this->_config['web-apps'][$this->_appName]['error-dir'], 
				$this->_config['isclosed']));
		$error->errorHandle($errno, $errstr, $errfile, $errline);
	}

	/**
	 * Exception
	 *
	 * @param Exception $exception
	 */
	public function _exceptionHandle($exception) {
		restore_exception_handler();
		/* @var $error WindError */
		$error = $this->_app->getFactory()->getInstance('error', 
			array(
				$this->_config['web-apps'][$this->_appName]['error-dir'], 
				$this->_config['isclosed']));
		$error->exceptionHandle($exception);
	}

	/**
	 * ȡӦ
	 * <i>configName</i>Ϊʱ򷵻.ֵʱĬֵ.ĬֵĬΪ
	 * 
	 * @param string $configName 
	 * @param string $subConfigName 
	 * @param string $default Ĭֵ
	 * @param array $config ⲿ
	 * @return mixed
	 */
	public function getConfig($configName = '', $subConfigName = '', $default = '') {
		if ($configName === '') return $this->_config;
		if (!isset($this->_config[$configName])) return $default;
		if ($subConfigName === '') return $this->_config[$configName];
		if (!isset($this->_config[$configName][$subConfigName])) return $default;
		return $this->_config[$configName][$subConfigName];
	}

	/**
	 * صǰappӦ
	 * 
	 * @return string
	 */
	public function getAppName() {
		return $this->_appName;
	}

	/**
	 * صǰappӦ
	 * 
	 * @param string $appName        
	 * @return WindWebApplication
	 */
	public function getApp() {
		return $this->_app;
	}
}
?>