<?php
/**
 * ֤
 * 
 * ע룺֤/쳣
 *
 * @author Qiong Wu <papa0924@gmail.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id: WindEnableValidateModule.php 3904 2013-01-08 07:01:26Z yishuo $
 * @package base
 */
class WindEnableValidateModule {
	/**
	 * ֤
	 *
	 * @var string
	 */
	protected $_validatorClass = 'WIND:utility.WindValidator';
	/**
	 * action
	 *
	 * @var string
	 */
	protected $errorAction = '';
	/**
	 * ֤ʵ
	 *
	 * @var WindValidator
	 */
	private $_validator = null;
	/**
	 * ֤вĴϢ
	 *
	 * @var array
	 */
	protected $_errors = array();
	/**
	 * ֤вϢʱʹõĬϴϢ
	 *
	 * @var string
	 */
	private $_defaultMessage = 'the field validate fail.';

	/**
	 * ֤вĴϢ
	 * 
	 * @return array $_errors
	 */
	public function getErrors() {
		return $this->_errors;
	}

	/**
	 * ֤ʱʹõĴerrorAction
	 * 
	 * errorActionĸʽ/ָm,c,a:ķʽΪm/c/a
	 *
	 * @return string
	 */
	public function getErrorAction() {
		return $this->errorAction;
	}

	/**
	 * ֤ɵ
	 * 
	 * ÿһ֤Ҫ¸ʽ:
	 * <code>
	 * 	array(
	 * 		'field' => 'name',	//ֶ֤
	 * 		'default' => 'test',	//ֶΪ
	 * 		'args' => array('args1', 'args2'),	//validator֤ܵ(ڱ֤ĺ)
	 * 		'validator' => 'isEmpty',	//ִе֤(÷$_validatorClassָ֤дڲɹʣҸ÷boolean)
	 * 		'message' => 'name is empty',	//֤ʧʱصĴϢ
	 * 	)
	 * </code>
	 * ֤Բ{@link WindUtility::buildValidateRule()}й.
	 * 
	 * @return array
	 */
	protected function validateRules() {
		return array();
	}
	
	/**
	 * ֤
	 * 
	 * @return void
	 */
	public function validate() {
		$rules = $this->validateRules();
		$methods = get_class_methods($this);
		foreach ((array) $rules as $rule) {
			$getMethod = 'get' . ucfirst($rule['field']);
			$_input = in_array($getMethod, $methods) ? call_user_func(array($this, $getMethod)) : '';
			if (true === $this->check($_input, $rule)) continue;
			$setMethod = 'set' . ucfirst($rule['field']);
			in_array($setMethod, $methods) && call_user_func_array(array($this, $setMethod), array($rule['default']));
		}
	}
	
	/**
	 * ִrule֤
	 *
	 * @param string $input ֤
	 * @param array $rule ֤Ĺ
	 * @return boolean ֤ɹtrue,֤ʧܷfalse
	 */
	private function check($input, $rule) {
		$arg = (array) $rule['args'];
		array_unshift($arg, $input);
		if (call_user_func_array(array($this->getValidator(), $rule['validator']), $arg) !== false) return true;
		if ($rule['default'] === null) {
			$this->_errors[$rule['field']] = $rule['message'];
			return true;
		}
		return false;
	}

	/**
	 * ֤
	 * 
	 * @return WindValidator
	 * @throws WindException ֤ʧ׳쳣
	 */
	protected function getValidator() {
		if ($this->_validator === null) {
			$_className = Wind::import($this->_validatorClass);
			$this->_validator = WindFactory::createInstance($_className);
			if ($this->_validator === null) throw new WindException('[base.WindEnableValidateModule.getValidator] validator', WindException::ERROR_RETURN_TYPE_ERROR);
		}
		return $this->_validator;
	}
}