<?php
/**
 * Ϣ
 * 
 * Ϣ,ʵ'IWindErrorMessage'ӿ,ӵͨõĴ洢.
 * ڴ˻ϸ໹Էʹ,Զ.
 * @author Qiong Wu <papa0924@gmail.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id: WindErrorMessage.php 3264 2011-12-20 09:01:40Z yishuo $
 * @package base
 */
class WindErrorMessage extends WindModule implements IWindErrorMessage {
	/**
	 * ڴ洢Ϣ
	 * 
	 * @var array
	 */
	private $error = array();
	/**
	 * ڴǰaction
	 * 
	 * ڴǰaction,ֵΪʱ,ϵͳԶĬϴ,ͨøıĬϵĴ
	 * @var string
	 */
	private $errorAction;

	/**
	 * @param string $message Ϣ ĬΪ
	 * @param string $errorAction ڴǰAction ĬΪ
	 */
	public function __construct($message = '', $errorAction = '') {
		$message !== '' && $this->addError($message);
		$errorAction !== '' && $this->setErrorAction($errorAction);
	}

	/* (non-PHPdoc)
	 * @see IWindErrorMessage::sendError()
	 */
	public function sendError($message = '') {
		if ($message)
			$this->addError($message);
		elseif (empty($this->error))
			return;
		throw new WindActionException($this);
	}

	/* (non-PHPdoc)
	 * @see IWindErrorMessage::clearError()
	 */
	public function clearError() {
		$this->error = array();
	}

	/* (non-PHPdoc)
	 * @see IWindErrorMessage::getError()
	 */
	public function getError($key = '') {
		if ($key === '') return $this->error;
		return isset($this->error[$key]) ? $this->error[$key] : '';
	}

	/* (non-PHPdoc)
	 * @see IWindErrorMessage::addError()
	 */
	public function addError($error, $key = '') {
		if ($key === '')
			$this->error[] = $error;
		else
			$this->error[$key] = $error;
	}

	/**
	 * ڴǰaction
	 * 
	 * @return string
	 */
	public function getErrorAction() {
		return $this->errorAction;
	}

	/**
	 * ڴǰaction
	 * 
	 * <i>$errorAction</i>ֵ֧ʽ<code>/module/controller/action/?args</code>
	 * @param string $errorAction
	 * @return void
	 */
	public function setErrorAction($errorAction) {
		$this->errorAction = $errorAction;
	}
}

/**
 * Ϣӿڶ
 * 
 * the last known user to change this file in the repository  <$LastChangedBy: yishuo $>
 * @author Qiong Wu <papa0924@gmail.com>
 * @version $Id: WindErrorMessage.php 3264 2011-12-20 09:01:40Z yishuo $
 * @package 
 */
interface IWindErrorMessage {

	/**
	 * һϢ
	 * 
	 * һϢ,ɴ洢Ϣ,鷽ʽ洢Ϣ,keyֵΪʱ,ϢΪȻ
	 * @param string $message Ϣ
	 * @param string $key keyֵ ĬΪ
	 */
	public function addError($message, $key = '');

	/**
	 * شϢ
	 * 
	 * شϢ,keyΪʱ,ȫĴϢ
	 * @param string $key
	 * @return string|array
	 */
	public function getError($key = '');

	/**
	 * յǰеȫϢ
	 * 
	 * @return void
	 */
	public function clearError();

	/**
	 * ʹϢ
	 * 
	 * @return void
	 * @throws WindActionException
	 */
	public function sendError();
}