<?php
/**
 * ͨ쳣,󲿷쳣Ǽ̳Ը쳣
 * 
 * @author Qiong Wu <papa0924@gmail.com> 2011-10-8
 * @copyright 2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id: WindException.php 3904 2013-01-08 07:01:26Z yishuo $
 * @package base
 */
class WindException extends Exception {
	/* ϵͳ */
	const ERROR_SYSTEM_ERROR = '0';
	/*  */
	const ERROR_CLASS_NOT_EXIST = '1100';
	const ERROR_CLASS_TYPE_ERROR = '1101';
	const ERROR_CLASS_METHOD_NOT_EXIST = '1102';
	const ERROR_OBJECT_NOT_EXIST = '1103';
	/*  */
	const ERROR_PARAMETER_TYPE_ERROR = '1110';
	/* ô */
	const ERROR_CONFIG_ERROR = '1120';
	/* ֵʹ */
	const ERROR_RETURN_TYPE_ERROR = '1130';

	/**
	 * 쳣캯
	 * 
	 * @param $message		     쳣Ϣ
	 * @param $code			     쳣 ĬΪ0
	 * @param $innerException ڲ쳣 ĬΪnull
	 */
	public function __construct($message, $code = 0) {
		$message = $this->buildMessage($message, $code);
		parent::__construct($message, $code);
	}

	/**
	 * exception codeع쳣Ϣ
	 * 
	 * @param string $message ûԶϢ
	 * @param int $code  쳣
	 * @return string װ쳣Ϣ
	 */
	public function buildMessage($message, $code) {
		$message = str_replace(array("<br />", "<br>", "\r\n"), '', $message);
		$_message = $this->messageMapper($code);
		return $_message ? str_replace('$message', $message, $_message) : $message;
	}

	/**
	 * Զ쳣ŵĶӦ쳣Ϣ
	 * 
	 * @param int $code 쳣
	 * @return string 쳣ŶӦ쳣װϢԭ
	 */
	protected function messageMapper($code) {
		$messages = array(
			self::ERROR_SYSTEM_ERROR => 'System error \'$message\'.', 
			self::ERROR_CLASS_TYPE_ERROR => 'Incorrect class type \'$message\'.', 
			self::ERROR_CLASS_NOT_EXIST => 'Unable to create instance for \'$message\' , class is not exist.', 
			self::ERROR_CLASS_METHOD_NOT_EXIST => 'Unable to access the method \'$message\' in current class , the method is not exist or is protected.', 
			self::ERROR_OBJECT_NOT_EXIST => 'Unable to access the object in current class \'$message\' ', 
			self::ERROR_CONFIG_ERROR => 'Incorrect config. the config about \'$message\' error.', 
			self::ERROR_PARAMETER_TYPE_ERROR => 'Incorrect parameter type \'$message\'.', 
			self::ERROR_RETURN_TYPE_ERROR => 'Incorrect return type for \'$message\'.');
		return isset($messages[$code]) ? $messages[$code] : '';
	}
}