<?php
/**
 * 
 * ְ:òԼ.ͨķʽ,Ĵ,ͳһĹӿڲҾкܺõĿչ.
 * ÷ʽ<code>
 * <component name='' path='' factory-method='' init-method=''
 * scope="application/singleton/prototype/" proxy='' destroy=''>
 * <property property-name='' ref/value/path=''>
 * <constructor-arg ref/value=''>
 * <config resource=''>
 * </component></code>ֶ֧ı,·,,ʼ,,Ƿ,,ֵ,,Լý.
 * 
 * @author Qiong Wu <papa0924@gmail.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id: WindFactory.php 3914 2013-01-23 03:07:17Z yishuo $
 * @package base
 */
class WindFactory {
	protected $proxyType = 'WIND:filter.proxy.WindClassProxy';
	protected $classDefinitions = array();
	protected $instances = array();
	protected $prototype = array();
	protected $destories = array();
	protected $singleton = array();
	private static $_instance = null;

	/**
	 * ʼ
	 * 
	 * @param array $classDefinitions
	 *         ĬֵΪ
	 */
	private function __construct() {}
	
	/*
	 * (non-PHPdoc) @see IWindFactory::getInstance()
	 */
	public function getInstance($alias, $args = array()) {
		$instance = null;
		$definition = isset($this->classDefinitions[$alias]) ? $this->classDefinitions[$alias] : array();
		if (isset($this->prototype[$alias])) {
			$instance = clone $this->prototype[$alias];
			if (isset($definition['destroy'])) $this->destories[] = array($instance, $definition['destroy']);
		} elseif (isset($this->instances[$alias])) {
			$instance = $this->instances[$alias];
		} elseif (isset($this->singleton[$alias])) {
			$instance = $this->singleton[$alias];
		} else {
			if (!$definition) return null;
			$_unscope = empty($args);
			if (isset($definition['constructor-args']) && $_unscope) $this->buildArgs($definition['constructor-args'], 
				$args);
			if (!isset($definition['className'])) $definition['className'] = Wind::import(@$definition['path']);
			$instance = $this->createInstance($definition['className'], $args);
			if (isset($definition['config'])) $this->resolveConfig($definition['config'], $alias, $instance);
			if (isset($definition['properties'])) $this->buildProperties($definition['properties'], $instance);
			if (isset($definition['initMethod'])) $this->executeInitMethod($definition['initMethod'], $instance);
			!isset($definition['scope']) && $definition['scope'] = 'application';
			$_unscope && $this->setScope($alias, $definition['scope'], $instance);
			if (isset($definition['destroy'])) $this->destories[$alias] = array($instance, $definition['destroy']);
		}
		if (isset($definition['proxy'])) {
			$listeners = isset($definition['listeners']) ? $definition['listeners'] : array();
			$instance = $this->setProxyForClass($definition['proxy'], $listeners, $instance);
		}
		return $instance;
	}
	
	/*
	 * (non-PHPdoc) @see IWindFactory::createInstance()
	 */
	static public function createInstance($className, $args = array()) {
		try {
			if (empty($args)) {
				return new $className();
			} else {
				$reflection = new ReflectionClass($className);
				return call_user_func_array(array($reflection, 'newInstance'), (array) $args);
			}
		} catch (Exception $e) {
			throw new WindException('[base.WindFactory] create instance \'' . $className . '\' fail.' . $e->getMessage(), 
				WindException::ERROR_CLASS_NOT_EXIST);
		}
	}

	/**
	 * ע,Ѿ򸲸ԭֵ
	 * 
	 * @param object $instance        
	 * @param string $alias        
	 * @param string $scope
	 *         ĬΪ'singleton'
	 * @return boolean
	 */
	public function registInstance($instance, $alias, $scope = 'singleton') {
		return $this->setScope($alias, $scope, $instance);
	}

	/**
	 * ̬
	 * 
	 * @param string $alias        
	 * @param array $classDefinition        
	 * @return void
	 * @throws WindException
	 */
	public function addClassDefinitions($alias, $classDefinition) {
		if (is_string($alias) && !empty($alias)) {
			if (!isset($this->classDefinitions[$alias])) $this->classDefinitions[$alias] = $classDefinition;
		} else
			throw new WindException('[base.WindFactory.addClassDefinitions] class alias is empty.', 
				WindException::ERROR_PARAMETER_TYPE_ERROR);
	}

	/**
	 * ඨ
	 * ø÷,mergeΪtrue,򸲸ԭϢ.
	 * 
	 * @param array $classDefinitions        
	 * @param boolean $merge
	 *        Ƿmerge,ĬΪtrue
	 * @return void
	 */
	public function loadClassDefinitions($classDefinitions, $merge = true) {
		foreach ((array) $classDefinitions as $alias => $definition) {
			if (!is_array($definition)) continue;
			if (isset($this->instances[$alias]) || isset($this->prototype[$alias])) continue;
			if (!isset($this->classDefinitions[$alias]) || $merge === false)
				$this->classDefinitions[$alias] = $definition;
			else
				$this->classDefinitions[$alias] = WindUtility::mergeArray($this->classDefinitions[$alias], $definition);
		}
	}

	/**
	 * ඨ
	 * ͨ÷ûḲԭඨ壬ע÷{@see loadClassDefinitions}
	 * 
	 * @param array $classDefinitions        
	 */
	public function setClassDefinitions($classDefinitions) {
		$this->classDefinitions = $classDefinitions;
	}

	/**
	 * 
	 * ඨǷѾ,ǷѾ.ظע
	 * 
	 * @param string $alias        
	 * @return boolean
	 */
	public function checkAlias($alias) {
		if (isset($this->prototype[$alias]))
			return true;
		elseif (isset($this->instances[$alias]))
			return true;
		return false;
	}

	/**
	 * ִע
	 * ȫע,Ķ˳ε,Ķ巽<code><component
	 * destroy=''>...</component></code>
	 * ÷Ӧýʱͳһ.
	 * 
	 * @return void
	 * @throws WindException
	 */
	public function executeDestroyMethod() {
		try {
			foreach ($this->destories as $call)
				call_user_func_array($call, array());
			$this->instances = array();
			$this->destories = array();
		} catch (Exception $e) {
			throw new WindException($e->getMessage());
		}
	}

	/**
	 * 췽Ϣ,زб
	 * ÷췽ĲϢ,ص<code><constructor-args>
	 * <constructor-arg name='0' value='DATA:log' />
	 * <constructor-arg name='1' value='2' />
	 * </constructor-args></code>ضͬpropertiesͬ.'name'Ϊλ,ɵĲб'name'һ.
	 * 
	 * @param array $constructors        
	 * @param array $args        
	 * @return void
	 */
	protected function buildArgs($constructors, &$args) {
		foreach ((array) $constructors as $key => $_var) {
			$key = intval($key);
			if (isset($_var['value'])) {
				$args[$key] = $_var['value'];
			} elseif (isset($_var['ref']))
				$args[$key] = $this->getInstance($_var['ref']);
			elseif (isset($_var['path'])) {
				$_className = Wind::import($_var['path']);
				$args[$key] = $this->createInstance($_className);
			}
		}
		ksort($args);
	}

	/**
	 * 
	 * ,Ŀǰֵ֧Ϊ'prototype','application','singleton',ĬΪ'application'.
	 * 巽ʽ<code><component scope=''>...</component></code>
	 * 
	 * @param string $alias        
	 * @param string $scope        
	 * @param WindModule $instance        
	 * @return boolean
	 */
	protected function setScope($alias, $scope, $instance) {
		switch ($scope) {
			case 'prototype':
				$this->prototype[$alias] = clone $instance;
				break;
			case 'application':
				$this->instances[$alias] = $instance;
				break;
			case 'singleton':
				$this->singleton[$alias] = $instance;
				break;
			default:
				break;
		}
		return true;
	}

	/**
	 * 
	 * òϢý,ĬϵwindCacheԽû洦,ͨ'isCache'رϵͳ.
	 * ö<code><component ...><config
	 * resource=''>...</config></component></code>,
	 * ͨ'resource'ⲿ(֧ռ䷽ʽ·ַ),Ҳֱӽö嵽configǩ.
	 * 
	 * @param array|string $config        
	 * @param string $alias        
	 * @param WindModule $instance        
	 * @return void
	 */
	protected function resolveConfig($config, $alias, $instance) {
		if (!empty($config['resource'])) {
			$_configPath = Wind::getRealPath($config['resource'], true, true);
			$config = $this->getInstance('configParser')->parse($_configPath, $alias, 'components_config', 
				(!empty($this->instances['windCache']) ? $this->instances['windCache'] : null));
		}
		if ($config && method_exists($instance, 'setConfig')) $instance->setConfig($config);
	}

	/**
	 * ִĳʼ
	 * ĳʼ<code><component init-method=''>...</component></code>
	 * 
	 * @param string $initMethod        
	 * @param object $instance        
	 * @return mixed
	 * @throws WindException
	 */
	protected function executeInitMethod($initMethod, $instance) {
		try {
			return $instance->$initMethod();
			// return call_user_func_array(array($instance, $initMethod),
			// array());
		} catch (Exception $e) {
			throw new WindException(
				'[base.WindFactory.executeInitMethod] (' . $initMethod . ', ' . $e->getMessage() . ')', 
				WindException::ERROR_CLASS_METHOD_NOT_EXIST);
		}
	}

	/**
	 * ,ش
	 * ͬǰӵְͬ͹,ͨʴʵǰ.
	 * ĴϢӦΪ<code><component
	 * proxy=''>...</component></code>'proxy'ΪfalseʱظĴ,
	 * ĬϵĴΪWindClassProxy,ͨý޸.
	 * 
	 * @param string $proxy        
	 * @param WindModule $instance        
	 * @return WindClassProxy
	 */
	protected function setProxyForClass($proxy, $listeners, $instance) {
		if (!$proxy) return $instance;
		if (true === $proxy) $proxy = $this->proxyType;
		/* @var $proxy WindClassProxy */
		$proxy = self::createInstance(Wind::import($proxy));
		$proxy->registerTargetObject($instance);
		foreach ($listeners as $key => $value) {
			$listener = WindFactory::createInstance(Wind::import($value));
			$proxy->registerEventListener($listener, $key);
		}
		// $instance->_proxy = $proxy;
		return $proxy;
	}

	/**
	 * Ϣ
	 * ϢӦΪ<code><properties delay=''><property property-name=''
	 * ref/value/path='' />
	 * </properties></code>ֵ֧ıǩΪ'delay','property-name','ref','value','path'.
	 * 'delay'Ϊtrueʱӳټ.'property-name'.'ref','value','path'Ƕֵַʽ,'ref'ָ,
	 * 'value'ֱԵֵ,'path'һԶ·,ϵͳԶԵĶ.
	 * 
	 * @param string $properties
	 *        Զ
	 * @param WindModule $instance
	 *        
	 * @return void
	 */
	protected function buildProperties($properties, $instance) {
		isset($properties['delay']) || $properties['delay'] = true;
		if ($properties['delay'] === 'false' || $properties['delay'] === false) {
			foreach ($properties as $key => $subDefinition) {
				$_value = '';
				if (isset($subDefinition['value']))
					$_value = $subDefinition['value'];
				elseif (isset($subDefinition['ref']))
					$_value = $this->getInstance($subDefinition['ref']);
				elseif (isset($subDefinition['path'])) {
					$_className = Wind::import($subDefinition['path']);
					$_value = $this->createInstance($_className);
				}
				$_setter = 'set' . ucfirst(trim($key, '_'));
				if (method_exists($instance, $_setter)) call_user_func_array(array($instance, $_setter), array($_value));
			}
		} else
			$instance->setDelayAttributes($properties);
	}

	/**
	 * 齨
	 *
	 * @return WindFactory
	 */
	public static function _getInstance() {
		if (!(self::$_instance instanceof self)) {
			self::$_instance = new self();
		}
		return self::$_instance;
	}
}