<?php
/**
 * moduleĻ
 * 
 * moduleлʵ˶Ե֧,:ý,ӳټ,Լṩȡķ.
 * Ҫùʽ,Ҫ̳и.֧config·.
 * 
 * @author Qiong Wu <papa0924@gmail.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id: WindModule.php 3850 2012-12-04 07:30:02Z yishuo $
 * @package base
 */
class WindModule {
	/**
	 * 
	 * 
	 * @var WindClassProxy
	 */
	public $_proxy = null;
	/**
	 * 
	 * 
	 * @var array
	 */
	protected $_config = array();
	/**
	 * ӳټزʹ,ҪӳټصϢ
	 * 
	 * @var array
	 */
	protected $_delayAttributes = array();

	/**
	 * ħ__set
	 * Էʲʱ÷,÷᳢ȥʶӦԵsetter,ʲôҲ
	 * 
	 * @param string $propertyName
	 * @param mixed $value
	 * @return void
	 */
	public function __set($propertyName, $value) {
		$_setter = 'set' . ucfirst($propertyName);
		if (method_exists($this, $_setter)) $this->$_setter($value);
	}

	/**
	 * ħ__get
	 * Էʲʱ÷,÷᳢ȥʶӦԵgetterضӦֵ,ʲôҲ
	 * 
	 * @param string $propertyName
	 * @return mixed
	 */
	public function __get($propertyName) {
		$_getter = 'get' . ucfirst($propertyName);
		if (method_exists($this, $_getter)) return $this->$_getter();
	}

	/**
	 * ħ__call
	 * ķʲʱø÷,ʵԶӳټز
	 * <code>
	 * //ӳٷĳ,ʹַʽʱ÷,ʸе$_delayAttributes,Զ󲢷
	 * $this->_getMethodName();
	 * </code>
	 * 
	 * @param string $methodName
	 * @param array $args
	 * @return mixed
	 */
	public function __call($methodName, $args) {
		$_prefix = substr($methodName, 0, 4);
		$_propertyName = substr($methodName, 4);
		$_propertyName = WindUtility::lcfirst($_propertyName);
		if ($_prefix == '_get') {
			if (!$this->$_propertyName && isset($this->_delayAttributes[$_propertyName])) {
				$_property = $this->_delayAttributes[$_propertyName];
				$_value = null;
				if (isset($_property['value'])) {
					$_value = $_property['value'];
				} elseif (isset($_property['ref'])) {
					$_value = Wind::getComponent($_property['ref'], $args);
				} elseif (isset($_property['path'])) {
					$_className = Wind::import($_property['path']);
					$_value = WindFactory::createInstance($_className, $args);
				}
				$this->$_propertyName = $_value;
			}
			return $this->$_propertyName;
		} elseif ($_prefix == '_set') {
			$this->$_propertyName = $args[0];
		}
	}

	/**
	 * ظö
	 * 
	 * @return array
	 */
	public function toArray() {
		$reflection = new ReflectionClass(get_class($this));
		$properties = $reflection->getProperties();
		$_result = array();
		foreach ($properties as $property) {
			$_propertyName = $property->name;
			$_result[$_propertyName] = $this->$_propertyName;
		}
		return $_result;
	}

	/**
	 * ȡӦ
	 * <i>configName</i>Ϊʱ򷵻.ֵʱĬֵ.ĬֵĬΪ
	 * 
	 * @param string $configName 
	 * @param string $subConfigName 
	 * @param string $default Ĭֵ
	 * @param array $config ⲿ
	 * @return mixed
	 */
	public function getConfig($configName = '', $subConfigName = '', $default = '', $config = array()) {
		if ($configName === '') return $this->_config;
		if (!isset($this->_config[$configName])) return $default;
		if ($subConfigName === '') return $this->_config[$configName];
		if (!isset($this->_config[$configName][$subConfigName])) return $default;
		return $this->_config[$configName][$subConfigName];
	}

	/**
	 * 
	 * Ϣ,Ѿ,Դúýкϲ.
	 * ظú߽ǰ.
	 * ֧·,ֵΪ·ʱýнԶ浱ǰֵ.(wind_configеisCacheֵǷ)
	 * 
	 * @param string|array $config
	 * @return void
	 */
	public function setConfig($config) {
		if ($config) {
			if (is_string($config)) {
				$config = Wind::getComponent('configParser')->parse($config, get_class($this), false, 
					Wind::getComponent('windCache'));
			}
			if (!empty($this->_config)) {
				$this->_config = array_merge($this->_config, (array) $config);
			} else
				$this->_config = $config;
		}
	}

	/**
	 * صǰӦõWindHttpRequest
	 * 
	 * @return WindHttpRequest
	 */
	protected function getRequest() {
		return Wind::getComponent('request');
	}

	/**
	 * صǰӦõWindHttpResponse
	 * 
	 * @return WindHttpResponse
	 */
	protected function getResponse() {
		return Wind::getComponent('response');
	}

	/**
	 * ӳټϢ
	 * 
	 * @param array $delayAttributes
	 * @return void
	 */
	public function setDelayAttributes($delayAttributes) {
		$this->_delayAttributes = array_merge($this->_delayAttributes, $delayAttributes);
	}
}