<?php
Wind::import('WIND:cache.exception.WindCacheException');
/**
 * ʵֵĻ
 * 
 * û̳˿ܵĻWindModule,ṩʵһЩ.ͬʱΪԵĻඨͨõĶԷʽӿ,Ҫʵֵĳӿ.
 * ˻ԷʵĽӿ:
 * <ul>
 * <li>{@link set}: 滺,Ҫʵ{@link setValue()}ʵֶӦķ.</li>
 * <li>{@link get}: û,Ҫʵ{@link getValue()}ʵֶӦķ.</li>
 * <li>{@link batchGet}: ȡ.</li>
 * <li>{@link delete}: ɾ,Ҫʵ{@link deleteValue()}ʵֶӦķ.</li>
 * <li>{@link batchDelete}: ɾ.</li>
 * </ul>
 * û֧{@link setConfig()}м̳и඼ӵжԸá
 * 
 * the last known user to change this file in the repository  <$LastChangedBy: yishuo $>
 * @author Su Qian <aoxue.1988.su.qian@163.com> 
 * @copyright 2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id: AbstractWindCache.php 3904 2013-01-08 07:01:26Z yishuo $ 
 * @package cache
 */
abstract class AbstractWindCache extends WindModule {
	/**
	 * keyİȫ
	 * 
	 * @var string
	 */
	private $securityCode = '';
	/**
	 * ǰ׺
	 * 
	 * @var sting 
	 */
	private $keyPrefix = '';
	/**
	 * ʱ
	 * 
	 * @var int
	 */
	private $expire = 0;
	/**
	 * 
	 * 
	 * @var string
	 */
	const DEPENDENCYCLASS = 'dependencyclass';
	/**
	 * ־洢ʱ
	 * 
	 * @var string
	 */
	const STORETIME = 'store';
	/**
	 * ־洢
	 * 
	 * @var string 
	 */
	const DATA = 'data';
	/**
	 * ļб־ƵĶ
	 * 
	 * @var string 
	 */
	const DEPENDENCY = 'dependency';
	/**
	 * ļб־ʱƶ(ҲԪйʱĶ)
	 * 
	 * @var string 
	 */
	const EXPIRE = 'expires';

	/**
	 * ִò
	 * 
	 * @param string $key ݵΨһkey
	 * @param string $value ֵֵһЧݵлַ
	 * @param int $expires ݱЧʱ䣬λΪ룬ĬʱΪ0
	 * @return boolean
	 * @throws WindException ʧܵʱ׳쳣
	 */
	protected abstract function setValue($key, $value, $expires = 0);

	/**
	 * ִӲ 
	 * 
	 * keyڵʱӣkeyѾʧ
	 * 
	 * @param string $key ݵΨһkey
	 * @param string $value ֵֵһЧݵлַ
	 * @param int $expires ݱЧʱ䣬λΪ룬ĬʱΪ0
	 * @return boolean
	 * @throws WindException ʧܵʱ׳쳣
	 */
	protected abstract function addValue($key, $value, $expires = 0);

	/**
	 * ִлȡ
	 * 
	 * @param string $key ݵΨһkey
	 * @return string  
	 * @throws WindException ݻȡʧ׳쳣
	 */
	protected abstract function getValue($key);

	/**
	 * Ҫʵֵɾ
	 * 
	 * @param string $key ҪɾĻݵkey
	 * @return boolean
	 */
	protected abstract function deleteValue($key);

	/**
	 * 棬ڼл
	 * 
	 * @return boolean
	 */
	public abstract function clear();

	/**
	 * û
	 * keyڣӻ棻򣬽滻keyĻ档
	 * 
	 * @param string $key 滺ݵļ
	 * @param string $value 滺ݡ
	 * @param int $expires ݵĹʱ,0ʾ
	 * @param IWindCacheDependency $denpendency 
	 * @return boolean
	 * @throws WindCacheException ʧʱ׳쳣
	 */
	public function set($key, $value, $expires = 0, IWindCacheDependency $dependency = null) {
		try {
			$expires = $expires ? $expires : $this->getExpire();
			$data = $this->buildData($value, $expires, $dependency);
			return $this->setValue($this->buildSecurityKey($key), $data, $expires);
		} catch (Exception $e) {
			throw new WindCacheException('[cache.AbstractWindCache.set] Setting cache failed.' . $e->getMessage());
		}
	}

	/**
	 * һĿ
	 * 
	 * ڻ֮ǰkeyʱ keyΪkey洢һvar
	 * <note><b>ע⣺</b>µԪصֵС0 Ԫزʱܴ</note> 
	 *
	 * @param string $key 滺ݵļ
	 * @param string $value 滺ݡ
	 * @param int $expires ݵĹʱ,0ʾ
	 * @param IWindCacheDependency $denpendency 
	 * @return boolean ɹʱ TRUE ʧʱ FALSE. keyѾڷFALSE
	 */
	public function add($key, $value, $expires = 0, IWindCacheDependency $dependency = null) {
		try {
			$key = $this->buildSecurityKey($key);
			$data = $this->getValue($key);
			if ($data) return false;
			$expires = $expires ? $expires : $this->getExpire();
			$data = $this->buildData($value, $expires, $dependency);
			return $this->addValue($key, $data, $expires);
		} catch (Exception $e) {
			throw new WindCacheException('[cache.AbstractWindCache.set] Setting cache failed.' . $e->getMessage());
		}
	}

	/**
	 * ݻkeyȡָ
	 * 
	 * @param string $key ȡݵıʶ,
	 * @return mixed ر
	 * @throws WindCacheException ȡʧʱ׳쳣
	 */
	public function get($key) {
		try {
			return $this->formatData($key, $this->getValue($this->buildSecurityKey($key)));
		} catch (Exception $e) {
			throw new WindCacheException('[cache.AbstractWindCache.get] Getting cache data failed. (' . $e->getMessage() . ')');
		}
	}

	/**
	 * ͨkeyȡ
	 * 
	 * @param array $keys key
	 * @return array keyӦĻɵĻ
	 */
	public function batchGet(array $keys) {
		$data = array();
		foreach ($keys as $key) {
			$data[$key] = $this->get($key);
		}
		return $data;
	}

	/**
	 * ɾ
	 * 
	 * @param string $key ȡݵıʶ
	 * @return boolean
	 * @throws WindCacheException ɾʧʱ׳쳣
	 */
	public function delete($key) {
		try {
			return $this->deleteValue($this->buildSecurityKey($key));
		} catch (Exception $e) {
			throw new WindCacheException('[cache.AbstractWindCache.delete] Delete cache data failed. (' . $e->getMessage() . ')');
		}
	}

	/**
	 * ͨkeyɾ
	 * 
	 * @param array $keys ҪɾĻkeyɵ
	 * @return boolean 
	 */
	public function batchDelete(array $keys) {
		foreach ($keys as $key)
			$this->delete($key);
		return true;
	}

	/**
	 * ָԪصֵvalue
	 * 
	 * ָkey ӦԪزֵͲҲܱתΪֵ Ὣֵ޸Ϊvalue.
	 * <note><b>ע⣺</b>keyӦԪزʱԪء</note> 
	 *
	 * @param string $key ҪֵԪصkey 
	 * @param int $step valueҪָԪֵӶ١ 
	 * @return int ɹʱµԪֵʧʱfalse 
	 */
	public function increment($key, $step = 1) {
		$data = $this->get($key);
		if (!is_numeric($data)) return false;
		$data += intval($step);
		$this->set($key, $data);
		return $data;
	}

	/**
	 * ԪصֵСvalue
	 * 
	 * ָkey ӦԪزֵͲҲܱתΪֵ Ὣֵ޸Ϊvalue.
	 * <note><b>ע⣺</b>µԪصֵС0 Ԫزʱܴ</note> 
	 *
	 * @param string $key ҪֵԪصkey 
	 * @param int $step valueָҪָԪصֵС١ 
	 * @return int ɹʱ򷵻Ԫصֵʧܵʱ򷵻false 
	 */
	public function decrement($key, $step = 1) {
		$data = $this->get($key);
		if (!is_numeric($data)) return false;
		$data -= intval($step);
		$data < 0 && $data = 0;
		$this->set($key, $data);
		return $data;
	}

	/**
	 * 챣
	 *
	 * @param string $value 滺ݡ
	 * @param int $expires ݵĹʱ,0ʾ
	 * @param IWindCacheDependency $denpendency 
	 * @return array
	 */
	protected function buildData($value, $expires = 0, IWindCacheDependency $dependency = null) {
		$data = array(
			self::DATA => $value, 
			self::EXPIRE => $expires, 
			self::STORETIME => time(), 
			self::DEPENDENCY => null, 
			self::DEPENDENCYCLASS => '');
		if (null !== $dependency) {
			$dependency->injectDependent(self::EXPIRE);
			$data[self::DEPENDENCY] = $dependency;
			$data[self::DEPENDENCYCLASS] = get_class($dependency);
		}
		return serialize($data);
	}

	/**
	 * ʽ
	 * 
	 * ӻлõĻԴݽиʽ.Դһʽõлַ,ҪлԴ.
	 * û,򷵻false
	 * ,򷵻ظ
	 * 
	 * @param string $key  keyֵ
	 * @param string $value ݵлֵ
	 * @return mixed رʵ,ûֵ򷵻false  
	 */
	protected function formatData($key, $value) {
		if (!$value) return false;
		$data = unserialize($value);
		return $this->hasChanged($key, $data) ? false : $data[self::DATA];
	}

	/**
	 * жǷѾ
	 * 
	 * ,黺ǷѾ,ɾ,ҷtrue.
	 * ûи򷵻false.
	 * 
	 * @param string $key key
	 * @param array  $data е
	 * @return boolean trueʾѱ,falseʾδ
	 */
	protected function hasChanged($key, array $data) {
		if ($data[self::DEPENDENCY]) {
			$dependency = $data[self::DEPENDENCY];
			if (!$dependency->hasChanged($this, $key, $data[self::EXPIRE])) return false;
		} elseif ($data[self::EXPIRE]) {
			$_overTime = $data[self::EXPIRE] + $data[self::STORETIME];
			if ($_overTime >= time()) return false;
		} else
			return false;
		$this->delete($key);
		return true;
	}

	/**
	 * keyɰȫkey
	 * 
	 * @param string $key ʵĻkey
	 * @return string 밲ȫ֮󷵻صıkey
	 */
	protected function buildSecurityKey($key) {
		$this->keyPrefix && $key = $this->keyPrefix . '_' . $key;
		return $key . $this->getSecurityCode();
	}

	/**
	 * ػKeyֵǰ׺
	 * 
	 * ĬֵΪnullκǰ׺
	 * 
	 * @return string $prefix keyǰ׺
	 */
	protected function getKeyPrefix() {
		return $this->keyPrefix;
	}

	/**
	 * keyǰ׺
	 * 
	 * @param sting $keyPrefix keyǰ׺
	 */
	public function setKeyPrefix($keyPrefix) {
		$this->keyPrefix = $keyPrefix;
	}

	/**
	 * ûkeyмİȫ
	 * 
	 * @return string $securityCode
	 */
	protected function getSecurityCode() {
		return $this->securityCode;
	}

	/**
	 * ûkeyмİȫ
	 * 
	 * @param string $securityCode ȫ
	 */
	public function setSecurityCode($securityCode) {
		$this->securityCode = $securityCode;
	}

	/**
	 * عʱ
	 * 
	 * λΪ룬ĬֵΪ0
	 * 
	 * @return int $expire ʱ䣬ĬΪ0ڣλΪ
	 */
	public function getExpire() {
		return $this->expire;
	}

	/**
	 * ûʱ
	 * 
	 * λΪ,ĬΪ0
	 * 
	 * @param int $expire ʱ,λΪ,ĬΪ0
	 */
	public function setExpire($expire) {
		$this->expire = intval($expire);
	}

	/**
	 * Ϣ
	 * 
	 * ֧: 
	 * <ul>
	 * <li><i>security-code</i>: ȫ</li>
	 * <li><i>key-prefix</i>: keyǰ׺</li>
	 * <li><i>expires</i>: ʱ,λΪ,ĬΪ0</li>
	 * </ul>
	 * 
	 * @param array $config Ϣ
	 */
	public function setConfig($config) {
		parent::setConfig($config);
		$this->setSecurityCode($this->getConfig('security-code', '', ''));
		$this->setKeyPrefix($this->getConfig('key-prefix', '', ''));
		$this->setExpire($this->getConfig('expires', '', 0));
	}
}