<?php
Wind::import('WIND:cache.AbstractWindCache');
/**
 * ApcCacheʵ
 * 
 * ApcCache̳AbstractWindCache,ʵָṩĸԲӿ.
 * ṩԷʽӿ:
 * <ul>
 *   <li>set($key, $value, $expire): ̳{@link AbstractWindCache::set()}.</li>
 *   <li>get($key): ̳{@link AbstractWindCache::get()}.</li>
 *   <li>delete($key): ̳{@link AbstractWindCache::delete()}.</li>
 *   <li>batchGet($keys): ̳{@link AbstractWindCache::batchGet()}.</li>
 *   <li>batchDelete($keys): ̳{@link AbstractWindCache::batchDelete()}.</li>
 *   <li>setConfig($config): ̳{@link AbstractWindCache::setConfig()}.</li>
 * </ul>
 * ûԴAbstractWindCacheм̳
 * <code>
 *  array(
 *  	'security-code' => '',	//̳AbstractWindCache,ȫ
 * 		'key-prefix' => '',		//̳AbstractWindCache,keyǰ׺
 *      'expires' => '0',	//̳AbstractWindCache,ʱ
 *  )
 * </code>
 * <i>ʹ÷ʽ</i><br/>
 * 1ʹͨһʹø,:
 * <code>
 * Wind::import('WIND:cache.strategy.WindApcCache');
 * $cache = new WindApcCache();
 * $cache->set('name', 'windframework');
 * </code>
 * 
 * 2ͬʱΪ,WindApcCacheҲûͨõ÷ʽ,ͨܵøûв.
 * Ӧеÿ(components),ʹø£
 * <code>
 *  'apcCache' => array(
 *		'path' => 'WIND:cache.strategy.WindApcCache',
 *		'scope' => 'singleton',
 *		'config' => array(
 *			'security-code' => '', 
 * 	    	'key-prefix' => '',
 *      	'expires' => '0',
 *		),
 *	),
 * </code>
 * Ӧͨ·ʽʹ:
 * <code>
 * $cache = Wind::getComponent('apcCache');	//עapcCacheƺõҪӦ
 * $cache->set('name', 'wf');
 * </code>
 * õ˵οһ.
 * 
 * <note><b>ע: </b>ҪʹApcCache,Ҫװapcչ֧.</note>
 * 
 * the last known user to change this file in the repository  <LastChangedBy: xiaoxiao >
 * @author xiaoxiao <xiaoxia.xuxx@aliyun-inc.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id: WindApcCache.php 3791 2012-10-30 04:01:29Z liusanbian $
 * @package strategy
 */
class WindApcCache extends AbstractWindCache {

	/* (non-PHPdoc)
	 * @see AbstractWindCache::setValue()
	 */
	protected function setValue($key, $value, $expires = 0) {
		return apc_store($key, $value, $expires);
	}

	/* (non-PHPdoc)
	 * @see AbstractWindCache::getValue()
	 */
	protected function getValue($key) {
		return apc_fetch($key);
	}

	/* (non-PHPdoc)
	 * @see AbstractWindCache::deleteValue()
	 */
	protected function deleteValue($key) {
		return apc_delete($key);
	}

	/*(non-PHPdoc)
	 * @see AbstractWindCache::clear()
	 */
	public function clear() {
		return apc_clear_cache('user');
	}
	
	/* (non-PHPdoc)
	 * @see AbstractWindCache::addValue()
	 */
	public function addValue($key, $value, $expires = 0) {
		return apc_add($key, $value, $expires);
	}
}